/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.lstmStuff.gameThingy;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CarGame
extends JPanel
implements KeyListener,
Runnable {
    public JFrame frame;
    private BufferedImage roadImage;
    private final int maxCars = 5;
    private List<Car> currCars = new ArrayList<Car>(5);
    private Car playerCar;
    private final int width = 84;
    private final int height = 84;
    private final int scale = 4;
    private final int framesPerRound = 200;
    private final double updownSpeed = 1.5;
    private BufferedImage image;
    private Graphics2D g2;
    private Graphics g = null;
    private boolean running = false;
    private double score = 0.0;
    private int lives;
    private int scoreDisplayTimer = 0;
    private int currentFrame = 0;
    private boolean gameOver = false;
    private boolean userInput = true;
    private boolean up = false;
    private boolean down = false;
    private boolean left = false;
    private boolean right = false;
    private double currSpeed = 0.1;
    private double roadX = 0.0;
    private Thread t;
    private Random random = new Random();
    private static final Color carColor = new Color(0, 148, 255);
    private static final Color carColor2 = new Color(0, 22, 38);
    private static final Color playerCarColor = new Color(255, 144, 255);
    private static final Color playerCarColor2 = new Color(38, 21, 38);

    public CarGame() {
        try {
            this.roadImage = ImageIO.read(new File("road.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.roadImage = new BufferedImage(94, 84, 1);
        }
        this.setPreferredSize(new Dimension(336, 336));
        this.setFocusable(true);
        this.requestFocus();
        this.setLayout(null);
        this.addKeyListener(this);
    }

    public void init() {
        this.image = new BufferedImage(84, 84, 1);
        this.g2 = (Graphics2D)this.image.getGraphics();
        this.g2.setFont(new Font("Monospaced", 1, 24));
        while (this.g == null) {
            this.g = this.getGraphics();
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.currCars.clear();
        this.score = 0.0;
        this.up = false;
        this.down = false;
        this.left = false;
        this.right = false;
        this.currSpeed = 0.0;
        this.gameOver = false;
        this.currSpeed = 0.1;
        this.roadX = 0.0;
        this.playerCar = new Car(this.currSpeed, false, 11, 37);
        this.currentFrame = 0;
        this.scoreDisplayTimer = 0;
        this.lives = 2;
    }

    public void startGame() {
        this.t = new Thread(this);
        this.t.start();
    }

    @Override
    public void run() {
        this.init();
        this.running = true;
        long targetTime = 33333333L;
        long timer = System.nanoTime();
        long debugTimer = System.currentTimeMillis();
        int fps = 0;
        while (this.running) {
            if (System.nanoTime() - timer >= targetTime) {
                timer = System.nanoTime();
                this.update();
                this.draw();
                ++fps;
            }
            if (this.gameOver) {
                this.running = false;
            }
            if (System.currentTimeMillis() - debugTimer >= 1000L) {
                debugTimer = System.currentTimeMillis();
                System.out.println("FPS: " + Integer.toString(fps));
                fps = 0;
            }
            try {
                Thread.sleep(2L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void create() {
        this.frame = new JFrame("Car Game");
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setContentPane(this);
        this.frame.addKeyListener(this);
        this.frame.pack();
        this.frame.setVisible(true);
        this.setFocusable(true);
        this.requestFocus();
    }

    public void destroy() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public void update() {
        int y;
        this.currSpeed += 0.005;
        int i = 0;
        while (i < this.currCars.size()) {
            this.currCars.get(i).changeSpeed(0.01);
            this.currCars.get(i).updatePosition();
            if (this.currCars.get(i).getX() > 104.0 || this.currCars.get(i).getX() < -20.0) {
                this.currCars.remove(i);
                --i;
            }
            ++i;
        }
        if (this.currCars.size() < 5 && this.random.nextInt(5) == 0 && (y = this.random.nextInt(84)) < 82) {
            boolean left = y > 37;
            Car c = new Car(this.random.nextDouble() * 0.35, left, left ? 94 : -10, y);
            c.changeSpeed(this.currSpeed);
            this.currCars.add(c);
        }
        i = 0;
        while (i < this.currCars.size()) {
            if (this.playerCar.collidesWith(this.currCars.get(i))) {
                this.score -= 1.0 + this.currSpeed;
                --this.lives;
                this.currCars.remove(i);
                --i;
                for (Car c : this.currCars) {
                    c.changeSpeed(-this.currSpeed);
                }
                this.currSpeed = 0.1;
            }
            ++i;
        }
        if (this.up && !this.down) {
            this.playerCar.setY(this.playerCar.getY() - 1.5);
            if (this.playerCar.getY() < 0.0) {
                this.playerCar.setY(0.0);
            }
        }
        if (this.down && !this.up) {
            this.playerCar.setY(this.playerCar.getY() + 1.5);
            if (this.playerCar.getY() > 92.0) {
                this.playerCar.setY(92.0);
            }
        }
        if (this.right && !this.left) {
            this.playerCar.setX(this.playerCar.getX() + 1.5);
            if (this.playerCar.getX() > 74.0) {
                this.playerCar.setX(74.0);
            }
        }
        if (this.left && !this.right) {
            this.playerCar.setX(this.playerCar.getX() - 1.5);
            if (this.playerCar.getX() < 0.0) {
                this.playerCar.setX(0.0);
            }
        }
        ++this.currentFrame;
        if (this.currentFrame >= 200) {
            this.score += 1.0 + this.currSpeed;
            this.scoreDisplayTimer = 30;
            this.currentFrame = 0;
        }
        if (this.lives <= 0) {
            this.gameOver = true;
        }
    }

    public void draw() {
        this.roadX += this.currSpeed;
        if (this.roadX > (double)this.roadImage.getWidth()) {
            this.roadX -= (double)this.roadImage.getWidth();
        }
        int firstRoadScreenX = (int)(-this.roadX);
        int secondRoadScreenX = this.roadImage.getWidth() + firstRoadScreenX;
        this.g2.setColor(Color.BLACK);
        this.g2.fillRect(0, 0, 84, 84);
        this.g2.drawImage(this.roadImage, firstRoadScreenX, 0, this.roadImage.getWidth(), this.roadImage.getHeight(), null);
        this.g2.drawImage(this.roadImage, secondRoadScreenX, 0, this.roadImage.getWidth(), this.roadImage.getHeight(), null);
        this.renderCar(this.playerCar, playerCarColor, playerCarColor2);
        for (Car c : this.currCars) {
            this.renderCar(c, carColor, carColor2);
        }
        if (this.scoreDisplayTimer > 0) {
            --this.scoreDisplayTimer;
            if (this.scoreDisplayTimer % 2 == 0) {
                this.g2.setColor(Color.RED);
                this.g2.drawString("LAP!", 42 - this.g2.getFontMetrics().stringWidth("LAP!") / 2, 42 - this.g2.getFontMetrics().getHeight() / 2);
            }
        }
        this.g.drawImage(this.image, 0, 0, 336, 336, null);
    }

    private void renderCar(Car car, Color c1, Color c2) {
        int x = (int)car.getX();
        int y = (int)car.getY();
        this.g2.setColor(c1);
        int i = 0;
        while (i < 4) {
            this.g2.drawLine(x, y + 2 + i, x + 10, y + 2 + i);
            ++i;
        }
        if (!car.movingLeft) {
            this.g2.setColor(c2);
            this.g2.fillRect(x, y, 2, 2);
            this.g2.fillRect(x + 6, y, 2, 2);
            this.g2.fillRect(x, y + 6, 2, 2);
            this.g2.fillRect(x + 6, y + 6, 2, 2);
        } else {
            this.g2.setColor(c2);
            this.g2.fillRect(x + 2, y, 2, 2);
            this.g2.fillRect(x + 6 + 2, y, 2, 2);
            this.g2.fillRect(x + 2, y + 6, 2, 2);
            this.g2.fillRect(x + 6 + 2, y + 6, 2, 2);
        }
        this.g2.setColor(Color.RED);
    }

    public static void main(String[] args) {
        CarGame f = new CarGame();
        f.create();
        f.startGame();
        f.setUseUserInput(true);
        System.out.println(f.isUsingUserInput());
    }

    public void renderNextFrame() {
        this.update();
        this.draw();
    }

    public BufferedImage getCurrentFrame() {
        return this.image;
    }

    public void setUp(boolean up) {
        this.up = up;
    }

    public void setDown(boolean down) {
        this.down = down;
    }

    public void setLeft(boolean left) {
        this.left = left;
    }

    public void setRight(boolean right) {
        this.right = right;
    }

    public boolean getUp() {
        return this.up;
    }

    public boolean getDown() {
        return this.down;
    }

    public boolean getLeft() {
        return this.left;
    }

    public boolean getRight() {
        return this.right;
    }

    public double getScore() {
        return this.score;
    }

    public int getExtraLives() {
        return this.lives;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public void setUseUserInput(boolean useUserInput) {
        this.userInput = useUserInput;
    }

    public boolean isUsingUserInput() {
        return this.userInput;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.userInput) {
            if (e.getKeyCode() == 38) {
                this.up = true;
            }
            if (e.getKeyCode() == 40) {
                this.down = true;
            }
            if (e.getKeyCode() == 37) {
                this.left = true;
            }
            if (e.getKeyCode() == 39) {
                this.right = true;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.userInput) {
            if (e.getKeyCode() == 38) {
                this.up = false;
            }
            if (e.getKeyCode() == 40) {
                this.down = false;
            }
            if (e.getKeyCode() == 37) {
                this.left = false;
            }
            if (e.getKeyCode() == 39) {
                this.right = false;
            }
        }
    }

    private class Car {
        private double x = 0.0;
        private double y = 0.0;
        private double speed;
        private boolean movingLeft;
        private Rectangle rect;

        public Car(double speed, boolean movingLeft, int x, int y) {
            this.speed = speed;
            this.movingLeft = movingLeft;
            this.x = x;
            this.y = y;
            this.rect = new Rectangle(x, y + 2, 9, 3);
        }

        public void changeSpeed(double change) {
            this.speed += change;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
            this.rect.x = (int)this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
            this.rect.y = (int)this.y + 2;
        }

        public void updatePosition() {
            this.x = this.movingLeft ? (this.x -= this.speed) : (this.x += this.speed);
            this.rect.x = (int)this.x;
        }

        public boolean collidesWith(Car c) {
            return c.rect.intersects(this.rect);
        }
    }
}

