/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.StructBuffer;

public final class Checks {
    public static final boolean CHECKS = Configuration.DISABLE_CHECKS.get(false) == false;
    public static final boolean DEBUG = Configuration.DEBUG.get(false);
    public static final boolean DEBUG_FUNCTIONS = Configuration.DEBUG_FUNCTIONS.get(false);

    private Checks() {
    }

    public static int lengthSafe(short[] array) {
        return array == null ? 0 : array.length;
    }

    public static int lengthSafe(int[] array) {
        return array == null ? 0 : array.length;
    }

    public static int lengthSafe(long[] array) {
        return array == null ? 0 : array.length;
    }

    public static int lengthSafe(float[] array) {
        return array == null ? 0 : array.length;
    }

    public static int lengthSafe(double[] array) {
        return array == null ? 0 : array.length;
    }

    public static int remainingSafe(Buffer buffer) {
        return buffer == null ? 0 : buffer.remaining();
    }

    public static int remainingSafe(CustomBuffer<?> buffer) {
        return buffer == null ? 0 : buffer.remaining();
    }

    public static boolean checkFunctions(long ... functions) {
        for (long pointer : functions) {
            if (pointer != 0L) continue;
            return false;
        }
        return true;
    }

    public static long check(long pointer) {
        if (pointer == 0L) {
            throw new NullPointerException();
        }
        return pointer;
    }

    public static void checkNT(int[] buf) {
        Checks.checkNT(buf, 0);
    }

    public static void checkNT(int[] buf, int terminator) {
        Checks.check(buf, 1);
        if (buf[buf.length - 1] != terminator) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT(long[] buf) {
        Checks.check(buf, 1);
        if (buf[buf.length - 1] != 0L) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT(float[] buf) {
        Checks.check(buf, 1);
        if (buf[buf.length - 1] != 0.0f) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT1(ByteBuffer buf) {
        Checks.check((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
    }

    public static void checkNT2(ByteBuffer buf) {
        Checks.check((Buffer)buf, 2);
        if (buf.getShort(buf.limit() - 2) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
    }

    public static void checkNT(IntBuffer buf) {
        Checks.checkNT(buf, 0);
    }

    public static void checkNT(IntBuffer buf, int terminator) {
        Checks.check((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != terminator) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT(LongBuffer buf) {
        Checks.check((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0L) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT(FloatBuffer buf) {
        Checks.check((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0.0f) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNT(PointerBuffer buf) {
        Checks.checkNT(buf, 0L);
    }

    public static void checkNT(PointerBuffer buf, long terminator) {
        Checks.check(buf, 1);
        if (buf.get(buf.limit() - 1) != terminator) {
            throw new IllegalArgumentException("Missing termination");
        }
    }

    public static void checkNTSafe(int[] buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNTSafe(int[] buf, int terminator) {
        if (buf != null) {
            Checks.checkNT(buf, terminator);
        }
    }

    public static void checkNTSafe(long[] buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNTSafe(float[] buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNT1Safe(ByteBuffer buf) {
        if (buf != null) {
            Checks.checkNT1(buf);
        }
    }

    public static void checkNT2Safe(ByteBuffer buf) {
        if (buf != null) {
            Checks.checkNT2(buf);
        }
    }

    public static void checkNTSafe(IntBuffer buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNTSafe(IntBuffer buf, int terminator) {
        if (buf != null) {
            Checks.checkNT(buf, terminator);
        }
    }

    public static void checkNTSafe(LongBuffer buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNTSafe(FloatBuffer buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNTSafe(PointerBuffer buf) {
        if (buf != null) {
            Checks.checkNT(buf);
        }
    }

    public static void checkNTSafe(PointerBuffer buf, long terminator) {
        if (buf != null) {
            Checks.checkNT(buf, terminator);
        }
    }

    public static void check(byte[] buf, int size) {
        if (buf.length < size) {
            Checks.throwIAE(buf, size);
        }
    }

    public static void check(short[] buf, int size) {
        if (buf.length < size) {
            Checks.throwIAE(buf, size);
        }
    }

    public static void check(int[] buf, int size) {
        if (buf.length < size) {
            Checks.throwIAE(buf, size);
        }
    }

    public static void check(long[] buf, int size) {
        if (buf.length < size) {
            Checks.throwIAE(buf, size);
        }
    }

    public static void check(float[] buf, int size) {
        if (buf.length < size) {
            Checks.throwIAE(buf, size);
        }
    }

    public static void check(double[] buf, int size) {
        if (buf.length < size) {
            Checks.throwIAE(buf, size);
        }
    }

    public static void check(CharSequence text, int size) {
        if (text.length() < size) {
            Checks.throwIAE(text, size);
        }
    }

    public static void check(Buffer buf, int size) {
        if (buf.remaining() < size) {
            Checks.throwIAE(buf, size);
        }
    }

    public static void check(Buffer buf, long size) {
        Checks.check(buf, (int)size);
    }

    public static void check(CustomBuffer<?> buf, int size) {
        if (buf.remaining() < size) {
            Checks.throwIAE(buf, size);
        }
    }

    public static void check(CustomBuffer<?> buf, long size) {
        Checks.check(buf, (int)size);
    }

    public static void checkSafe(short[] buf, int size) {
        if (buf != null) {
            Checks.check(buf, size);
        }
    }

    public static void checkSafe(int[] buf, int size) {
        if (buf != null) {
            Checks.check(buf, size);
        }
    }

    public static void checkSafe(long[] buf, int size) {
        if (buf != null) {
            Checks.check(buf, size);
        }
    }

    public static void checkSafe(float[] buf, int size) {
        if (buf != null) {
            Checks.check(buf, size);
        }
    }

    public static void checkSafe(double[] buf, int size) {
        if (buf != null) {
            Checks.check(buf, size);
        }
    }

    public static void checkSafe(Buffer buf, int size) {
        if (buf != null) {
            Checks.check(buf, size);
        }
    }

    public static void checkSafe(Buffer buf, long size) {
        if (buf != null) {
            Checks.check(buf, size);
        }
    }

    public static void checkSafe(CustomBuffer<?> buf, int size) {
        if (buf != null) {
            Checks.check(buf, size);
        }
    }

    public static void check(Object[] array, int size) {
        if (array.length < size) {
            Checks.throwIAE(array, size);
        }
    }

    public static void checkGT(Buffer buf, int size) {
        if (size < buf.remaining()) {
            Checks.throwIAEGT(buf, size);
        }
    }

    public static void checkGT(CustomBuffer<?> buf, int size) {
        if (size < buf.remaining()) {
            Checks.throwIAEGT(buf, size);
        }
    }

    public static void checkGT(StructBuffer<?, ?> buf, int size) {
        if (size < buf.remaining()) {
            Checks.throwIAEGT(buf, size);
        }
    }

    public static void check(int index, int size) {
        if (index < 0 || size <= index) {
            Checks.throwIOBE(index, size);
        }
    }

    private static void throwIAE(Buffer buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at least " + size);
    }

    private static void throwIAE(CustomBuffer<?> buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at least " + size);
    }

    private static void throwIAE(Object[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwIAE(byte[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwIAE(short[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwIAE(int[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwIAE(long[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwIAE(float[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwIAE(double[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwIAE(CharSequence text, int size) {
        throw new IllegalArgumentException("Number of characters is " + text.length() + ", must be at least " + size);
    }

    private static void throwIAEGT(Buffer buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at most " + size + ".");
    }

    private static void throwIAEGT(CustomBuffer<?> buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at most " + size + ".");
    }

    private static void throwIOBE(int index, int size) {
        throw new IndexOutOfBoundsException("Index is " + index + ", must be between 0 and  " + (size - 1));
    }

    static {
        if (DEBUG_FUNCTIONS && !DEBUG) {
            APIUtil.DEBUG_STREAM.println("[LWJGL] The DEBUG_FUNCTIONS option requires DEBUG to produce output.");
        }
    }
}

