/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTDrawElementsBaseVertex {
    protected EXTDrawElementsBaseVertex() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps, Set<String> ext) {
        return Checks.checkFunctions(caps.glDrawElementsBaseVertexEXT, ext.contains("GLES30") ? caps.glDrawRangeElementsBaseVertexEXT : -1L, ext.contains("GLES30") ? caps.glDrawElementsInstancedBaseVertexEXT : -1L, ext.contains("GL_EXT_multi_draw_arrays") ? caps.glMultiDrawElementsBaseVertexEXT : -1L);
    }

    public static native void nglDrawElementsBaseVertexEXT(int var0, int var1, int var2, long var3, int var5);

    public static void glDrawElementsBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="GLsizei") int count, @NativeType(value="GLenum") int type, @NativeType(value="const void *") long indices, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="GLenum") int type, @NativeType(value="const void *") ByteBuffer indices, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="const void *") ByteBuffer indices, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="const void *") ShortBuffer indices, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="const void *") IntBuffer indices, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsBaseVertexEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static native void nglDrawRangeElementsBaseVertexEXT(int var0, int var1, int var2, int var3, int var4, long var5, int var7);

    public static void glDrawRangeElementsBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="GLuint") int start, @NativeType(value="GLuint") int end, @NativeType(value="GLsizei") int count, @NativeType(value="GLenum") int type, @NativeType(value="const void *") long indices, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="GLuint") int start, @NativeType(value="GLuint") int end, @NativeType(value="GLenum") int type, @NativeType(value="const void *") ByteBuffer indices, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="GLuint") int start, @NativeType(value="GLuint") int end, @NativeType(value="const void *") ByteBuffer indices, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="GLuint") int start, @NativeType(value="GLuint") int end, @NativeType(value="const void *") ShortBuffer indices, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="GLuint") int start, @NativeType(value="GLuint") int end, @NativeType(value="const void *") IntBuffer indices, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawRangeElementsBaseVertexEXT(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static native void nglDrawElementsInstancedBaseVertexEXT(int var0, int var1, int var2, long var3, int var5, int var6);

    public static void glDrawElementsInstancedBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="GLsizei") int count, @NativeType(value="GLenum") int type, @NativeType(value="const void *") long indices, @NativeType(value="GLsizei") int instancecount, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, count, type, indices, instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="GLenum") int type, @NativeType(value="const void *") ByteBuffer indices, @NativeType(value="GLsizei") int instancecount, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="const void *") ByteBuffer indices, @NativeType(value="GLsizei") int instancecount, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="const void *") ShortBuffer indices, @NativeType(value="GLsizei") int instancecount, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="const void *") IntBuffer indices, @NativeType(value="GLsizei") int instancecount, @NativeType(value="GLint") int basevertex) {
        EXTDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertexEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), instancecount, basevertex);
    }

    public static native void nglMultiDrawElementsBaseVertexEXT(int var0, long var1, int var3, long var4, int var6, long var7);

    public static void glMultiDrawElementsBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="const GLsizei *") IntBuffer count, @NativeType(value="GLenum") int type, @NativeType(value="const void * const *") PointerBuffer indices, @NativeType(value="const GLint *") IntBuffer basevertex) {
        if (Checks.CHECKS) {
            Checks.check(indices, count.remaining());
            Checks.check((Buffer)basevertex, count.remaining());
        }
        EXTDrawElementsBaseVertex.nglMultiDrawElementsBaseVertexEXT(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), count.remaining(), MemoryUtil.memAddress(basevertex));
    }

    public static void glMultiDrawElementsBaseVertexEXT(@NativeType(value="GLenum") int mode, @NativeType(value="const GLsizei *") int[] count, @NativeType(value="GLenum") int type, @NativeType(value="const void * const *") PointerBuffer indices, @NativeType(value="const GLint *") int[] basevertex) {
        long __functionAddress = GLES.getICD().glMultiDrawElementsBaseVertexEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(indices, count.length);
            Checks.check(basevertex, count.length);
        }
        JNI.callPPPV(__functionAddress, mode, count, type, MemoryUtil.memAddress(indices), count.length, basevertex);
    }

    static {
        GLES.initialize();
    }
}

