/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIVector2D;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIUVTransform
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTRANSLATION;
    public static final int MSCALING;
    public static final int MROTATION;

    AIUVTransform(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIUVTransform(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIUVTransform.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public AIVector2D mTranslation() {
        return AIUVTransform.nmTranslation(this.address());
    }

    public AIVector2D mScaling() {
        return AIUVTransform.nmScaling(this.address());
    }

    public float mRotation() {
        return AIUVTransform.nmRotation(this.address());
    }

    public static AIUVTransform malloc() {
        return AIUVTransform.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIUVTransform calloc() {
        return AIUVTransform.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIUVTransform create() {
        return new AIUVTransform(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIUVTransform create(long address) {
        return address == 0L ? null : new AIUVTransform(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIUVTransform.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIUVTransform.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIUVTransform mallocStack() {
        return AIUVTransform.mallocStack(MemoryStack.stackGet());
    }

    public static AIUVTransform callocStack() {
        return AIUVTransform.callocStack(MemoryStack.stackGet());
    }

    public static AIUVTransform mallocStack(MemoryStack stack) {
        return AIUVTransform.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIUVTransform callocStack(MemoryStack stack) {
        return AIUVTransform.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIUVTransform.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIUVTransform.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIUVTransform.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIUVTransform.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIVector2D nmTranslation(long struct) {
        return AIVector2D.create(struct + (long)MTRANSLATION);
    }

    public static AIVector2D nmScaling(long struct) {
        return AIVector2D.create(struct + (long)MSCALING);
    }

    public static float nmRotation(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MROTATION);
    }

    static {
        Struct.Layout layout = AIUVTransform.__struct(AIUVTransform.__member(AIVector2D.SIZEOF, AIVector2D.ALIGNOF), AIUVTransform.__member(AIVector2D.SIZEOF, AIVector2D.ALIGNOF), AIUVTransform.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTRANSLATION = layout.offsetof(0);
        MSCALING = layout.offsetof(1);
        MROTATION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIUVTransform, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIUVTransform newInstance(long address) {
            return new AIUVTransform(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public AIVector2D mTranslation() {
            return AIUVTransform.nmTranslation(this.address());
        }

        public AIVector2D mScaling() {
            return AIUVTransform.nmScaling(this.address());
        }

        public float mRotation() {
            return AIUVTransform.nmRotation(this.address());
        }
    }
}

