/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIString
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LENGTH;
    public static final int DATA;

    AIString(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIString(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIString.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long length() {
        return AIString.nlength(this.address());
    }

    public ByteBuffer data() {
        return AIString.ndata(this.address());
    }

    public String dataString() {
        return AIString.ndataString(this.address());
    }

    public AIString data(ByteBuffer value) {
        AIString.ndata(this.address(), value);
        return this;
    }

    public AIString set(AIString src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AIString malloc() {
        return AIString.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIString calloc() {
        return AIString.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIString create() {
        return new AIString(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIString create(long address) {
        return address == 0L ? null : new AIString(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIString.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIString.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIString mallocStack() {
        return AIString.mallocStack(MemoryStack.stackGet());
    }

    public static AIString callocStack() {
        return AIString.callocStack(MemoryStack.stackGet());
    }

    public static AIString mallocStack(MemoryStack stack) {
        return AIString.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIString callocStack(MemoryStack stack) {
        return AIString.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIString.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIString.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIString.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIString.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nlength(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LENGTH);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DATA, (int)AIString.nlength(struct));
    }

    public static String ndataString(long struct) {
        return MemoryUtil.memUTF8(AIString.ndata(struct));
    }

    public static void nlength(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)LENGTH, value);
    }

    public static void ndata(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 1024);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress(value), (long)(struct + (long)DATA), (int)value.remaining());
        AIString.nlength(struct, value.remaining() - 1);
    }

    static {
        Struct.Layout layout = AIString.__struct(AIString.__member(POINTER_SIZE), AIString.__array(1, 1024));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LENGTH = layout.offsetof(0);
        DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIString, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIString newInstance(long address) {
            return new AIString(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long length() {
            return AIString.nlength(this.address());
        }

        public ByteBuffer data() {
            return AIString.ndata(this.address());
        }

        public String dataString() {
            return AIString.ndataString(this.address());
        }

        public Buffer data(ByteBuffer value) {
            AIString.ndata(this.address(), value);
            return this;
        }
    }
}

