/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIQuatKey;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVectorKey;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AINodeAnim
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNODENAME;
    public static final int MNUMPOSITIONKEYS;
    public static final int MPOSITIONKEYS;
    public static final int MNUMROTATIONKEYS;
    public static final int MROTATIONKEYS;
    public static final int MNUMSCALINGKEYS;
    public static final int MSCALINGKEYS;
    public static final int MPRESTATE;
    public static final int MPOSTSTATE;

    AINodeAnim(long address, ByteBuffer container) {
        super(address, container);
    }

    public AINodeAnim(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AINodeAnim.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public AIString mNodeName() {
        return AINodeAnim.nmNodeName(this.address());
    }

    public int mNumPositionKeys() {
        return AINodeAnim.nmNumPositionKeys(this.address());
    }

    public AIVectorKey.Buffer mPositionKeys() {
        return AINodeAnim.nmPositionKeys(this.address());
    }

    public int mNumRotationKeys() {
        return AINodeAnim.nmNumRotationKeys(this.address());
    }

    public AIQuatKey.Buffer mRotationKeys() {
        return AINodeAnim.nmRotationKeys(this.address());
    }

    public int mNumScalingKeys() {
        return AINodeAnim.nmNumScalingKeys(this.address());
    }

    public AIVectorKey.Buffer mScalingKeys() {
        return AINodeAnim.nmScalingKeys(this.address());
    }

    public int mPreState() {
        return AINodeAnim.nmPreState(this.address());
    }

    public int mPostState() {
        return AINodeAnim.nmPostState(this.address());
    }

    public AINodeAnim mNodeName(AIString value) {
        AINodeAnim.nmNodeName(this.address(), value);
        return this;
    }

    public AINodeAnim mPositionKeys(AIVectorKey.Buffer value) {
        AINodeAnim.nmPositionKeys(this.address(), value);
        return this;
    }

    public AINodeAnim mRotationKeys(AIQuatKey.Buffer value) {
        AINodeAnim.nmRotationKeys(this.address(), value);
        return this;
    }

    public AINodeAnim mScalingKeys(AIVectorKey.Buffer value) {
        AINodeAnim.nmScalingKeys(this.address(), value);
        return this;
    }

    public AINodeAnim mPreState(int value) {
        AINodeAnim.nmPreState(this.address(), value);
        return this;
    }

    public AINodeAnim mPostState(int value) {
        AINodeAnim.nmPostState(this.address(), value);
        return this;
    }

    public AINodeAnim set(AIString mNodeName, AIVectorKey.Buffer mPositionKeys, AIQuatKey.Buffer mRotationKeys, AIVectorKey.Buffer mScalingKeys, int mPreState, int mPostState) {
        this.mNodeName(mNodeName);
        this.mPositionKeys(mPositionKeys);
        this.mRotationKeys(mRotationKeys);
        this.mScalingKeys(mScalingKeys);
        this.mPreState(mPreState);
        this.mPostState(mPostState);
        return this;
    }

    public AINodeAnim set(AINodeAnim src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AINodeAnim malloc() {
        return AINodeAnim.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AINodeAnim calloc() {
        return AINodeAnim.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AINodeAnim create() {
        return new AINodeAnim(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AINodeAnim create(long address) {
        return address == 0L ? null : new AINodeAnim(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AINodeAnim.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AINodeAnim.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AINodeAnim mallocStack() {
        return AINodeAnim.mallocStack(MemoryStack.stackGet());
    }

    public static AINodeAnim callocStack() {
        return AINodeAnim.callocStack(MemoryStack.stackGet());
    }

    public static AINodeAnim mallocStack(MemoryStack stack) {
        return AINodeAnim.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AINodeAnim callocStack(MemoryStack stack) {
        return AINodeAnim.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AINodeAnim.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AINodeAnim.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AINodeAnim.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AINodeAnim.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmNodeName(long struct) {
        return AIString.create(struct + (long)MNODENAME);
    }

    public static int nmNumPositionKeys(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMPOSITIONKEYS);
    }

    public static AIVectorKey.Buffer nmPositionKeys(long struct) {
        return AIVectorKey.create(MemoryUtil.memGetAddress(struct + (long)MPOSITIONKEYS), AINodeAnim.nmNumPositionKeys(struct));
    }

    public static int nmNumRotationKeys(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMROTATIONKEYS);
    }

    public static AIQuatKey.Buffer nmRotationKeys(long struct) {
        return AIQuatKey.create(MemoryUtil.memGetAddress(struct + (long)MROTATIONKEYS), AINodeAnim.nmNumRotationKeys(struct));
    }

    public static int nmNumScalingKeys(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMSCALINGKEYS);
    }

    public static AIVectorKey.Buffer nmScalingKeys(long struct) {
        return AIVectorKey.create(MemoryUtil.memGetAddress(struct + (long)MSCALINGKEYS), AINodeAnim.nmNumScalingKeys(struct));
    }

    public static int nmPreState(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MPRESTATE);
    }

    public static int nmPostState(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MPOSTSTATE);
    }

    public static void nmNodeName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNODENAME), (int)AIString.SIZEOF);
    }

    public static void nmNumPositionKeys(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMPOSITIONKEYS, value);
    }

    public static void nmPositionKeys(long struct, AIVectorKey.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MPOSITIONKEYS, AINodeAnim.addressSafe((Pointer)value));
        AINodeAnim.nmNumPositionKeys(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumRotationKeys(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMROTATIONKEYS, value);
    }

    public static void nmRotationKeys(long struct, AIQuatKey.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MROTATIONKEYS, AINodeAnim.addressSafe((Pointer)value));
        AINodeAnim.nmNumRotationKeys(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumScalingKeys(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMSCALINGKEYS, value);
    }

    public static void nmScalingKeys(long struct, AIVectorKey.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MSCALINGKEYS, AINodeAnim.addressSafe((Pointer)value));
        AINodeAnim.nmNumScalingKeys(struct, value == null ? 0 : value.remaining());
    }

    public static void nmPreState(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MPRESTATE, value);
    }

    public static void nmPostState(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MPOSTSTATE, value);
    }

    public static void validate(long struct) {
        if (AINodeAnim.nmNumPositionKeys(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MPOSITIONKEYS));
        }
        if (AINodeAnim.nmNumRotationKeys(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MROTATIONKEYS));
        }
        if (AINodeAnim.nmNumScalingKeys(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MSCALINGKEYS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AINodeAnim.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AINodeAnim.__struct(AINodeAnim.__member(AIString.SIZEOF, AIString.ALIGNOF), AINodeAnim.__member(4), AINodeAnim.__member(POINTER_SIZE), AINodeAnim.__member(4), AINodeAnim.__member(POINTER_SIZE), AINodeAnim.__member(4), AINodeAnim.__member(POINTER_SIZE), AINodeAnim.__member(4), AINodeAnim.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNODENAME = layout.offsetof(0);
        MNUMPOSITIONKEYS = layout.offsetof(1);
        MPOSITIONKEYS = layout.offsetof(2);
        MNUMROTATIONKEYS = layout.offsetof(3);
        MROTATIONKEYS = layout.offsetof(4);
        MNUMSCALINGKEYS = layout.offsetof(5);
        MSCALINGKEYS = layout.offsetof(6);
        MPRESTATE = layout.offsetof(7);
        MPOSTSTATE = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<AINodeAnim, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AINodeAnim newInstance(long address) {
            return new AINodeAnim(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public AIString mNodeName() {
            return AINodeAnim.nmNodeName(this.address());
        }

        public int mNumPositionKeys() {
            return AINodeAnim.nmNumPositionKeys(this.address());
        }

        public AIVectorKey.Buffer mPositionKeys() {
            return AINodeAnim.nmPositionKeys(this.address());
        }

        public int mNumRotationKeys() {
            return AINodeAnim.nmNumRotationKeys(this.address());
        }

        public AIQuatKey.Buffer mRotationKeys() {
            return AINodeAnim.nmRotationKeys(this.address());
        }

        public int mNumScalingKeys() {
            return AINodeAnim.nmNumScalingKeys(this.address());
        }

        public AIVectorKey.Buffer mScalingKeys() {
            return AINodeAnim.nmScalingKeys(this.address());
        }

        public int mPreState() {
            return AINodeAnim.nmPreState(this.address());
        }

        public int mPostState() {
            return AINodeAnim.nmPostState(this.address());
        }

        public Buffer mNodeName(AIString value) {
            AINodeAnim.nmNodeName(this.address(), value);
            return this;
        }

        public Buffer mPositionKeys(AIVectorKey.Buffer value) {
            AINodeAnim.nmPositionKeys(this.address(), value);
            return this;
        }

        public Buffer mRotationKeys(AIQuatKey.Buffer value) {
            AINodeAnim.nmRotationKeys(this.address(), value);
            return this;
        }

        public Buffer mScalingKeys(AIVectorKey.Buffer value) {
            AINodeAnim.nmScalingKeys(this.address(), value);
            return this;
        }

        public Buffer mPreState(int value) {
            AINodeAnim.nmPreState(this.address(), value);
            return this;
        }

        public Buffer mPostState(int value) {
            AINodeAnim.nmPostState(this.address(), value);
            return this;
        }
    }
}

