/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIMatrix4x4;
import org.lwjgl.assimp.AIMetaData;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AINode
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MTRANSFORMATION;
    public static final int MPARENT;
    public static final int MNUMCHILDREN;
    public static final int MCHILDREN;
    public static final int MNUMMESHES;
    public static final int MMESHES;
    public static final int MMETADATA;

    AINode(long address, ByteBuffer container) {
        super(address, container);
    }

    public AINode(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AINode.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public AIString mName() {
        return AINode.nmName(this.address());
    }

    public AIMatrix4x4 mTransformation() {
        return AINode.nmTransformation(this.address());
    }

    public AINode mParent() {
        return AINode.nmParent(this.address());
    }

    public int mNumChildren() {
        return AINode.nmNumChildren(this.address());
    }

    public PointerBuffer mChildren() {
        return AINode.nmChildren(this.address());
    }

    public int mNumMeshes() {
        return AINode.nmNumMeshes(this.address());
    }

    public IntBuffer mMeshes() {
        return AINode.nmMeshes(this.address());
    }

    public AIMetaData mMetadata() {
        return AINode.nmMetadata(this.address());
    }

    public AINode mName(AIString value) {
        AINode.nmName(this.address(), value);
        return this;
    }

    public AINode mTransformation(AIMatrix4x4 value) {
        AINode.nmTransformation(this.address(), value);
        return this;
    }

    public AINode mParent(AINode value) {
        AINode.nmParent(this.address(), value);
        return this;
    }

    public AINode mChildren(PointerBuffer value) {
        AINode.nmChildren(this.address(), value);
        return this;
    }

    public AINode mMeshes(IntBuffer value) {
        AINode.nmMeshes(this.address(), value);
        return this;
    }

    public AINode mMetadata(AIMetaData value) {
        AINode.nmMetadata(this.address(), value);
        return this;
    }

    public AINode set(AIString mName, AIMatrix4x4 mTransformation, AINode mParent, PointerBuffer mChildren, IntBuffer mMeshes, AIMetaData mMetadata) {
        this.mName(mName);
        this.mTransformation(mTransformation);
        this.mParent(mParent);
        this.mChildren(mChildren);
        this.mMeshes(mMeshes);
        this.mMetadata(mMetadata);
        return this;
    }

    public AINode set(AINode src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AINode malloc() {
        return AINode.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AINode calloc() {
        return AINode.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AINode create() {
        return new AINode(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AINode create(long address) {
        return address == 0L ? null : new AINode(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AINode.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AINode.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AINode mallocStack() {
        return AINode.mallocStack(MemoryStack.stackGet());
    }

    public static AINode callocStack() {
        return AINode.callocStack(MemoryStack.stackGet());
    }

    public static AINode mallocStack(MemoryStack stack) {
        return AINode.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AINode callocStack(MemoryStack stack) {
        return AINode.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AINode.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AINode.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AINode.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AINode.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static AIMatrix4x4 nmTransformation(long struct) {
        return AIMatrix4x4.create(struct + (long)MTRANSFORMATION);
    }

    public static AINode nmParent(long struct) {
        return AINode.create(MemoryUtil.memGetAddress(struct + (long)MPARENT));
    }

    public static int nmNumChildren(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMCHILDREN);
    }

    public static PointerBuffer nmChildren(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MCHILDREN), AINode.nmNumChildren(struct));
    }

    public static int nmNumMeshes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMMESHES);
    }

    public static IntBuffer nmMeshes(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)MMESHES), AINode.nmNumMeshes(struct));
    }

    public static AIMetaData nmMetadata(long struct) {
        return AIMetaData.create(MemoryUtil.memGetAddress(struct + (long)MMETADATA));
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNAME), (int)AIString.SIZEOF);
    }

    public static void nmTransformation(long struct, AIMatrix4x4 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MTRANSFORMATION), (int)AIMatrix4x4.SIZEOF);
    }

    public static void nmParent(long struct, AINode value) {
        MemoryUtil.memPutAddress(struct + (long)MPARENT, AINode.addressSafe((Pointer)value));
    }

    public static void nmNumChildren(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMCHILDREN, value);
    }

    public static void nmChildren(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MCHILDREN, MemoryUtil.memAddressSafe(value));
        AINode.nmNumChildren(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumMeshes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMMESHES, value);
    }

    public static void nmMeshes(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MMESHES, MemoryUtil.memAddressSafe(value));
        AINode.nmNumMeshes(struct, value == null ? 0 : value.remaining());
    }

    public static void nmMetadata(long struct, AIMetaData value) {
        MemoryUtil.memPutAddress(struct + (long)MMETADATA, AINode.addressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        long mMetadata;
        if (AINode.nmNumChildren(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MCHILDREN));
        }
        if (AINode.nmNumMeshes(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MMESHES));
        }
        if ((mMetadata = MemoryUtil.memGetAddress(struct + (long)MMETADATA)) != 0L) {
            AIMetaData.validate(mMetadata);
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AINode.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AINode.__struct(AINode.__member(AIString.SIZEOF, AIString.ALIGNOF), AINode.__member(AIMatrix4x4.SIZEOF, AIMatrix4x4.ALIGNOF), AINode.__member(POINTER_SIZE), AINode.__member(4), AINode.__member(POINTER_SIZE), AINode.__member(4), AINode.__member(POINTER_SIZE), AINode.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MTRANSFORMATION = layout.offsetof(1);
        MPARENT = layout.offsetof(2);
        MNUMCHILDREN = layout.offsetof(3);
        MCHILDREN = layout.offsetof(4);
        MNUMMESHES = layout.offsetof(5);
        MMESHES = layout.offsetof(6);
        MMETADATA = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<AINode, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AINode newInstance(long address) {
            return new AINode(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public AIString mName() {
            return AINode.nmName(this.address());
        }

        public AIMatrix4x4 mTransformation() {
            return AINode.nmTransformation(this.address());
        }

        public AINode mParent() {
            return AINode.nmParent(this.address());
        }

        public int mNumChildren() {
            return AINode.nmNumChildren(this.address());
        }

        public PointerBuffer mChildren() {
            return AINode.nmChildren(this.address());
        }

        public int mNumMeshes() {
            return AINode.nmNumMeshes(this.address());
        }

        public IntBuffer mMeshes() {
            return AINode.nmMeshes(this.address());
        }

        public AIMetaData mMetadata() {
            return AINode.nmMetadata(this.address());
        }

        public Buffer mName(AIString value) {
            AINode.nmName(this.address(), value);
            return this;
        }

        public Buffer mTransformation(AIMatrix4x4 value) {
            AINode.nmTransformation(this.address(), value);
            return this;
        }

        public Buffer mParent(AINode value) {
            AINode.nmParent(this.address(), value);
            return this;
        }

        public Buffer mChildren(PointerBuffer value) {
            AINode.nmChildren(this.address(), value);
            return this;
        }

        public Buffer mMeshes(IntBuffer value) {
            AINode.nmMeshes(this.address(), value);
            return this;
        }

        public Buffer mMetadata(AIMetaData value) {
            AINode.nmMetadata(this.address(), value);
            return this;
        }
    }
}

