/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIMeshKey
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTIME;
    public static final int MVALUE;

    AIMeshKey(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIMeshKey(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIMeshKey.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double mTime() {
        return AIMeshKey.nmTime(this.address());
    }

    public int mValue() {
        return AIMeshKey.nmValue(this.address());
    }

    public AIMeshKey mTime(double value) {
        AIMeshKey.nmTime(this.address(), value);
        return this;
    }

    public AIMeshKey mValue(int value) {
        AIMeshKey.nmValue(this.address(), value);
        return this;
    }

    public AIMeshKey set(double mTime, int mValue) {
        this.mTime(mTime);
        this.mValue(mValue);
        return this;
    }

    public AIMeshKey set(AIMeshKey src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AIMeshKey malloc() {
        return AIMeshKey.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIMeshKey calloc() {
        return AIMeshKey.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIMeshKey create() {
        return new AIMeshKey(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIMeshKey create(long address) {
        return address == 0L ? null : new AIMeshKey(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIMeshKey.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIMeshKey.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIMeshKey mallocStack() {
        return AIMeshKey.mallocStack(MemoryStack.stackGet());
    }

    public static AIMeshKey callocStack() {
        return AIMeshKey.callocStack(MemoryStack.stackGet());
    }

    public static AIMeshKey mallocStack(MemoryStack stack) {
        return AIMeshKey.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMeshKey callocStack(MemoryStack stack) {
        return AIMeshKey.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMeshKey.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMeshKey.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMeshKey.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMeshKey.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nmTime(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)MTIME);
    }

    public static int nmValue(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MVALUE);
    }

    public static void nmTime(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)MTIME, value);
    }

    public static void nmValue(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MVALUE, value);
    }

    static {
        Struct.Layout layout = AIMeshKey.__struct(AIMeshKey.__member(8), AIMeshKey.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTIME = layout.offsetof(0);
        MVALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIMeshKey, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIMeshKey newInstance(long address) {
            return new AIMeshKey(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public double mTime() {
            return AIMeshKey.nmTime(this.address());
        }

        public int mValue() {
            return AIMeshKey.nmValue(this.address());
        }

        public Buffer mTime(double value) {
            AIMeshKey.nmTime(this.address(), value);
            return this;
        }

        public Buffer mValue(int value) {
            AIMeshKey.nmValue(this.address(), value);
            return this;
        }
    }
}

