/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIColor4D;
import org.lwjgl.assimp.AIFace;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIMesh
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MPRIMITIVETYPES;
    public static final int MNUMVERTICES;
    public static final int MNUMFACES;
    public static final int MVERTICES;
    public static final int MNORMALS;
    public static final int MTANGENTS;
    public static final int MBITANGENTS;
    public static final int MCOLORS;
    public static final int MTEXTURECOORDS;
    public static final int MNUMUVCOMPONENTS;
    public static final int MFACES;
    public static final int MNUMBONES;
    public static final int MBONES;
    public static final int MMATERIALINDEX;
    public static final int MNAME;
    public static final int MNUMANIMMESHES;
    public static final int MANIMMESHES;

    AIMesh(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIMesh(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIMesh.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int mPrimitiveTypes() {
        return AIMesh.nmPrimitiveTypes(this.address());
    }

    public int mNumVertices() {
        return AIMesh.nmNumVertices(this.address());
    }

    public int mNumFaces() {
        return AIMesh.nmNumFaces(this.address());
    }

    public AIVector3D.Buffer mVertices() {
        return AIMesh.nmVertices(this.address());
    }

    public AIVector3D.Buffer mNormals() {
        return AIMesh.nmNormals(this.address());
    }

    public AIVector3D.Buffer mTangents() {
        return AIMesh.nmTangents(this.address());
    }

    public AIVector3D.Buffer mBitangents() {
        return AIMesh.nmBitangents(this.address());
    }

    public PointerBuffer mColors() {
        return AIMesh.nmColors(this.address());
    }

    public AIColor4D.Buffer mColors(int index) {
        return AIMesh.nmColors(this.address(), index);
    }

    public PointerBuffer mTextureCoords() {
        return AIMesh.nmTextureCoords(this.address());
    }

    public AIVector3D.Buffer mTextureCoords(int index) {
        return AIMesh.nmTextureCoords(this.address(), index);
    }

    public IntBuffer mNumUVComponents() {
        return AIMesh.nmNumUVComponents(this.address());
    }

    public int mNumUVComponents(int index) {
        return AIMesh.nmNumUVComponents(this.address(), index);
    }

    public AIFace.Buffer mFaces() {
        return AIMesh.nmFaces(this.address());
    }

    public int mNumBones() {
        return AIMesh.nmNumBones(this.address());
    }

    public PointerBuffer mBones() {
        return AIMesh.nmBones(this.address());
    }

    public int mMaterialIndex() {
        return AIMesh.nmMaterialIndex(this.address());
    }

    public AIString mName() {
        return AIMesh.nmName(this.address());
    }

    public int mNumAnimMeshes() {
        return AIMesh.nmNumAnimMeshes(this.address());
    }

    public PointerBuffer mAnimMeshes() {
        return AIMesh.nmAnimMeshes(this.address());
    }

    public AIMesh mPrimitiveTypes(int value) {
        AIMesh.nmPrimitiveTypes(this.address(), value);
        return this;
    }

    public AIMesh mNumVertices(int value) {
        AIMesh.nmNumVertices(this.address(), value);
        return this;
    }

    public AIMesh mVertices(AIVector3D.Buffer value) {
        AIMesh.nmVertices(this.address(), value);
        return this;
    }

    public AIMesh mNormals(AIVector3D.Buffer value) {
        AIMesh.nmNormals(this.address(), value);
        return this;
    }

    public AIMesh mTangents(AIVector3D.Buffer value) {
        AIMesh.nmTangents(this.address(), value);
        return this;
    }

    public AIMesh mBitangents(AIVector3D.Buffer value) {
        AIMesh.nmBitangents(this.address(), value);
        return this;
    }

    public AIMesh mColors(PointerBuffer value) {
        AIMesh.nmColors(this.address(), value);
        return this;
    }

    public AIMesh mColors(int index, AIColor4D.Buffer value) {
        AIMesh.nmColors(this.address(), index, value);
        return this;
    }

    public AIMesh mTextureCoords(PointerBuffer value) {
        AIMesh.nmTextureCoords(this.address(), value);
        return this;
    }

    public AIMesh mTextureCoords(int index, AIVector3D.Buffer value) {
        AIMesh.nmTextureCoords(this.address(), index, value);
        return this;
    }

    public AIMesh mNumUVComponents(IntBuffer value) {
        AIMesh.nmNumUVComponents(this.address(), value);
        return this;
    }

    public AIMesh mNumUVComponents(int index, int value) {
        AIMesh.nmNumUVComponents(this.address(), index, value);
        return this;
    }

    public AIMesh mFaces(AIFace.Buffer value) {
        AIMesh.nmFaces(this.address(), value);
        return this;
    }

    public AIMesh mBones(PointerBuffer value) {
        AIMesh.nmBones(this.address(), value);
        return this;
    }

    public AIMesh mMaterialIndex(int value) {
        AIMesh.nmMaterialIndex(this.address(), value);
        return this;
    }

    public AIMesh mName(AIString value) {
        AIMesh.nmName(this.address(), value);
        return this;
    }

    public AIMesh mAnimMeshes(PointerBuffer value) {
        AIMesh.nmAnimMeshes(this.address(), value);
        return this;
    }

    public AIMesh set(int mPrimitiveTypes, int mNumVertices, AIVector3D.Buffer mVertices, AIVector3D.Buffer mNormals, AIVector3D.Buffer mTangents, AIVector3D.Buffer mBitangents, PointerBuffer mColors, PointerBuffer mTextureCoords, IntBuffer mNumUVComponents, AIFace.Buffer mFaces, PointerBuffer mBones, int mMaterialIndex, AIString mName, PointerBuffer mAnimMeshes) {
        this.mPrimitiveTypes(mPrimitiveTypes);
        this.mNumVertices(mNumVertices);
        this.mVertices(mVertices);
        this.mNormals(mNormals);
        this.mTangents(mTangents);
        this.mBitangents(mBitangents);
        this.mColors(mColors);
        this.mTextureCoords(mTextureCoords);
        this.mNumUVComponents(mNumUVComponents);
        this.mFaces(mFaces);
        this.mBones(mBones);
        this.mMaterialIndex(mMaterialIndex);
        this.mName(mName);
        this.mAnimMeshes(mAnimMeshes);
        return this;
    }

    public AIMesh set(AIMesh src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AIMesh malloc() {
        return AIMesh.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIMesh calloc() {
        return AIMesh.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIMesh create() {
        return new AIMesh(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIMesh create(long address) {
        return address == 0L ? null : new AIMesh(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIMesh.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIMesh.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIMesh mallocStack() {
        return AIMesh.mallocStack(MemoryStack.stackGet());
    }

    public static AIMesh callocStack() {
        return AIMesh.callocStack(MemoryStack.stackGet());
    }

    public static AIMesh mallocStack(MemoryStack stack) {
        return AIMesh.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMesh callocStack(MemoryStack stack) {
        return AIMesh.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMesh.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMesh.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMesh.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMesh.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmPrimitiveTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MPRIMITIVETYPES);
    }

    public static int nmNumVertices(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMVERTICES);
    }

    public static int nmNumFaces(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMFACES);
    }

    public static AIVector3D.Buffer nmVertices(long struct) {
        return AIVector3D.create(MemoryUtil.memGetAddress(struct + (long)MVERTICES), AIMesh.nmNumVertices(struct));
    }

    public static AIVector3D.Buffer nmNormals(long struct) {
        return AIVector3D.create(MemoryUtil.memGetAddress(struct + (long)MNORMALS), AIMesh.nmNumVertices(struct));
    }

    public static AIVector3D.Buffer nmTangents(long struct) {
        return AIVector3D.create(MemoryUtil.memGetAddress(struct + (long)MTANGENTS), AIMesh.nmNumVertices(struct));
    }

    public static AIVector3D.Buffer nmBitangents(long struct) {
        return AIVector3D.create(MemoryUtil.memGetAddress(struct + (long)MBITANGENTS), AIMesh.nmNumVertices(struct));
    }

    public static PointerBuffer nmColors(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)MCOLORS, 8);
    }

    public static AIColor4D.Buffer nmColors(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        return AIColor4D.create(MemoryUtil.memGetAddress(struct + (long)MCOLORS + (long)(index * POINTER_SIZE)), AIMesh.nmNumVertices(struct));
    }

    public static PointerBuffer nmTextureCoords(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)MTEXTURECOORDS, 8);
    }

    public static AIVector3D.Buffer nmTextureCoords(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        return AIVector3D.create(MemoryUtil.memGetAddress(struct + (long)MTEXTURECOORDS + (long)(index * POINTER_SIZE)), AIMesh.nmNumVertices(struct));
    }

    public static IntBuffer nmNumUVComponents(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)MNUMUVCOMPONENTS, 8);
    }

    public static int nmNumUVComponents(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        return MemoryUtil.memGetInt(struct + (long)MNUMUVCOMPONENTS + (long)(index * 4));
    }

    public static AIFace.Buffer nmFaces(long struct) {
        return AIFace.create(MemoryUtil.memGetAddress(struct + (long)MFACES), AIMesh.nmNumFaces(struct));
    }

    public static int nmNumBones(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMBONES);
    }

    public static PointerBuffer nmBones(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MBONES), AIMesh.nmNumBones(struct));
    }

    public static int nmMaterialIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MMATERIALINDEX);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static int nmNumAnimMeshes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMANIMMESHES);
    }

    public static PointerBuffer nmAnimMeshes(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MANIMMESHES), AIMesh.nmNumAnimMeshes(struct));
    }

    public static void nmPrimitiveTypes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MPRIMITIVETYPES, value);
    }

    public static void nmNumVertices(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMVERTICES, value);
    }

    public static void nmNumFaces(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMFACES, value);
    }

    public static void nmVertices(long struct, AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MVERTICES, value.address());
    }

    public static void nmNormals(long struct, AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MNORMALS, AIMesh.addressSafe((Pointer)value));
    }

    public static void nmTangents(long struct, AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MTANGENTS, AIMesh.addressSafe((Pointer)value));
    }

    public static void nmBitangents(long struct, AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MBITANGENTS, AIMesh.addressSafe((Pointer)value));
    }

    public static void nmColors(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress(value), (long)(struct + (long)MCOLORS), (int)(value.remaining() * POINTER_SIZE));
    }

    public static void nmColors(long struct, int index, AIColor4D.Buffer value) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        MemoryUtil.memPutAddress(struct + (long)MCOLORS + (long)(index * POINTER_SIZE), AIMesh.addressSafe((Pointer)value));
    }

    public static void nmTextureCoords(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress(value), (long)(struct + (long)MTEXTURECOORDS), (int)(value.remaining() * POINTER_SIZE));
    }

    public static void nmTextureCoords(long struct, int index, AIVector3D.Buffer value) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        MemoryUtil.memPutAddress(struct + (long)MTEXTURECOORDS + (long)(index * POINTER_SIZE), AIMesh.addressSafe((Pointer)value));
    }

    public static void nmNumUVComponents(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress(value), (long)(struct + (long)MNUMUVCOMPONENTS), (int)(value.remaining() * 4));
    }

    public static void nmNumUVComponents(long struct, int index, int value) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        MemoryUtil.memPutInt(struct + (long)MNUMUVCOMPONENTS + (long)(index * 4), value);
    }

    public static void nmFaces(long struct, AIFace.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MFACES, value.address());
        AIMesh.nmNumFaces(struct, value.remaining());
    }

    public static void nmNumBones(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMBONES, value);
    }

    public static void nmBones(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MBONES, MemoryUtil.memAddressSafe(value));
        AIMesh.nmNumBones(struct, value == null ? 0 : value.remaining());
    }

    public static void nmMaterialIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MMATERIALINDEX, value);
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNAME), (int)AIString.SIZEOF);
    }

    public static void nmNumAnimMeshes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMANIMMESHES, value);
    }

    public static void nmAnimMeshes(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MANIMMESHES, MemoryUtil.memAddressSafe(value));
        AIMesh.nmNumAnimMeshes(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int mNumFaces = AIMesh.nmNumFaces(struct);
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MVERTICES));
        long mFaces = MemoryUtil.memGetAddress(struct + (long)MFACES);
        Checks.check(mFaces);
        AIFace.validate(mFaces, mNumFaces);
        if (AIMesh.nmNumBones(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MBONES));
        }
        if (AIMesh.nmNumAnimMeshes(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MANIMMESHES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIMesh.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIMesh.__struct(AIMesh.__member(4), AIMesh.__member(4), AIMesh.__member(4), AIMesh.__member(POINTER_SIZE), AIMesh.__member(POINTER_SIZE), AIMesh.__member(POINTER_SIZE), AIMesh.__member(POINTER_SIZE), AIMesh.__array(POINTER_SIZE, 8), AIMesh.__array(POINTER_SIZE, 8), AIMesh.__array(4, 8), AIMesh.__member(POINTER_SIZE), AIMesh.__member(4), AIMesh.__member(POINTER_SIZE), AIMesh.__member(4), AIMesh.__member(AIString.SIZEOF, AIString.ALIGNOF), AIMesh.__member(4), AIMesh.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MPRIMITIVETYPES = layout.offsetof(0);
        MNUMVERTICES = layout.offsetof(1);
        MNUMFACES = layout.offsetof(2);
        MVERTICES = layout.offsetof(3);
        MNORMALS = layout.offsetof(4);
        MTANGENTS = layout.offsetof(5);
        MBITANGENTS = layout.offsetof(6);
        MCOLORS = layout.offsetof(7);
        MTEXTURECOORDS = layout.offsetof(8);
        MNUMUVCOMPONENTS = layout.offsetof(9);
        MFACES = layout.offsetof(10);
        MNUMBONES = layout.offsetof(11);
        MBONES = layout.offsetof(12);
        MMATERIALINDEX = layout.offsetof(13);
        MNAME = layout.offsetof(14);
        MNUMANIMMESHES = layout.offsetof(15);
        MANIMMESHES = layout.offsetof(16);
    }

    public static class Buffer
    extends StructBuffer<AIMesh, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIMesh newInstance(long address) {
            return new AIMesh(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int mPrimitiveTypes() {
            return AIMesh.nmPrimitiveTypes(this.address());
        }

        public int mNumVertices() {
            return AIMesh.nmNumVertices(this.address());
        }

        public int mNumFaces() {
            return AIMesh.nmNumFaces(this.address());
        }

        public AIVector3D.Buffer mVertices() {
            return AIMesh.nmVertices(this.address());
        }

        public AIVector3D.Buffer mNormals() {
            return AIMesh.nmNormals(this.address());
        }

        public AIVector3D.Buffer mTangents() {
            return AIMesh.nmTangents(this.address());
        }

        public AIVector3D.Buffer mBitangents() {
            return AIMesh.nmBitangents(this.address());
        }

        public PointerBuffer mColors() {
            return AIMesh.nmColors(this.address());
        }

        public AIColor4D.Buffer mColors(int index) {
            return AIMesh.nmColors(this.address(), index);
        }

        public PointerBuffer mTextureCoords() {
            return AIMesh.nmTextureCoords(this.address());
        }

        public AIVector3D.Buffer mTextureCoords(int index) {
            return AIMesh.nmTextureCoords(this.address(), index);
        }

        public IntBuffer mNumUVComponents() {
            return AIMesh.nmNumUVComponents(this.address());
        }

        public int mNumUVComponents(int index) {
            return AIMesh.nmNumUVComponents(this.address(), index);
        }

        public AIFace.Buffer mFaces() {
            return AIMesh.nmFaces(this.address());
        }

        public int mNumBones() {
            return AIMesh.nmNumBones(this.address());
        }

        public PointerBuffer mBones() {
            return AIMesh.nmBones(this.address());
        }

        public int mMaterialIndex() {
            return AIMesh.nmMaterialIndex(this.address());
        }

        public AIString mName() {
            return AIMesh.nmName(this.address());
        }

        public int mNumAnimMeshes() {
            return AIMesh.nmNumAnimMeshes(this.address());
        }

        public PointerBuffer mAnimMeshes() {
            return AIMesh.nmAnimMeshes(this.address());
        }

        public Buffer mPrimitiveTypes(int value) {
            AIMesh.nmPrimitiveTypes(this.address(), value);
            return this;
        }

        public Buffer mNumVertices(int value) {
            AIMesh.nmNumVertices(this.address(), value);
            return this;
        }

        public Buffer mVertices(AIVector3D.Buffer value) {
            AIMesh.nmVertices(this.address(), value);
            return this;
        }

        public Buffer mNormals(AIVector3D.Buffer value) {
            AIMesh.nmNormals(this.address(), value);
            return this;
        }

        public Buffer mTangents(AIVector3D.Buffer value) {
            AIMesh.nmTangents(this.address(), value);
            return this;
        }

        public Buffer mBitangents(AIVector3D.Buffer value) {
            AIMesh.nmBitangents(this.address(), value);
            return this;
        }

        public Buffer mColors(PointerBuffer value) {
            AIMesh.nmColors(this.address(), value);
            return this;
        }

        public Buffer mColors(int index, AIColor4D.Buffer value) {
            AIMesh.nmColors(this.address(), index, value);
            return this;
        }

        public Buffer mTextureCoords(PointerBuffer value) {
            AIMesh.nmTextureCoords(this.address(), value);
            return this;
        }

        public Buffer mTextureCoords(int index, AIVector3D.Buffer value) {
            AIMesh.nmTextureCoords(this.address(), index, value);
            return this;
        }

        public Buffer mNumUVComponents(IntBuffer value) {
            AIMesh.nmNumUVComponents(this.address(), value);
            return this;
        }

        public Buffer mNumUVComponents(int index, int value) {
            AIMesh.nmNumUVComponents(this.address(), index, value);
            return this;
        }

        public Buffer mFaces(AIFace.Buffer value) {
            AIMesh.nmFaces(this.address(), value);
            return this;
        }

        public Buffer mBones(PointerBuffer value) {
            AIMesh.nmBones(this.address(), value);
            return this;
        }

        public Buffer mMaterialIndex(int value) {
            AIMesh.nmMaterialIndex(this.address(), value);
            return this;
        }

        public Buffer mName(AIString value) {
            AIMesh.nmName(this.address(), value);
            return this;
        }

        public Buffer mAnimMeshes(PointerBuffer value) {
            AIMesh.nmAnimMeshes(this.address(), value);
            return this;
        }
    }
}

