/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIMatrix4x4;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVertexWeight;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIBone
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MNUMWEIGHTS;
    public static final int MWEIGHTS;
    public static final int MOFFSETMATRIX;

    AIBone(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIBone(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIBone.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public AIString mName() {
        return AIBone.nmName(this.address());
    }

    public int mNumWeights() {
        return AIBone.nmNumWeights(this.address());
    }

    public AIVertexWeight.Buffer mWeights() {
        return AIBone.nmWeights(this.address());
    }

    public AIMatrix4x4 mOffsetMatrix() {
        return AIBone.nmOffsetMatrix(this.address());
    }

    public AIBone mName(AIString value) {
        AIBone.nmName(this.address(), value);
        return this;
    }

    public AIBone mWeights(AIVertexWeight.Buffer value) {
        AIBone.nmWeights(this.address(), value);
        return this;
    }

    public AIBone mOffsetMatrix(AIMatrix4x4 value) {
        AIBone.nmOffsetMatrix(this.address(), value);
        return this;
    }

    public AIBone set(AIString mName, AIVertexWeight.Buffer mWeights, AIMatrix4x4 mOffsetMatrix) {
        this.mName(mName);
        this.mWeights(mWeights);
        this.mOffsetMatrix(mOffsetMatrix);
        return this;
    }

    public AIBone set(AIBone src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AIBone malloc() {
        return AIBone.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIBone calloc() {
        return AIBone.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIBone create() {
        return new AIBone(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIBone create(long address) {
        return address == 0L ? null : new AIBone(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIBone.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIBone.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIBone mallocStack() {
        return AIBone.mallocStack(MemoryStack.stackGet());
    }

    public static AIBone callocStack() {
        return AIBone.callocStack(MemoryStack.stackGet());
    }

    public static AIBone mallocStack(MemoryStack stack) {
        return AIBone.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIBone callocStack(MemoryStack stack) {
        return AIBone.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIBone.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIBone.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIBone.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIBone.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static int nmNumWeights(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMWEIGHTS);
    }

    public static AIVertexWeight.Buffer nmWeights(long struct) {
        return AIVertexWeight.create(MemoryUtil.memGetAddress(struct + (long)MWEIGHTS), AIBone.nmNumWeights(struct));
    }

    public static AIMatrix4x4 nmOffsetMatrix(long struct) {
        return AIMatrix4x4.create(struct + (long)MOFFSETMATRIX);
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNAME), (int)AIString.SIZEOF);
    }

    public static void nmNumWeights(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMWEIGHTS, value);
    }

    public static void nmWeights(long struct, AIVertexWeight.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MWEIGHTS, value.address());
        AIBone.nmNumWeights(struct, value.remaining());
    }

    public static void nmOffsetMatrix(long struct, AIMatrix4x4 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MOFFSETMATRIX), (int)AIMatrix4x4.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MWEIGHTS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIBone.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIBone.__struct(AIBone.__member(AIString.SIZEOF, AIString.ALIGNOF), AIBone.__member(4), AIBone.__member(POINTER_SIZE), AIBone.__member(AIMatrix4x4.SIZEOF, AIMatrix4x4.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MNUMWEIGHTS = layout.offsetof(1);
        MWEIGHTS = layout.offsetof(2);
        MOFFSETMATRIX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIBone, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIBone newInstance(long address) {
            return new AIBone(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public AIString mName() {
            return AIBone.nmName(this.address());
        }

        public int mNumWeights() {
            return AIBone.nmNumWeights(this.address());
        }

        public AIVertexWeight.Buffer mWeights() {
            return AIBone.nmWeights(this.address());
        }

        public AIMatrix4x4 mOffsetMatrix() {
            return AIBone.nmOffsetMatrix(this.address());
        }

        public Buffer mName(AIString value) {
            AIBone.nmName(this.address(), value);
            return this;
        }

        public Buffer mWeights(AIVertexWeight.Buffer value) {
            AIBone.nmWeights(this.address(), value);
            return this;
        }

        public Buffer mOffsetMatrix(AIMatrix4x4 value) {
            AIBone.nmOffsetMatrix(this.address(), value);
            return this;
        }
    }
}

