/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIColor4D;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIAnimMesh
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MVERTICES;
    public static final int MNORMALS;
    public static final int MTANGENTS;
    public static final int MBITANGENTS;
    public static final int MCOLORS;
    public static final int MTEXTURECOORDS;
    public static final int MNUMVERTICES;

    AIAnimMesh(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIAnimMesh(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIAnimMesh.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public AIVector3D.Buffer mVertices() {
        return AIAnimMesh.nmVertices(this.address());
    }

    public AIVector3D.Buffer mNormals() {
        return AIAnimMesh.nmNormals(this.address());
    }

    public AIVector3D.Buffer mTangents() {
        return AIAnimMesh.nmTangents(this.address());
    }

    public AIVector3D.Buffer mBitangents() {
        return AIAnimMesh.nmBitangents(this.address());
    }

    public PointerBuffer mColors() {
        return AIAnimMesh.nmColors(this.address());
    }

    public AIColor4D.Buffer mColors(int index) {
        return AIAnimMesh.nmColors(this.address(), index);
    }

    public PointerBuffer mTextureCoords() {
        return AIAnimMesh.nmTextureCoords(this.address());
    }

    public AIVector3D.Buffer mTextureCoords(int index) {
        return AIAnimMesh.nmTextureCoords(this.address(), index);
    }

    public int mNumVertices() {
        return AIAnimMesh.nmNumVertices(this.address());
    }

    public AIAnimMesh mVertices(AIVector3D.Buffer value) {
        AIAnimMesh.nmVertices(this.address(), value);
        return this;
    }

    public AIAnimMesh mNormals(AIVector3D.Buffer value) {
        AIAnimMesh.nmNormals(this.address(), value);
        return this;
    }

    public AIAnimMesh mTangents(AIVector3D.Buffer value) {
        AIAnimMesh.nmTangents(this.address(), value);
        return this;
    }

    public AIAnimMesh mBitangents(AIVector3D.Buffer value) {
        AIAnimMesh.nmBitangents(this.address(), value);
        return this;
    }

    public AIAnimMesh mColors(PointerBuffer value) {
        AIAnimMesh.nmColors(this.address(), value);
        return this;
    }

    public AIAnimMesh mColors(int index, AIColor4D.Buffer value) {
        AIAnimMesh.nmColors(this.address(), index, value);
        return this;
    }

    public AIAnimMesh mTextureCoords(PointerBuffer value) {
        AIAnimMesh.nmTextureCoords(this.address(), value);
        return this;
    }

    public AIAnimMesh mTextureCoords(int index, AIVector3D.Buffer value) {
        AIAnimMesh.nmTextureCoords(this.address(), index, value);
        return this;
    }

    public AIAnimMesh mNumVertices(int value) {
        AIAnimMesh.nmNumVertices(this.address(), value);
        return this;
    }

    public AIAnimMesh set(AIVector3D.Buffer mVertices, AIVector3D.Buffer mNormals, AIVector3D.Buffer mTangents, AIVector3D.Buffer mBitangents, PointerBuffer mColors, PointerBuffer mTextureCoords, int mNumVertices) {
        this.mVertices(mVertices);
        this.mNormals(mNormals);
        this.mTangents(mTangents);
        this.mBitangents(mBitangents);
        this.mColors(mColors);
        this.mTextureCoords(mTextureCoords);
        this.mNumVertices(mNumVertices);
        return this;
    }

    public AIAnimMesh set(AIAnimMesh src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static AIAnimMesh malloc() {
        return AIAnimMesh.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIAnimMesh calloc() {
        return AIAnimMesh.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIAnimMesh create() {
        return new AIAnimMesh(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIAnimMesh create(long address) {
        return address == 0L ? null : new AIAnimMesh(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIAnimMesh.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIAnimMesh.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIAnimMesh mallocStack() {
        return AIAnimMesh.mallocStack(MemoryStack.stackGet());
    }

    public static AIAnimMesh callocStack() {
        return AIAnimMesh.callocStack(MemoryStack.stackGet());
    }

    public static AIAnimMesh mallocStack(MemoryStack stack) {
        return AIAnimMesh.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIAnimMesh callocStack(MemoryStack stack) {
        return AIAnimMesh.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIAnimMesh.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIAnimMesh.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIAnimMesh.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIAnimMesh.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIVector3D.Buffer nmVertices(long struct) {
        return AIVector3D.create(MemoryUtil.memGetAddress(struct + (long)MVERTICES), AIAnimMesh.nmNumVertices(struct));
    }

    public static AIVector3D.Buffer nmNormals(long struct) {
        return AIVector3D.create(MemoryUtil.memGetAddress(struct + (long)MNORMALS), AIAnimMesh.nmNumVertices(struct));
    }

    public static AIVector3D.Buffer nmTangents(long struct) {
        return AIVector3D.create(MemoryUtil.memGetAddress(struct + (long)MTANGENTS), AIAnimMesh.nmNumVertices(struct));
    }

    public static AIVector3D.Buffer nmBitangents(long struct) {
        return AIVector3D.create(MemoryUtil.memGetAddress(struct + (long)MBITANGENTS), AIAnimMesh.nmNumVertices(struct));
    }

    public static PointerBuffer nmColors(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)MCOLORS, 8);
    }

    public static AIColor4D.Buffer nmColors(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        return AIColor4D.create(MemoryUtil.memGetAddress(struct + (long)MCOLORS + (long)(index * POINTER_SIZE)), AIAnimMesh.nmNumVertices(struct));
    }

    public static PointerBuffer nmTextureCoords(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)MTEXTURECOORDS, 8);
    }

    public static AIVector3D.Buffer nmTextureCoords(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        return AIVector3D.create(MemoryUtil.memGetAddress(struct + (long)MTEXTURECOORDS + (long)(index * POINTER_SIZE)), AIAnimMesh.nmNumVertices(struct));
    }

    public static int nmNumVertices(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMVERTICES);
    }

    public static void nmVertices(long struct, AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MVERTICES, AIAnimMesh.addressSafe((Pointer)value));
    }

    public static void nmNormals(long struct, AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MNORMALS, AIAnimMesh.addressSafe((Pointer)value));
    }

    public static void nmTangents(long struct, AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MTANGENTS, AIAnimMesh.addressSafe((Pointer)value));
    }

    public static void nmBitangents(long struct, AIVector3D.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MBITANGENTS, AIAnimMesh.addressSafe((Pointer)value));
    }

    public static void nmColors(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress(value), (long)(struct + (long)MCOLORS), (int)(value.remaining() * POINTER_SIZE));
    }

    public static void nmColors(long struct, int index, AIColor4D.Buffer value) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        MemoryUtil.memPutAddress(struct + (long)MCOLORS + (long)(index * POINTER_SIZE), AIAnimMesh.addressSafe((Pointer)value));
    }

    public static void nmTextureCoords(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress(value), (long)(struct + (long)MTEXTURECOORDS), (int)(value.remaining() * POINTER_SIZE));
    }

    public static void nmTextureCoords(long struct, int index, AIVector3D.Buffer value) {
        if (Checks.CHECKS) {
            Checks.check(index, 8);
        }
        MemoryUtil.memPutAddress(struct + (long)MTEXTURECOORDS + (long)(index * POINTER_SIZE), AIAnimMesh.addressSafe((Pointer)value));
    }

    public static void nmNumVertices(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMVERTICES, value);
    }

    static {
        Struct.Layout layout = AIAnimMesh.__struct(AIAnimMesh.__member(POINTER_SIZE), AIAnimMesh.__member(POINTER_SIZE), AIAnimMesh.__member(POINTER_SIZE), AIAnimMesh.__member(POINTER_SIZE), AIAnimMesh.__array(POINTER_SIZE, 8), AIAnimMesh.__array(POINTER_SIZE, 8), AIAnimMesh.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MVERTICES = layout.offsetof(0);
        MNORMALS = layout.offsetof(1);
        MTANGENTS = layout.offsetof(2);
        MBITANGENTS = layout.offsetof(3);
        MCOLORS = layout.offsetof(4);
        MTEXTURECOORDS = layout.offsetof(5);
        MNUMVERTICES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<AIAnimMesh, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIAnimMesh newInstance(long address) {
            return new AIAnimMesh(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public AIVector3D.Buffer mVertices() {
            return AIAnimMesh.nmVertices(this.address());
        }

        public AIVector3D.Buffer mNormals() {
            return AIAnimMesh.nmNormals(this.address());
        }

        public AIVector3D.Buffer mTangents() {
            return AIAnimMesh.nmTangents(this.address());
        }

        public AIVector3D.Buffer mBitangents() {
            return AIAnimMesh.nmBitangents(this.address());
        }

        public PointerBuffer mColors() {
            return AIAnimMesh.nmColors(this.address());
        }

        public AIColor4D.Buffer mColors(int index) {
            return AIAnimMesh.nmColors(this.address(), index);
        }

        public PointerBuffer mTextureCoords() {
            return AIAnimMesh.nmTextureCoords(this.address());
        }

        public AIVector3D.Buffer mTextureCoords(int index) {
            return AIAnimMesh.nmTextureCoords(this.address(), index);
        }

        public int mNumVertices() {
            return AIAnimMesh.nmNumVertices(this.address());
        }

        public Buffer mVertices(AIVector3D.Buffer value) {
            AIAnimMesh.nmVertices(this.address(), value);
            return this;
        }

        public Buffer mNormals(AIVector3D.Buffer value) {
            AIAnimMesh.nmNormals(this.address(), value);
            return this;
        }

        public Buffer mTangents(AIVector3D.Buffer value) {
            AIAnimMesh.nmTangents(this.address(), value);
            return this;
        }

        public Buffer mBitangents(AIVector3D.Buffer value) {
            AIAnimMesh.nmBitangents(this.address(), value);
            return this;
        }

        public Buffer mColors(PointerBuffer value) {
            AIAnimMesh.nmColors(this.address(), value);
            return this;
        }

        public Buffer mColors(int index, AIColor4D.Buffer value) {
            AIAnimMesh.nmColors(this.address(), index, value);
            return this;
        }

        public Buffer mTextureCoords(PointerBuffer value) {
            AIAnimMesh.nmTextureCoords(this.address(), value);
            return this;
        }

        public Buffer mTextureCoords(int index, AIVector3D.Buffer value) {
            AIAnimMesh.nmTextureCoords(this.address(), index, value);
            return this;
        }

        public Buffer mNumVertices(int value) {
            AIAnimMesh.nmNumVertices(this.address(), value);
            return this;
        }
    }
}

