/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.CRC32;
import org.joml.Platform;

final class SharedLibraryLoader {
    private static final int BUFFER_SIZE = 1024;
    private static final String JOML_LIBRARY_NAME = System.getProperty("os.arch").lastIndexOf("64") != -1 ? "joml" : "joml32";
    private static File extractPath;
    static /* synthetic */ Class class$org$joml$SharedLibraryLoader;

    private SharedLibraryLoader() {
    }

    static void load() throws IOException {
        try {
            extractPath = SharedLibraryLoader.extractFile(Platform.PLATFORM.mapLibraryName(JOML_LIBRARY_NAME), null).getParentFile();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to extract the JOML shared library", e);
        }
        SharedLibraryLoader.load(Platform.PLATFORM.mapLibraryName(JOML_LIBRARY_NAME));
    }

    private static void load(String library) throws IOException {
        File extracted = SharedLibraryLoader.extractFile(Platform.PLATFORM.mapLibraryName(library), extractPath);
        System.load(extracted.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractFile(String libraryFile, File libraryPath) throws IOException {
        String libraryCRC;
        URL resource = (class$org$joml$SharedLibraryLoader == null ? (class$org$joml$SharedLibraryLoader = SharedLibraryLoader.class$("org.joml.SharedLibraryLoader")) : class$org$joml$SharedLibraryLoader).getResource("/" + libraryFile);
        if (resource == null) {
            throw new RuntimeException("Failed to locate resource: " + libraryFile);
        }
        InputStream input = resource.openStream();
        try {
            libraryCRC = SharedLibraryLoader.crc(input);
        }
        finally {
            input.close();
        }
        File extractedFile = SharedLibraryLoader.getExtractedFile(libraryPath == null ? new File(libraryCRC) : libraryPath, new File(libraryFile).getName());
        SharedLibraryLoader.extractFile(resource, libraryCRC, extractedFile);
        return extractedFile;
    }

    private static File getExtractedFile(File libraryPath, String fileName) {
        if (libraryPath.isDirectory()) {
            return new File(libraryPath, fileName);
        }
        String tempDirectory = "joml" + System.getProperty("user.name");
        File file = new File(System.getProperty("java.io.tmpdir") + "/" + tempDirectory + "/" + libraryPath, fileName);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFile(URL resource, String libraryCRC, File extractedFile) throws IOException {
        InputStream input;
        String extractedCrc = null;
        if (extractedFile.exists()) {
            input = new FileInputStream(extractedFile);
            try {
                extractedCrc = SharedLibraryLoader.crc(input);
            }
            finally {
                input.close();
            }
        }
        if (extractedCrc == null || !extractedCrc.equals(libraryCRC)) {
            extractedFile.getParentFile().mkdirs();
            input = resource.openStream();
            FileOutputStream output = new FileOutputStream(extractedFile);
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = input.read(buffer)) > 0) {
                    output.write(buffer, 0, n);
                }
            }
            finally {
                input.close();
                output.close();
            }
        }
    }

    private static String crc(InputStream input) throws IOException {
        int n;
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[1024];
        while ((n = input.read(buffer)) > 0) {
            crc.update(buffer, 0, n);
        }
        return Long.toHexString(crc.getValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

