/*
 * Decompiled with CFR 0.152.
 */
package org.jocl.blast;

import org.jocl.CL;
import org.jocl.CLException;
import org.jocl.LibUtils;
import org.jocl.blast.CLBlastStatusCode;
import org.jocl.cl_command_queue;
import org.jocl.cl_device_id;
import org.jocl.cl_event;
import org.jocl.cl_mem;

public class CLBlast {
    private static boolean exceptionsEnabled;
    public static final int JOCL_BLAST_STATUS_INTERNAL_ERROR = -32786;

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CLException(CLBlastStatusCode.stringFor(result), result);
        }
        return result;
    }

    private static cl_mem checkResult(cl_mem result) {
        if (exceptionsEnabled && result == null) {
            throw new CLException("Could not create cl_mem");
        }
        return result;
    }

    public static void setLogLevel(CL.LogLevel logLevel) {
        CLBlast.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static int CLBlastSrotg(cl_mem sa_buffer, long sa_offset, cl_mem sb_buffer, long sb_offset, cl_mem sc_buffer, long sc_offset, cl_mem ss_buffer, long ss_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSrotgNative(sa_buffer, sa_offset, sb_buffer, sb_offset, sc_buffer, sc_offset, ss_buffer, ss_offset, queue, event));
    }

    private static native int CLBlastSrotgNative(cl_mem var0, long var1, cl_mem var3, long var4, cl_mem var6, long var7, cl_mem var9, long var10, cl_command_queue var12, cl_event var13);

    public static int CLBlastDrotg(cl_mem sa_buffer, long sa_offset, cl_mem sb_buffer, long sb_offset, cl_mem sc_buffer, long sc_offset, cl_mem ss_buffer, long ss_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDrotgNative(sa_buffer, sa_offset, sb_buffer, sb_offset, sc_buffer, sc_offset, ss_buffer, ss_offset, queue, event));
    }

    private static native int CLBlastDrotgNative(cl_mem var0, long var1, cl_mem var3, long var4, cl_mem var6, long var7, cl_mem var9, long var10, cl_command_queue var12, cl_event var13);

    public static int CLBlastSrotmg(cl_mem sd1_buffer, long sd1_offset, cl_mem sd2_buffer, long sd2_offset, cl_mem sx1_buffer, long sx1_offset, cl_mem sy1_buffer, long sy1_offset, cl_mem sparam_buffer, long sparam_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSrotmgNative(sd1_buffer, sd1_offset, sd2_buffer, sd2_offset, sx1_buffer, sx1_offset, sy1_buffer, sy1_offset, sparam_buffer, sparam_offset, queue, event));
    }

    private static native int CLBlastSrotmgNative(cl_mem var0, long var1, cl_mem var3, long var4, cl_mem var6, long var7, cl_mem var9, long var10, cl_mem var12, long var13, cl_command_queue var15, cl_event var16);

    public static int CLBlastDrotmg(cl_mem sd1_buffer, long sd1_offset, cl_mem sd2_buffer, long sd2_offset, cl_mem sx1_buffer, long sx1_offset, cl_mem sy1_buffer, long sy1_offset, cl_mem sparam_buffer, long sparam_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDrotmgNative(sd1_buffer, sd1_offset, sd2_buffer, sd2_offset, sx1_buffer, sx1_offset, sy1_buffer, sy1_offset, sparam_buffer, sparam_offset, queue, event));
    }

    private static native int CLBlastDrotmgNative(cl_mem var0, long var1, cl_mem var3, long var4, cl_mem var6, long var7, cl_mem var9, long var10, cl_mem var12, long var13, cl_command_queue var15, cl_event var16);

    public static int CLBlastSrot(long n, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, float cos, float sin, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSrotNative(n, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, cos, sin, queue, event));
    }

    private static native int CLBlastSrotNative(long var0, cl_mem var2, long var3, long var5, cl_mem var7, long var8, long var10, float var12, float var13, cl_command_queue var14, cl_event var15);

    public static int CLBlastDrot(long n, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, double cos, double sin, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDrotNative(n, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, cos, sin, queue, event));
    }

    private static native int CLBlastDrotNative(long var0, cl_mem var2, long var3, long var5, cl_mem var7, long var8, long var10, double var12, double var14, cl_command_queue var16, cl_event var17);

    public static int CLBlastSrotm(long n, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem sparam_buffer, long sparam_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSrotmNative(n, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, sparam_buffer, sparam_offset, queue, event));
    }

    private static native int CLBlastSrotmNative(long var0, cl_mem var2, long var3, long var5, cl_mem var7, long var8, long var10, cl_mem var12, long var13, cl_command_queue var15, cl_event var16);

    public static int CLBlastDrotm(long n, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem sparam_buffer, long sparam_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDrotmNative(n, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, sparam_buffer, sparam_offset, queue, event));
    }

    private static native int CLBlastDrotmNative(long var0, cl_mem var2, long var3, long var5, cl_mem var7, long var8, long var10, cl_mem var12, long var13, cl_command_queue var15, cl_event var16);

    public static int CLBlastSswap(long n, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSswapNative(n, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastSswapNative(long var0, cl_mem var2, long var3, long var5, cl_mem var7, long var8, long var10, cl_command_queue var12, cl_event var13);

    public static int CLBlastDswap(long n, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDswapNative(n, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastDswapNative(long var0, cl_mem var2, long var3, long var5, cl_mem var7, long var8, long var10, cl_command_queue var12, cl_event var13);

    public static int CLBlastCswap(long n, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCswapNative(n, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastCswapNative(long var0, cl_mem var2, long var3, long var5, cl_mem var7, long var8, long var10, cl_command_queue var12, cl_event var13);

    public static int CLBlastZswap(long n, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZswapNative(n, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastZswapNative(long var0, cl_mem var2, long var3, long var5, cl_mem var7, long var8, long var10, cl_command_queue var12, cl_event var13);

    public static int CLBlastSscal(long n, float alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSscalNative(n, alpha, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastSscalNative(long var0, float var2, cl_mem var3, long var4, long var6, cl_command_queue var8, cl_event var9);

    public static int CLBlastDscal(long n, double alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDscalNative(n, alpha, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDscalNative(long var0, double var2, cl_mem var4, long var5, long var7, cl_command_queue var9, cl_event var10);

    public static int CLBlastCscal(long n, float[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCscalNative(n, alpha, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastCscalNative(long var0, float[] var2, cl_mem var3, long var4, long var6, cl_command_queue var8, cl_event var9);

    public static int CLBlastZscal(long n, double[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZscalNative(n, alpha, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastZscalNative(long var0, double[] var2, cl_mem var3, long var4, long var6, cl_command_queue var8, cl_event var9);

    public static int CLBlastScopy(long n, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastScopyNative(n, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastScopyNative(long var0, cl_mem var2, long var3, long var5, cl_mem var7, long var8, long var10, cl_command_queue var12, cl_event var13);

    public static int CLBlastDcopy(long n, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDcopyNative(n, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastDcopyNative(long var0, cl_mem var2, long var3, long var5, cl_mem var7, long var8, long var10, cl_command_queue var12, cl_event var13);

    public static int CLBlastCcopy(long n, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCcopyNative(n, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastCcopyNative(long var0, cl_mem var2, long var3, long var5, cl_mem var7, long var8, long var10, cl_command_queue var12, cl_event var13);

    public static int CLBlastZcopy(long n, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZcopyNative(n, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastZcopyNative(long var0, cl_mem var2, long var3, long var5, cl_mem var7, long var8, long var10, cl_command_queue var12, cl_event var13);

    public static int CLBlastSaxpy(long n, float alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSaxpyNative(n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastSaxpyNative(long var0, float var2, cl_mem var3, long var4, long var6, cl_mem var8, long var9, long var11, cl_command_queue var13, cl_event var14);

    public static int CLBlastDaxpy(long n, double alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDaxpyNative(n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastDaxpyNative(long var0, double var2, cl_mem var4, long var5, long var7, cl_mem var9, long var10, long var12, cl_command_queue var14, cl_event var15);

    public static int CLBlastCaxpy(long n, float[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCaxpyNative(n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastCaxpyNative(long var0, float[] var2, cl_mem var3, long var4, long var6, cl_mem var8, long var9, long var11, cl_command_queue var13, cl_event var14);

    public static int CLBlastZaxpy(long n, double[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZaxpyNative(n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastZaxpyNative(long var0, double[] var2, cl_mem var3, long var4, long var6, cl_mem var8, long var9, long var11, cl_command_queue var13, cl_event var14);

    public static int CLBlastSdot(long n, cl_mem dot_buffer, long dot_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSdotNative(n, dot_buffer, dot_offset, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastSdotNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_command_queue var15, cl_event var16);

    public static int CLBlastDdot(long n, cl_mem dot_buffer, long dot_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDdotNative(n, dot_buffer, dot_offset, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastDdotNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_command_queue var15, cl_event var16);

    public static int CLBlastCdotu(long n, cl_mem dot_buffer, long dot_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCdotuNative(n, dot_buffer, dot_offset, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastCdotuNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_command_queue var15, cl_event var16);

    public static int CLBlastZdotu(long n, cl_mem dot_buffer, long dot_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZdotuNative(n, dot_buffer, dot_offset, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastZdotuNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_command_queue var15, cl_event var16);

    public static int CLBlastCdotc(long n, cl_mem dot_buffer, long dot_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCdotcNative(n, dot_buffer, dot_offset, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastCdotcNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_command_queue var15, cl_event var16);

    public static int CLBlastZdotc(long n, cl_mem dot_buffer, long dot_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZdotcNative(n, dot_buffer, dot_offset, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastZdotcNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_command_queue var15, cl_event var16);

    public static int CLBlastSnrm2(long n, cl_mem nrm2_buffer, long nrm2_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSnrm2Native(n, nrm2_buffer, nrm2_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastSnrm2Native(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastDnrm2(long n, cl_mem nrm2_buffer, long nrm2_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDnrm2Native(n, nrm2_buffer, nrm2_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDnrm2Native(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastScnrm2(long n, cl_mem nrm2_buffer, long nrm2_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastScnrm2Native(n, nrm2_buffer, nrm2_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastScnrm2Native(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastDznrm2(long n, cl_mem nrm2_buffer, long nrm2_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDznrm2Native(n, nrm2_buffer, nrm2_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDznrm2Native(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastSasum(long n, cl_mem asum_buffer, long asum_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSasumNative(n, asum_buffer, asum_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastSasumNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastDasum(long n, cl_mem asum_buffer, long asum_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDasumNative(n, asum_buffer, asum_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDasumNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastScasum(long n, cl_mem asum_buffer, long asum_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastScasumNative(n, asum_buffer, asum_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastScasumNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastDzasum(long n, cl_mem asum_buffer, long asum_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDzasumNative(n, asum_buffer, asum_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDzasumNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastSsum(long n, cl_mem sum_buffer, long sum_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSsumNative(n, sum_buffer, sum_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastSsumNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastDsum(long n, cl_mem sum_buffer, long sum_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDsumNative(n, sum_buffer, sum_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDsumNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastScsum(long n, cl_mem sum_buffer, long sum_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastScsumNative(n, sum_buffer, sum_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastScsumNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastDzsum(long n, cl_mem sum_buffer, long sum_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDzsumNative(n, sum_buffer, sum_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDzsumNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiSamax(long n, cl_mem imax_buffer, long imax_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiSamaxNative(n, imax_buffer, imax_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiSamaxNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiDamax(long n, cl_mem imax_buffer, long imax_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiDamaxNative(n, imax_buffer, imax_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiDamaxNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiCamax(long n, cl_mem imax_buffer, long imax_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiCamaxNative(n, imax_buffer, imax_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiCamaxNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiZamax(long n, cl_mem imax_buffer, long imax_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiZamaxNative(n, imax_buffer, imax_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiZamaxNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiSamin(long n, cl_mem imin_buffer, long imin_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiSaminNative(n, imin_buffer, imin_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiSaminNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiDamin(long n, cl_mem imin_buffer, long imin_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiDaminNative(n, imin_buffer, imin_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiDaminNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiCamin(long n, cl_mem imin_buffer, long imin_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiCaminNative(n, imin_buffer, imin_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiCaminNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiZamin(long n, cl_mem imin_buffer, long imin_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiZaminNative(n, imin_buffer, imin_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiZaminNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiSmax(long n, cl_mem imax_buffer, long imax_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiSmaxNative(n, imax_buffer, imax_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiSmaxNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiDmax(long n, cl_mem imax_buffer, long imax_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiDmaxNative(n, imax_buffer, imax_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiDmaxNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiCmax(long n, cl_mem imax_buffer, long imax_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiCmaxNative(n, imax_buffer, imax_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiCmaxNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiZmax(long n, cl_mem imax_buffer, long imax_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiZmaxNative(n, imax_buffer, imax_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiZmaxNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiSmin(long n, cl_mem imin_buffer, long imin_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiSminNative(n, imin_buffer, imin_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiSminNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiDmin(long n, cl_mem imin_buffer, long imin_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiDminNative(n, imin_buffer, imin_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiDminNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiCmin(long n, cl_mem imin_buffer, long imin_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiCminNative(n, imin_buffer, imin_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiCminNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastiZmin(long n, cl_mem imin_buffer, long imin_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastiZminNative(n, imin_buffer, imin_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastiZminNative(long var0, cl_mem var2, long var3, cl_mem var5, long var6, long var8, cl_command_queue var10, cl_event var11);

    public static int CLBlastSgemv(int layout, int a_transpose, long m, long n, float alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, float beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSgemvNative(layout, a_transpose, m, n, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastSgemvNative(int var0, int var1, long var2, long var4, float var6, cl_mem var7, long var8, long var10, cl_mem var12, long var13, long var15, float var17, cl_mem var18, long var19, long var21, cl_command_queue var23, cl_event var24);

    public static int CLBlastDgemv(int layout, int a_transpose, long m, long n, double alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, double beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDgemvNative(layout, a_transpose, m, n, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastDgemvNative(int var0, int var1, long var2, long var4, double var6, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, double var18, cl_mem var20, long var21, long var23, cl_command_queue var25, cl_event var26);

    public static int CLBlastCgemv(int layout, int a_transpose, long m, long n, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, float[] beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCgemvNative(layout, a_transpose, m, n, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastCgemvNative(int var0, int var1, long var2, long var4, float[] var6, cl_mem var7, long var8, long var10, cl_mem var12, long var13, long var15, float[] var17, cl_mem var18, long var19, long var21, cl_command_queue var23, cl_event var24);

    public static int CLBlastZgemv(int layout, int a_transpose, long m, long n, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, double[] beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZgemvNative(layout, a_transpose, m, n, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastZgemvNative(int var0, int var1, long var2, long var4, double[] var6, cl_mem var7, long var8, long var10, cl_mem var12, long var13, long var15, double[] var17, cl_mem var18, long var19, long var21, cl_command_queue var23, cl_event var24);

    public static int CLBlastSgbmv(int layout, int a_transpose, long m, long n, long kl, long ku, float alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, float beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSgbmvNative(layout, a_transpose, m, n, kl, ku, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastSgbmvNative(int var0, int var1, long var2, long var4, long var6, long var8, float var10, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, float var21, cl_mem var22, long var23, long var25, cl_command_queue var27, cl_event var28);

    public static int CLBlastDgbmv(int layout, int a_transpose, long m, long n, long kl, long ku, double alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, double beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDgbmvNative(layout, a_transpose, m, n, kl, ku, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastDgbmvNative(int var0, int var1, long var2, long var4, long var6, long var8, double var10, cl_mem var12, long var13, long var15, cl_mem var17, long var18, long var20, double var22, cl_mem var24, long var25, long var27, cl_command_queue var29, cl_event var30);

    public static int CLBlastCgbmv(int layout, int a_transpose, long m, long n, long kl, long ku, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, float[] beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCgbmvNative(layout, a_transpose, m, n, kl, ku, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastCgbmvNative(int var0, int var1, long var2, long var4, long var6, long var8, float[] var10, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, float[] var21, cl_mem var22, long var23, long var25, cl_command_queue var27, cl_event var28);

    public static int CLBlastZgbmv(int layout, int a_transpose, long m, long n, long kl, long ku, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, double[] beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZgbmvNative(layout, a_transpose, m, n, kl, ku, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastZgbmvNative(int var0, int var1, long var2, long var4, long var6, long var8, double[] var10, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, double[] var21, cl_mem var22, long var23, long var25, cl_command_queue var27, cl_event var28);

    public static int CLBlastChemv(int layout, int triangle, long n, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, float[] beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastChemvNative(layout, triangle, n, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastChemvNative(int var0, int var1, long var2, float[] var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, float[] var15, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastZhemv(int layout, int triangle, long n, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, double[] beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZhemvNative(layout, triangle, n, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastZhemvNative(int var0, int var1, long var2, double[] var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, double[] var15, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastChbmv(int layout, int triangle, long n, long k, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, float[] beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastChbmvNative(layout, triangle, n, k, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastChbmvNative(int var0, int var1, long var2, long var4, float[] var6, cl_mem var7, long var8, long var10, cl_mem var12, long var13, long var15, float[] var17, cl_mem var18, long var19, long var21, cl_command_queue var23, cl_event var24);

    public static int CLBlastZhbmv(int layout, int triangle, long n, long k, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, double[] beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZhbmvNative(layout, triangle, n, k, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastZhbmvNative(int var0, int var1, long var2, long var4, double[] var6, cl_mem var7, long var8, long var10, cl_mem var12, long var13, long var15, double[] var17, cl_mem var18, long var19, long var21, cl_command_queue var23, cl_event var24);

    public static int CLBlastChpmv(int layout, int triangle, long n, float[] alpha, cl_mem ap_buffer, long ap_offset, cl_mem x_buffer, long x_offset, long x_inc, float[] beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastChpmvNative(layout, triangle, n, alpha, ap_buffer, ap_offset, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastChpmvNative(int var0, int var1, long var2, float[] var4, cl_mem var5, long var6, cl_mem var8, long var9, long var11, float[] var13, cl_mem var14, long var15, long var17, cl_command_queue var19, cl_event var20);

    public static int CLBlastZhpmv(int layout, int triangle, long n, double[] alpha, cl_mem ap_buffer, long ap_offset, cl_mem x_buffer, long x_offset, long x_inc, double[] beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZhpmvNative(layout, triangle, n, alpha, ap_buffer, ap_offset, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastZhpmvNative(int var0, int var1, long var2, double[] var4, cl_mem var5, long var6, cl_mem var8, long var9, long var11, double[] var13, cl_mem var14, long var15, long var17, cl_command_queue var19, cl_event var20);

    public static int CLBlastSsymv(int layout, int triangle, long n, float alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, float beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSsymvNative(layout, triangle, n, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastSsymvNative(int var0, int var1, long var2, float var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, float var15, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastDsymv(int layout, int triangle, long n, double alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, double beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDsymvNative(layout, triangle, n, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastDsymvNative(int var0, int var1, long var2, double var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, double var16, cl_mem var18, long var19, long var21, cl_command_queue var23, cl_event var24);

    public static int CLBlastSsbmv(int layout, int triangle, long n, long k, float alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, float beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSsbmvNative(layout, triangle, n, k, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastSsbmvNative(int var0, int var1, long var2, long var4, float var6, cl_mem var7, long var8, long var10, cl_mem var12, long var13, long var15, float var17, cl_mem var18, long var19, long var21, cl_command_queue var23, cl_event var24);

    public static int CLBlastDsbmv(int layout, int triangle, long n, long k, double alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, double beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDsbmvNative(layout, triangle, n, k, alpha, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastDsbmvNative(int var0, int var1, long var2, long var4, double var6, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, double var18, cl_mem var20, long var21, long var23, cl_command_queue var25, cl_event var26);

    public static int CLBlastSspmv(int layout, int triangle, long n, float alpha, cl_mem ap_buffer, long ap_offset, cl_mem x_buffer, long x_offset, long x_inc, float beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSspmvNative(layout, triangle, n, alpha, ap_buffer, ap_offset, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastSspmvNative(int var0, int var1, long var2, float var4, cl_mem var5, long var6, cl_mem var8, long var9, long var11, float var13, cl_mem var14, long var15, long var17, cl_command_queue var19, cl_event var20);

    public static int CLBlastDspmv(int layout, int triangle, long n, double alpha, cl_mem ap_buffer, long ap_offset, cl_mem x_buffer, long x_offset, long x_inc, double beta, cl_mem y_buffer, long y_offset, long y_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDspmvNative(layout, triangle, n, alpha, ap_buffer, ap_offset, x_buffer, x_offset, x_inc, beta, y_buffer, y_offset, y_inc, queue, event));
    }

    private static native int CLBlastDspmvNative(int var0, int var1, long var2, double var4, cl_mem var6, long var7, cl_mem var9, long var10, long var12, double var14, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastStrmv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastStrmvNative(layout, triangle, a_transpose, diagonal, n, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastStrmvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_command_queue var16, cl_event var17);

    public static int CLBlastDtrmv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDtrmvNative(layout, triangle, a_transpose, diagonal, n, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDtrmvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_command_queue var16, cl_event var17);

    public static int CLBlastCtrmv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCtrmvNative(layout, triangle, a_transpose, diagonal, n, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastCtrmvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_command_queue var16, cl_event var17);

    public static int CLBlastZtrmv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZtrmvNative(layout, triangle, a_transpose, diagonal, n, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastZtrmvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_command_queue var16, cl_event var17);

    public static int CLBlastStbmv(int layout, int triangle, int a_transpose, int diagonal, long n, long k, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastStbmvNative(layout, triangle, a_transpose, diagonal, n, k, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastStbmvNative(int var0, int var1, int var2, int var3, long var4, long var6, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, cl_command_queue var18, cl_event var19);

    public static int CLBlastDtbmv(int layout, int triangle, int a_transpose, int diagonal, long n, long k, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDtbmvNative(layout, triangle, a_transpose, diagonal, n, k, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDtbmvNative(int var0, int var1, int var2, int var3, long var4, long var6, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, cl_command_queue var18, cl_event var19);

    public static int CLBlastCtbmv(int layout, int triangle, int a_transpose, int diagonal, long n, long k, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCtbmvNative(layout, triangle, a_transpose, diagonal, n, k, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastCtbmvNative(int var0, int var1, int var2, int var3, long var4, long var6, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, cl_command_queue var18, cl_event var19);

    public static int CLBlastZtbmv(int layout, int triangle, int a_transpose, int diagonal, long n, long k, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZtbmvNative(layout, triangle, a_transpose, diagonal, n, k, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastZtbmvNative(int var0, int var1, int var2, int var3, long var4, long var6, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, cl_command_queue var18, cl_event var19);

    public static int CLBlastStpmv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem ap_buffer, long ap_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastStpmvNative(layout, triangle, a_transpose, diagonal, n, ap_buffer, ap_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastStpmvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, cl_mem var9, long var10, long var12, cl_command_queue var14, cl_event var15);

    public static int CLBlastDtpmv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem ap_buffer, long ap_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDtpmvNative(layout, triangle, a_transpose, diagonal, n, ap_buffer, ap_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDtpmvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, cl_mem var9, long var10, long var12, cl_command_queue var14, cl_event var15);

    public static int CLBlastCtpmv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem ap_buffer, long ap_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCtpmvNative(layout, triangle, a_transpose, diagonal, n, ap_buffer, ap_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastCtpmvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, cl_mem var9, long var10, long var12, cl_command_queue var14, cl_event var15);

    public static int CLBlastZtpmv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem ap_buffer, long ap_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZtpmvNative(layout, triangle, a_transpose, diagonal, n, ap_buffer, ap_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastZtpmvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, cl_mem var9, long var10, long var12, cl_command_queue var14, cl_event var15);

    public static int CLBlastStrsv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastStrsvNative(layout, triangle, a_transpose, diagonal, n, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastStrsvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_command_queue var16, cl_event var17);

    public static int CLBlastDtrsv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDtrsvNative(layout, triangle, a_transpose, diagonal, n, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDtrsvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_command_queue var16, cl_event var17);

    public static int CLBlastCtrsv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCtrsvNative(layout, triangle, a_transpose, diagonal, n, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastCtrsvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_command_queue var16, cl_event var17);

    public static int CLBlastZtrsv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZtrsvNative(layout, triangle, a_transpose, diagonal, n, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastZtrsvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_command_queue var16, cl_event var17);

    public static int CLBlastStbsv(int layout, int triangle, int a_transpose, int diagonal, long n, long k, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastStbsvNative(layout, triangle, a_transpose, diagonal, n, k, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastStbsvNative(int var0, int var1, int var2, int var3, long var4, long var6, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, cl_command_queue var18, cl_event var19);

    public static int CLBlastDtbsv(int layout, int triangle, int a_transpose, int diagonal, long n, long k, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDtbsvNative(layout, triangle, a_transpose, diagonal, n, k, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDtbsvNative(int var0, int var1, int var2, int var3, long var4, long var6, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, cl_command_queue var18, cl_event var19);

    public static int CLBlastCtbsv(int layout, int triangle, int a_transpose, int diagonal, long n, long k, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCtbsvNative(layout, triangle, a_transpose, diagonal, n, k, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastCtbsvNative(int var0, int var1, int var2, int var3, long var4, long var6, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, cl_command_queue var18, cl_event var19);

    public static int CLBlastZtbsv(int layout, int triangle, int a_transpose, int diagonal, long n, long k, cl_mem a_buffer, long a_offset, long a_ld, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZtbsvNative(layout, triangle, a_transpose, diagonal, n, k, a_buffer, a_offset, a_ld, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastZtbsvNative(int var0, int var1, int var2, int var3, long var4, long var6, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, cl_command_queue var18, cl_event var19);

    public static int CLBlastStpsv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem ap_buffer, long ap_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastStpsvNative(layout, triangle, a_transpose, diagonal, n, ap_buffer, ap_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastStpsvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, cl_mem var9, long var10, long var12, cl_command_queue var14, cl_event var15);

    public static int CLBlastDtpsv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem ap_buffer, long ap_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDtpsvNative(layout, triangle, a_transpose, diagonal, n, ap_buffer, ap_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastDtpsvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, cl_mem var9, long var10, long var12, cl_command_queue var14, cl_event var15);

    public static int CLBlastCtpsv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem ap_buffer, long ap_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCtpsvNative(layout, triangle, a_transpose, diagonal, n, ap_buffer, ap_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastCtpsvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, cl_mem var9, long var10, long var12, cl_command_queue var14, cl_event var15);

    public static int CLBlastZtpsv(int layout, int triangle, int a_transpose, int diagonal, long n, cl_mem ap_buffer, long ap_offset, cl_mem x_buffer, long x_offset, long x_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZtpsvNative(layout, triangle, a_transpose, diagonal, n, ap_buffer, ap_offset, x_buffer, x_offset, x_inc, queue, event));
    }

    private static native int CLBlastZtpsvNative(int var0, int var1, int var2, int var3, long var4, cl_mem var6, long var7, cl_mem var9, long var10, long var12, cl_command_queue var14, cl_event var15);

    public static int CLBlastSger(int layout, long m, long n, float alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSgerNative(layout, m, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastSgerNative(int var0, long var1, long var3, float var5, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastDger(int layout, long m, long n, double alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDgerNative(layout, m, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastDgerNative(int var0, long var1, long var3, double var5, cl_mem var7, long var8, long var10, cl_mem var12, long var13, long var15, cl_mem var17, long var18, long var20, cl_command_queue var22, cl_event var23);

    public static int CLBlastCgeru(int layout, long m, long n, float[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCgeruNative(layout, m, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastCgeruNative(int var0, long var1, long var3, float[] var5, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastZgeru(int layout, long m, long n, double[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZgeruNative(layout, m, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastZgeruNative(int var0, long var1, long var3, double[] var5, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastCgerc(int layout, long m, long n, float[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCgercNative(layout, m, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastCgercNative(int var0, long var1, long var3, float[] var5, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastZgerc(int layout, long m, long n, double[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZgercNative(layout, m, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastZgercNative(int var0, long var1, long var3, double[] var5, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastCher(int layout, int triangle, long n, float alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCherNative(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastCherNative(int var0, int var1, long var2, float var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_command_queue var15, cl_event var16);

    public static int CLBlastZher(int layout, int triangle, long n, double alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZherNative(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastZherNative(int var0, int var1, long var2, double var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_command_queue var16, cl_event var17);

    public static int CLBlastChpr(int layout, int triangle, long n, float alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem ap_buffer, long ap_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastChprNative(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, ap_buffer, ap_offset, queue, event));
    }

    private static native int CLBlastChprNative(int var0, int var1, long var2, float var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, cl_command_queue var13, cl_event var14);

    public static int CLBlastZhpr(int layout, int triangle, long n, double alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem ap_buffer, long ap_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZhprNative(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, ap_buffer, ap_offset, queue, event));
    }

    private static native int CLBlastZhprNative(int var0, int var1, long var2, double var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, cl_command_queue var14, cl_event var15);

    public static int CLBlastCher2(int layout, int triangle, long n, float[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCher2Native(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastCher2Native(int var0, int var1, long var2, float[] var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, cl_command_queue var20, cl_event var21);

    public static int CLBlastZher2(int layout, int triangle, long n, double[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZher2Native(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastZher2Native(int var0, int var1, long var2, double[] var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, cl_command_queue var20, cl_event var21);

    public static int CLBlastChpr2(int layout, int triangle, long n, float[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem ap_buffer, long ap_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastChpr2Native(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, ap_buffer, ap_offset, queue, event));
    }

    private static native int CLBlastChpr2Native(int var0, int var1, long var2, float[] var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_mem var15, long var16, cl_command_queue var18, cl_event var19);

    public static int CLBlastZhpr2(int layout, int triangle, long n, double[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem ap_buffer, long ap_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZhpr2Native(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, ap_buffer, ap_offset, queue, event));
    }

    private static native int CLBlastZhpr2Native(int var0, int var1, long var2, double[] var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_mem var15, long var16, cl_command_queue var18, cl_event var19);

    public static int CLBlastSsyr(int layout, int triangle, long n, float alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSsyrNative(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastSsyrNative(int var0, int var1, long var2, float var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_command_queue var15, cl_event var16);

    public static int CLBlastDsyr(int layout, int triangle, long n, double alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDsyrNative(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastDsyrNative(int var0, int var1, long var2, double var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_command_queue var16, cl_event var17);

    public static int CLBlastSspr(int layout, int triangle, long n, float alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem ap_buffer, long ap_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSsprNative(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, ap_buffer, ap_offset, queue, event));
    }

    private static native int CLBlastSsprNative(int var0, int var1, long var2, float var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, cl_command_queue var13, cl_event var14);

    public static int CLBlastDspr(int layout, int triangle, long n, double alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem ap_buffer, long ap_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDsprNative(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, ap_buffer, ap_offset, queue, event));
    }

    private static native int CLBlastDsprNative(int var0, int var1, long var2, double var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, cl_command_queue var14, cl_event var15);

    public static int CLBlastSsyr2(int layout, int triangle, long n, float alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSsyr2Native(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastSsyr2Native(int var0, int var1, long var2, float var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, cl_command_queue var20, cl_event var21);

    public static int CLBlastDsyr2(int layout, int triangle, long n, double alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem a_buffer, long a_offset, long a_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDsyr2Native(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, a_buffer, a_offset, a_ld, queue, event));
    }

    private static native int CLBlastDsyr2Native(int var0, int var1, long var2, double var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastSspr2(int layout, int triangle, long n, float alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem ap_buffer, long ap_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSspr2Native(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, ap_buffer, ap_offset, queue, event));
    }

    private static native int CLBlastSspr2Native(int var0, int var1, long var2, float var4, cl_mem var5, long var6, long var8, cl_mem var10, long var11, long var13, cl_mem var15, long var16, cl_command_queue var18, cl_event var19);

    public static int CLBlastDspr2(int layout, int triangle, long n, double alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, cl_mem ap_buffer, long ap_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDspr2Native(layout, triangle, n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, ap_buffer, ap_offset, queue, event));
    }

    private static native int CLBlastDspr2Native(int var0, int var1, long var2, double var4, cl_mem var6, long var7, long var9, cl_mem var11, long var12, long var14, cl_mem var16, long var17, cl_command_queue var19, cl_event var20);

    public static int CLBlastSgemm(int layout, int a_transpose, int b_transpose, long m, long n, long k, float alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, float beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSgemmNative(layout, a_transpose, b_transpose, m, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastSgemmNative(int var0, int var1, int var2, long var3, long var5, long var7, float var9, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, float var20, cl_mem var21, long var22, long var24, cl_command_queue var26, cl_event var27);

    public static int CLBlastDgemm(int layout, int a_transpose, int b_transpose, long m, long n, long k, double alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, double beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDgemmNative(layout, a_transpose, b_transpose, m, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastDgemmNative(int var0, int var1, int var2, long var3, long var5, long var7, double var9, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, double var21, cl_mem var23, long var24, long var26, cl_command_queue var28, cl_event var29);

    public static int CLBlastCgemm(int layout, int a_transpose, int b_transpose, long m, long n, long k, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, float[] beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCgemmNative(layout, a_transpose, b_transpose, m, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastCgemmNative(int var0, int var1, int var2, long var3, long var5, long var7, float[] var9, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, float[] var20, cl_mem var21, long var22, long var24, cl_command_queue var26, cl_event var27);

    public static int CLBlastZgemm(int layout, int a_transpose, int b_transpose, long m, long n, long k, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, double[] beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZgemmNative(layout, a_transpose, b_transpose, m, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastZgemmNative(int var0, int var1, int var2, long var3, long var5, long var7, double[] var9, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, double[] var20, cl_mem var21, long var22, long var24, cl_command_queue var26, cl_event var27);

    public static int CLBlastSsymm(int layout, int side, int triangle, long m, long n, float alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, float beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSsymmNative(layout, side, triangle, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastSsymmNative(int var0, int var1, int var2, long var3, long var5, float var7, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, float var18, cl_mem var19, long var20, long var22, cl_command_queue var24, cl_event var25);

    public static int CLBlastDsymm(int layout, int side, int triangle, long m, long n, double alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, double beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDsymmNative(layout, side, triangle, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastDsymmNative(int var0, int var1, int var2, long var3, long var5, double var7, cl_mem var9, long var10, long var12, cl_mem var14, long var15, long var17, double var19, cl_mem var21, long var22, long var24, cl_command_queue var26, cl_event var27);

    public static int CLBlastCsymm(int layout, int side, int triangle, long m, long n, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, float[] beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCsymmNative(layout, side, triangle, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastCsymmNative(int var0, int var1, int var2, long var3, long var5, float[] var7, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, float[] var18, cl_mem var19, long var20, long var22, cl_command_queue var24, cl_event var25);

    public static int CLBlastZsymm(int layout, int side, int triangle, long m, long n, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, double[] beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZsymmNative(layout, side, triangle, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastZsymmNative(int var0, int var1, int var2, long var3, long var5, double[] var7, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, double[] var18, cl_mem var19, long var20, long var22, cl_command_queue var24, cl_event var25);

    public static int CLBlastChemm(int layout, int side, int triangle, long m, long n, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, float[] beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastChemmNative(layout, side, triangle, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastChemmNative(int var0, int var1, int var2, long var3, long var5, float[] var7, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, float[] var18, cl_mem var19, long var20, long var22, cl_command_queue var24, cl_event var25);

    public static int CLBlastZhemm(int layout, int side, int triangle, long m, long n, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, double[] beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZhemmNative(layout, side, triangle, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastZhemmNative(int var0, int var1, int var2, long var3, long var5, double[] var7, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, double[] var18, cl_mem var19, long var20, long var22, cl_command_queue var24, cl_event var25);

    public static int CLBlastSsyrk(int layout, int triangle, int a_transpose, long n, long k, float alpha, cl_mem a_buffer, long a_offset, long a_ld, float beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSsyrkNative(layout, triangle, a_transpose, n, k, alpha, a_buffer, a_offset, a_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastSsyrkNative(int var0, int var1, int var2, long var3, long var5, float var7, cl_mem var8, long var9, long var11, float var13, cl_mem var14, long var15, long var17, cl_command_queue var19, cl_event var20);

    public static int CLBlastDsyrk(int layout, int triangle, int a_transpose, long n, long k, double alpha, cl_mem a_buffer, long a_offset, long a_ld, double beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDsyrkNative(layout, triangle, a_transpose, n, k, alpha, a_buffer, a_offset, a_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastDsyrkNative(int var0, int var1, int var2, long var3, long var5, double var7, cl_mem var9, long var10, long var12, double var14, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastCsyrk(int layout, int triangle, int a_transpose, long n, long k, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, float[] beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCsyrkNative(layout, triangle, a_transpose, n, k, alpha, a_buffer, a_offset, a_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastCsyrkNative(int var0, int var1, int var2, long var3, long var5, float[] var7, cl_mem var8, long var9, long var11, float[] var13, cl_mem var14, long var15, long var17, cl_command_queue var19, cl_event var20);

    public static int CLBlastZsyrk(int layout, int triangle, int a_transpose, long n, long k, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, double[] beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZsyrkNative(layout, triangle, a_transpose, n, k, alpha, a_buffer, a_offset, a_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastZsyrkNative(int var0, int var1, int var2, long var3, long var5, double[] var7, cl_mem var8, long var9, long var11, double[] var13, cl_mem var14, long var15, long var17, cl_command_queue var19, cl_event var20);

    public static int CLBlastCherk(int layout, int triangle, int a_transpose, long n, long k, float alpha, cl_mem a_buffer, long a_offset, long a_ld, float beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCherkNative(layout, triangle, a_transpose, n, k, alpha, a_buffer, a_offset, a_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastCherkNative(int var0, int var1, int var2, long var3, long var5, float var7, cl_mem var8, long var9, long var11, float var13, cl_mem var14, long var15, long var17, cl_command_queue var19, cl_event var20);

    public static int CLBlastZherk(int layout, int triangle, int a_transpose, long n, long k, double alpha, cl_mem a_buffer, long a_offset, long a_ld, double beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZherkNative(layout, triangle, a_transpose, n, k, alpha, a_buffer, a_offset, a_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastZherkNative(int var0, int var1, int var2, long var3, long var5, double var7, cl_mem var9, long var10, long var12, double var14, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastSsyr2k(int layout, int triangle, int ab_transpose, long n, long k, float alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, float beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSsyr2kNative(layout, triangle, ab_transpose, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastSsyr2kNative(int var0, int var1, int var2, long var3, long var5, float var7, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, float var18, cl_mem var19, long var20, long var22, cl_command_queue var24, cl_event var25);

    public static int CLBlastDsyr2k(int layout, int triangle, int ab_transpose, long n, long k, double alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, double beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDsyr2kNative(layout, triangle, ab_transpose, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastDsyr2kNative(int var0, int var1, int var2, long var3, long var5, double var7, cl_mem var9, long var10, long var12, cl_mem var14, long var15, long var17, double var19, cl_mem var21, long var22, long var24, cl_command_queue var26, cl_event var27);

    public static int CLBlastCsyr2k(int layout, int triangle, int ab_transpose, long n, long k, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, float[] beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCsyr2kNative(layout, triangle, ab_transpose, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastCsyr2kNative(int var0, int var1, int var2, long var3, long var5, float[] var7, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, float[] var18, cl_mem var19, long var20, long var22, cl_command_queue var24, cl_event var25);

    public static int CLBlastZsyr2k(int layout, int triangle, int ab_transpose, long n, long k, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, double[] beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZsyr2kNative(layout, triangle, ab_transpose, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastZsyr2kNative(int var0, int var1, int var2, long var3, long var5, double[] var7, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, double[] var18, cl_mem var19, long var20, long var22, cl_command_queue var24, cl_event var25);

    public static int CLBlastCher2k(int layout, int triangle, int ab_transpose, long n, long k, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, float beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCher2kNative(layout, triangle, ab_transpose, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastCher2kNative(int var0, int var1, int var2, long var3, long var5, float[] var7, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, float var18, cl_mem var19, long var20, long var22, cl_command_queue var24, cl_event var25);

    public static int CLBlastZher2k(int layout, int triangle, int ab_transpose, long n, long k, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, double beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZher2kNative(layout, triangle, ab_transpose, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event));
    }

    private static native int CLBlastZher2kNative(int var0, int var1, int var2, long var3, long var5, double[] var7, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, double var18, cl_mem var20, long var21, long var23, cl_command_queue var25, cl_event var26);

    public static int CLBlastStrmm(int layout, int side, int triangle, int a_transpose, int diagonal, long m, long n, float alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastStrmmNative(layout, side, triangle, a_transpose, diagonal, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, queue, event));
    }

    private static native int CLBlastStrmmNative(int var0, int var1, int var2, int var3, int var4, long var5, long var7, float var9, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, cl_command_queue var20, cl_event var21);

    public static int CLBlastDtrmm(int layout, int side, int triangle, int a_transpose, int diagonal, long m, long n, double alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDtrmmNative(layout, side, triangle, a_transpose, diagonal, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, queue, event));
    }

    private static native int CLBlastDtrmmNative(int var0, int var1, int var2, int var3, int var4, long var5, long var7, double var9, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastCtrmm(int layout, int side, int triangle, int a_transpose, int diagonal, long m, long n, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCtrmmNative(layout, side, triangle, a_transpose, diagonal, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, queue, event));
    }

    private static native int CLBlastCtrmmNative(int var0, int var1, int var2, int var3, int var4, long var5, long var7, float[] var9, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, cl_command_queue var20, cl_event var21);

    public static int CLBlastZtrmm(int layout, int side, int triangle, int a_transpose, int diagonal, long m, long n, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZtrmmNative(layout, side, triangle, a_transpose, diagonal, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, queue, event));
    }

    private static native int CLBlastZtrmmNative(int var0, int var1, int var2, int var3, int var4, long var5, long var7, double[] var9, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, cl_command_queue var20, cl_event var21);

    public static int CLBlastStrsm(int layout, int side, int triangle, int a_transpose, int diagonal, long m, long n, float alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastStrsmNative(layout, side, triangle, a_transpose, diagonal, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, queue, event));
    }

    private static native int CLBlastStrsmNative(int var0, int var1, int var2, int var3, int var4, long var5, long var7, float var9, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, cl_command_queue var20, cl_event var21);

    public static int CLBlastDtrsm(int layout, int side, int triangle, int a_transpose, int diagonal, long m, long n, double alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDtrsmNative(layout, side, triangle, a_transpose, diagonal, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, queue, event));
    }

    private static native int CLBlastDtrsmNative(int var0, int var1, int var2, int var3, int var4, long var5, long var7, double var9, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastCtrsm(int layout, int side, int triangle, int a_transpose, int diagonal, long m, long n, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCtrsmNative(layout, side, triangle, a_transpose, diagonal, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, queue, event));
    }

    private static native int CLBlastCtrsmNative(int var0, int var1, int var2, int var3, int var4, long var5, long var7, float[] var9, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, cl_command_queue var20, cl_event var21);

    public static int CLBlastZtrsm(int layout, int side, int triangle, int a_transpose, int diagonal, long m, long n, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZtrsmNative(layout, side, triangle, a_transpose, diagonal, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, queue, event));
    }

    private static native int CLBlastZtrsmNative(int var0, int var1, int var2, int var3, int var4, long var5, long var7, double[] var9, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, cl_command_queue var20, cl_event var21);

    public static int CLBlastShad(long n, float alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, float beta, cl_mem z_buffer, long z_offset, long z_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastShadNative(n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, beta, z_buffer, z_offset, z_inc, queue, event));
    }

    private static native int CLBlastShadNative(long var0, float var2, cl_mem var3, long var4, long var6, cl_mem var8, long var9, long var11, float var13, cl_mem var14, long var15, long var17, cl_command_queue var19, cl_event var20);

    public static int CLBlastDhad(long n, double alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, double beta, cl_mem z_buffer, long z_offset, long z_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDhadNative(n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, beta, z_buffer, z_offset, z_inc, queue, event));
    }

    private static native int CLBlastDhadNative(long var0, double var2, cl_mem var4, long var5, long var7, cl_mem var9, long var10, long var12, double var14, cl_mem var16, long var17, long var19, cl_command_queue var21, cl_event var22);

    public static int CLBlastChad(long n, float[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, float[] beta, cl_mem z_buffer, long z_offset, long z_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastChadNative(n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, beta, z_buffer, z_offset, z_inc, queue, event));
    }

    private static native int CLBlastChadNative(long var0, float[] var2, cl_mem var3, long var4, long var6, cl_mem var8, long var9, long var11, float[] var13, cl_mem var14, long var15, long var17, cl_command_queue var19, cl_event var20);

    public static int CLBlastZhad(long n, double[] alpha, cl_mem x_buffer, long x_offset, long x_inc, cl_mem y_buffer, long y_offset, long y_inc, double[] beta, cl_mem z_buffer, long z_offset, long z_inc, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZhadNative(n, alpha, x_buffer, x_offset, x_inc, y_buffer, y_offset, y_inc, beta, z_buffer, z_offset, z_inc, queue, event));
    }

    private static native int CLBlastZhadNative(long var0, double[] var2, cl_mem var3, long var4, long var6, cl_mem var8, long var9, long var11, double[] var13, cl_mem var14, long var15, long var17, cl_command_queue var19, cl_event var20);

    public static int CLBlastSomatcopy(int layout, int a_transpose, long m, long n, float alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSomatcopyNative(layout, a_transpose, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, queue, event));
    }

    private static native int CLBlastSomatcopyNative(int var0, int var1, long var2, long var4, float var6, cl_mem var7, long var8, long var10, cl_mem var12, long var13, long var15, cl_command_queue var17, cl_event var18);

    public static int CLBlastDomatcopy(int layout, int a_transpose, long m, long n, double alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDomatcopyNative(layout, a_transpose, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, queue, event));
    }

    private static native int CLBlastDomatcopyNative(int var0, int var1, long var2, long var4, double var6, cl_mem var8, long var9, long var11, cl_mem var13, long var14, long var16, cl_command_queue var18, cl_event var19);

    public static int CLBlastComatcopy(int layout, int a_transpose, long m, long n, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastComatcopyNative(layout, a_transpose, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, queue, event));
    }

    private static native int CLBlastComatcopyNative(int var0, int var1, long var2, long var4, float[] var6, cl_mem var7, long var8, long var10, cl_mem var12, long var13, long var15, cl_command_queue var17, cl_event var18);

    public static int CLBlastZomatcopy(int layout, int a_transpose, long m, long n, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZomatcopyNative(layout, a_transpose, m, n, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, queue, event));
    }

    private static native int CLBlastZomatcopyNative(int var0, int var1, long var2, long var4, double[] var6, cl_mem var7, long var8, long var10, cl_mem var12, long var13, long var15, cl_command_queue var17, cl_event var18);

    public static int CLBlastSim2col(long channels, long height, long width, long kernel_h, long kernel_w, long pad_h, long pad_w, long stride_h, long stride_w, long dilation_h, long dilation_w, cl_mem im_buffer, long im_offset, cl_mem col_buffer, long col_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSim2colNative(channels, height, width, kernel_h, kernel_w, pad_h, pad_w, stride_h, stride_w, dilation_h, dilation_w, im_buffer, im_offset, col_buffer, col_offset, queue, event));
    }

    private static native int CLBlastSim2colNative(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, cl_mem var22, long var23, cl_mem var25, long var26, cl_command_queue var28, cl_event var29);

    public static int CLBlastDim2col(long channels, long height, long width, long kernel_h, long kernel_w, long pad_h, long pad_w, long stride_h, long stride_w, long dilation_h, long dilation_w, cl_mem im_buffer, long im_offset, cl_mem col_buffer, long col_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDim2colNative(channels, height, width, kernel_h, kernel_w, pad_h, pad_w, stride_h, stride_w, dilation_h, dilation_w, im_buffer, im_offset, col_buffer, col_offset, queue, event));
    }

    private static native int CLBlastDim2colNative(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, cl_mem var22, long var23, cl_mem var25, long var26, cl_command_queue var28, cl_event var29);

    public static int CLBlastCim2col(long channels, long height, long width, long kernel_h, long kernel_w, long pad_h, long pad_w, long stride_h, long stride_w, long dilation_h, long dilation_w, cl_mem im_buffer, long im_offset, cl_mem col_buffer, long col_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCim2colNative(channels, height, width, kernel_h, kernel_w, pad_h, pad_w, stride_h, stride_w, dilation_h, dilation_w, im_buffer, im_offset, col_buffer, col_offset, queue, event));
    }

    private static native int CLBlastCim2colNative(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, cl_mem var22, long var23, cl_mem var25, long var26, cl_command_queue var28, cl_event var29);

    public static int CLBlastZim2col(long channels, long height, long width, long kernel_h, long kernel_w, long pad_h, long pad_w, long stride_h, long stride_w, long dilation_h, long dilation_w, cl_mem im_buffer, long im_offset, cl_mem col_buffer, long col_offset, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZim2colNative(channels, height, width, kernel_h, kernel_w, pad_h, pad_w, stride_h, stride_w, dilation_h, dilation_w, im_buffer, im_offset, col_buffer, col_offset, queue, event));
    }

    private static native int CLBlastZim2colNative(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, cl_mem var22, long var23, cl_mem var25, long var26, cl_command_queue var28, cl_event var29);

    public static int CLBlastSaxpyBatched(long n, float[] alphas, cl_mem x_buffer, long[] x_offsets, long x_inc, cl_mem y_buffer, long[] y_offsets, long y_inc, long batch_count, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSaxpyBatchedNative(n, alphas, x_buffer, x_offsets, x_inc, y_buffer, y_offsets, y_inc, batch_count, queue, event));
    }

    private static native int CLBlastSaxpyBatchedNative(long var0, float[] var2, cl_mem var3, long[] var4, long var5, cl_mem var7, long[] var8, long var9, long var11, cl_command_queue var13, cl_event var14);

    public static int CLBlastDaxpyBatched(long n, double[] alphas, cl_mem x_buffer, long[] x_offsets, long x_inc, cl_mem y_buffer, long[] y_offsets, long y_inc, long batch_count, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDaxpyBatchedNative(n, alphas, x_buffer, x_offsets, x_inc, y_buffer, y_offsets, y_inc, batch_count, queue, event));
    }

    private static native int CLBlastDaxpyBatchedNative(long var0, double[] var2, cl_mem var3, long[] var4, long var5, cl_mem var7, long[] var8, long var9, long var11, cl_command_queue var13, cl_event var14);

    public static int CLBlastCaxpyBatched(long n, float[] alphas, cl_mem x_buffer, long[] x_offsets, long x_inc, cl_mem y_buffer, long[] y_offsets, long y_inc, long batch_count, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCaxpyBatchedNative(n, alphas, x_buffer, x_offsets, x_inc, y_buffer, y_offsets, y_inc, batch_count, queue, event));
    }

    private static native int CLBlastCaxpyBatchedNative(long var0, float[] var2, cl_mem var3, long[] var4, long var5, cl_mem var7, long[] var8, long var9, long var11, cl_command_queue var13, cl_event var14);

    public static int CLBlastZaxpyBatched(long n, double[] alphas, cl_mem x_buffer, long[] x_offsets, long x_inc, cl_mem y_buffer, long[] y_offsets, long y_inc, long batch_count, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZaxpyBatchedNative(n, alphas, x_buffer, x_offsets, x_inc, y_buffer, y_offsets, y_inc, batch_count, queue, event));
    }

    private static native int CLBlastZaxpyBatchedNative(long var0, double[] var2, cl_mem var3, long[] var4, long var5, cl_mem var7, long[] var8, long var9, long var11, cl_command_queue var13, cl_event var14);

    public static int CLBlastSgemmBatched(int layout, int a_transpose, int b_transpose, long m, long n, long k, float[] alphas, cl_mem a_buffer, long[] a_offsets, long a_ld, cl_mem b_buffer, long[] b_offsets, long b_ld, float[] betas, cl_mem c_buffer, long[] c_offsets, long c_ld, long batch_count, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSgemmBatchedNative(layout, a_transpose, b_transpose, m, n, k, alphas, a_buffer, a_offsets, a_ld, b_buffer, b_offsets, b_ld, betas, c_buffer, c_offsets, c_ld, batch_count, queue, event));
    }

    private static native int CLBlastSgemmBatchedNative(int var0, int var1, int var2, long var3, long var5, long var7, float[] var9, cl_mem var10, long[] var11, long var12, cl_mem var14, long[] var15, long var16, float[] var18, cl_mem var19, long[] var20, long var21, long var23, cl_command_queue var25, cl_event var26);

    public static int CLBlastDgemmBatched(int layout, int a_transpose, int b_transpose, long m, long n, long k, double[] alphas, cl_mem a_buffer, long[] a_offsets, long a_ld, cl_mem b_buffer, long[] b_offsets, long b_ld, double[] betas, cl_mem c_buffer, long[] c_offsets, long c_ld, long batch_count, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDgemmBatchedNative(layout, a_transpose, b_transpose, m, n, k, alphas, a_buffer, a_offsets, a_ld, b_buffer, b_offsets, b_ld, betas, c_buffer, c_offsets, c_ld, batch_count, queue, event));
    }

    private static native int CLBlastDgemmBatchedNative(int var0, int var1, int var2, long var3, long var5, long var7, double[] var9, cl_mem var10, long[] var11, long var12, cl_mem var14, long[] var15, long var16, double[] var18, cl_mem var19, long[] var20, long var21, long var23, cl_command_queue var25, cl_event var26);

    public static int CLBlastCgemmBatched(int layout, int a_transpose, int b_transpose, long m, long n, long k, float[] alphas, cl_mem a_buffer, long[] a_offsets, long a_ld, cl_mem b_buffer, long[] b_offsets, long b_ld, float[] betas, cl_mem c_buffer, long[] c_offsets, long c_ld, long batch_count, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCgemmBatchedNative(layout, a_transpose, b_transpose, m, n, k, alphas, a_buffer, a_offsets, a_ld, b_buffer, b_offsets, b_ld, betas, c_buffer, c_offsets, c_ld, batch_count, queue, event));
    }

    private static native int CLBlastCgemmBatchedNative(int var0, int var1, int var2, long var3, long var5, long var7, float[] var9, cl_mem var10, long[] var11, long var12, cl_mem var14, long[] var15, long var16, float[] var18, cl_mem var19, long[] var20, long var21, long var23, cl_command_queue var25, cl_event var26);

    public static int CLBlastZgemmBatched(int layout, int a_transpose, int b_transpose, long m, long n, long k, double[] alphas, cl_mem a_buffer, long[] a_offsets, long a_ld, cl_mem b_buffer, long[] b_offsets, long b_ld, double[] betas, cl_mem c_buffer, long[] c_offsets, long c_ld, long batch_count, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZgemmBatchedNative(layout, a_transpose, b_transpose, m, n, k, alphas, a_buffer, a_offsets, a_ld, b_buffer, b_offsets, b_ld, betas, c_buffer, c_offsets, c_ld, batch_count, queue, event));
    }

    private static native int CLBlastZgemmBatchedNative(int var0, int var1, int var2, long var3, long var5, long var7, double[] var9, cl_mem var10, long[] var11, long var12, cl_mem var14, long[] var15, long var16, double[] var18, cl_mem var19, long[] var20, long var21, long var23, cl_command_queue var25, cl_event var26);

    public static int CLBlastSgemmStridedBatched(int layout, int a_transpose, int b_transpose, long m, long n, long k, float alpha, cl_mem a_buffer, long a_offset, long a_ld, long a_stride, cl_mem b_buffer, long b_offset, long b_ld, long b_stride, float beta, cl_mem c_buffer, long c_offset, long c_ld, long c_stride, long batch_count, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastSgemmStridedBatchedNative(layout, a_transpose, b_transpose, m, n, k, alpha, a_buffer, a_offset, a_ld, a_stride, b_buffer, b_offset, b_ld, b_stride, beta, c_buffer, c_offset, c_ld, c_stride, batch_count, queue, event));
    }

    private static native int CLBlastSgemmStridedBatchedNative(int var0, int var1, int var2, long var3, long var5, long var7, float var9, cl_mem var10, long var11, long var13, long var15, cl_mem var17, long var18, long var20, long var22, float var24, cl_mem var25, long var26, long var28, long var30, long var32, cl_command_queue var34, cl_event var35);

    public static int CLBlastDgemmStridedBatched(int layout, int a_transpose, int b_transpose, long m, long n, long k, double alpha, cl_mem a_buffer, long a_offset, long a_ld, long a_stride, cl_mem b_buffer, long b_offset, long b_ld, long b_stride, double beta, cl_mem c_buffer, long c_offset, long c_ld, long c_stride, long batch_count, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastDgemmStridedBatchedNative(layout, a_transpose, b_transpose, m, n, k, alpha, a_buffer, a_offset, a_ld, a_stride, b_buffer, b_offset, b_ld, b_stride, beta, c_buffer, c_offset, c_ld, c_stride, batch_count, queue, event));
    }

    private static native int CLBlastDgemmStridedBatchedNative(int var0, int var1, int var2, long var3, long var5, long var7, double var9, cl_mem var11, long var12, long var14, long var16, cl_mem var18, long var19, long var21, long var23, double var25, cl_mem var27, long var28, long var30, long var32, long var34, cl_command_queue var36, cl_event var37);

    public static int CLBlastCgemmStridedBatched(int layout, int a_transpose, int b_transpose, long m, long n, long k, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, long a_stride, cl_mem b_buffer, long b_offset, long b_ld, long b_stride, float[] beta, cl_mem c_buffer, long c_offset, long c_ld, long c_stride, long batch_count, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastCgemmStridedBatchedNative(layout, a_transpose, b_transpose, m, n, k, alpha, a_buffer, a_offset, a_ld, a_stride, b_buffer, b_offset, b_ld, b_stride, beta, c_buffer, c_offset, c_ld, c_stride, batch_count, queue, event));
    }

    private static native int CLBlastCgemmStridedBatchedNative(int var0, int var1, int var2, long var3, long var5, long var7, float[] var9, cl_mem var10, long var11, long var13, long var15, cl_mem var17, long var18, long var20, long var22, float[] var24, cl_mem var25, long var26, long var28, long var30, long var32, cl_command_queue var34, cl_event var35);

    public static int CLBlastZgemmStridedBatched(int layout, int a_transpose, int b_transpose, long m, long n, long k, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, long a_stride, cl_mem b_buffer, long b_offset, long b_ld, long b_stride, double[] beta, cl_mem c_buffer, long c_offset, long c_ld, long c_stride, long batch_count, cl_command_queue queue, cl_event event) {
        return CLBlast.checkResult(CLBlast.CLBlastZgemmStridedBatchedNative(layout, a_transpose, b_transpose, m, n, k, alpha, a_buffer, a_offset, a_ld, a_stride, b_buffer, b_offset, b_ld, b_stride, beta, c_buffer, c_offset, c_ld, c_stride, batch_count, queue, event));
    }

    private static native int CLBlastZgemmStridedBatchedNative(int var0, int var1, int var2, long var3, long var5, long var7, double[] var9, cl_mem var10, long var11, long var13, long var15, cl_mem var17, long var18, long var20, long var22, double[] var24, cl_mem var25, long var26, long var28, long var30, long var32, cl_command_queue var34, cl_event var35);

    public static int CLBlastSgemmWithTempBuffer(int layout, int a_transpose, int b_transpose, long m, long n, long k, float alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, float beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event, cl_mem temp_buffer) {
        return CLBlast.checkResult(CLBlast.CLBlastSgemmWithTempBufferNative(layout, a_transpose, b_transpose, m, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event, temp_buffer));
    }

    private static native int CLBlastSgemmWithTempBufferNative(int var0, int var1, int var2, long var3, long var5, long var7, float var9, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, float var20, cl_mem var21, long var22, long var24, cl_command_queue var26, cl_event var27, cl_mem var28);

    public static int CLBlastDgemmWithTempBuffer(int layout, int a_transpose, int b_transpose, long m, long n, long k, double alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, double beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event, cl_mem temp_buffer) {
        return CLBlast.checkResult(CLBlast.CLBlastDgemmWithTempBufferNative(layout, a_transpose, b_transpose, m, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event, temp_buffer));
    }

    private static native int CLBlastDgemmWithTempBufferNative(int var0, int var1, int var2, long var3, long var5, long var7, double var9, cl_mem var11, long var12, long var14, cl_mem var16, long var17, long var19, double var21, cl_mem var23, long var24, long var26, cl_command_queue var28, cl_event var29, cl_mem var30);

    public static int CLBlastCgemmWithTempBuffer(int layout, int a_transpose, int b_transpose, long m, long n, long k, float[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, float[] beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event, cl_mem temp_buffer) {
        return CLBlast.checkResult(CLBlast.CLBlastCgemmWithTempBufferNative(layout, a_transpose, b_transpose, m, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event, temp_buffer));
    }

    private static native int CLBlastCgemmWithTempBufferNative(int var0, int var1, int var2, long var3, long var5, long var7, float[] var9, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, float[] var20, cl_mem var21, long var22, long var24, cl_command_queue var26, cl_event var27, cl_mem var28);

    public static int CLBlastZgemmWithTempBuffer(int layout, int a_transpose, int b_transpose, long m, long n, long k, double[] alpha, cl_mem a_buffer, long a_offset, long a_ld, cl_mem b_buffer, long b_offset, long b_ld, double[] beta, cl_mem c_buffer, long c_offset, long c_ld, cl_command_queue queue, cl_event event, cl_mem temp_buffer) {
        return CLBlast.checkResult(CLBlast.CLBlastZgemmWithTempBufferNative(layout, a_transpose, b_transpose, m, n, k, alpha, a_buffer, a_offset, a_ld, b_buffer, b_offset, b_ld, beta, c_buffer, c_offset, c_ld, queue, event, temp_buffer));
    }

    private static native int CLBlastZgemmWithTempBufferNative(int var0, int var1, int var2, long var3, long var5, long var7, double[] var9, cl_mem var10, long var11, long var13, cl_mem var15, long var16, long var18, double[] var20, cl_mem var21, long var22, long var24, cl_command_queue var26, cl_event var27, cl_mem var28);

    public static int CLBlastSGemmTempBufferSize(int layout, int a_transpose, int b_transpose, long m, long n, long k, long a_offset, long a_ld, long b_offset, long b_ld, long c_offset, long c_ld, cl_command_queue queue, long[] temp_buffer_size) {
        return CLBlast.checkResult(CLBlast.CLBlastSGemmTempBufferSizeNative(layout, a_transpose, b_transpose, m, n, k, a_offset, a_ld, b_offset, b_ld, c_offset, c_ld, queue, temp_buffer_size));
    }

    private static native int CLBlastSGemmTempBufferSizeNative(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15, long var17, long var19, cl_command_queue var21, long[] var22);

    public static int CLBlastDGemmTempBufferSize(int layout, int a_transpose, int b_transpose, long m, long n, long k, long a_offset, long a_ld, long b_offset, long b_ld, long c_offset, long c_ld, cl_command_queue queue, long[] temp_buffer_size) {
        return CLBlast.checkResult(CLBlast.CLBlastDGemmTempBufferSizeNative(layout, a_transpose, b_transpose, m, n, k, a_offset, a_ld, b_offset, b_ld, c_offset, c_ld, queue, temp_buffer_size));
    }

    private static native int CLBlastDGemmTempBufferSizeNative(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15, long var17, long var19, cl_command_queue var21, long[] var22);

    public static int CLBlastCGemmTempBufferSize(int layout, int a_transpose, int b_transpose, long m, long n, long k, long a_offset, long a_ld, long b_offset, long b_ld, long c_offset, long c_ld, cl_command_queue queue, long[] temp_buffer_size) {
        return CLBlast.checkResult(CLBlast.CLBlastCGemmTempBufferSizeNative(layout, a_transpose, b_transpose, m, n, k, a_offset, a_ld, b_offset, b_ld, c_offset, c_ld, queue, temp_buffer_size));
    }

    private static native int CLBlastCGemmTempBufferSizeNative(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15, long var17, long var19, cl_command_queue var21, long[] var22);

    public static int CLBlastZGemmTempBufferSize(int layout, int a_transpose, int b_transpose, long m, long n, long k, long a_offset, long a_ld, long b_offset, long b_ld, long c_offset, long c_ld, cl_command_queue queue, long[] temp_buffer_size) {
        return CLBlast.checkResult(CLBlast.CLBlastZGemmTempBufferSizeNative(layout, a_transpose, b_transpose, m, n, k, a_offset, a_ld, b_offset, b_ld, c_offset, c_ld, queue, temp_buffer_size));
    }

    private static native int CLBlastZGemmTempBufferSizeNative(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11, long var13, long var15, long var17, long var19, cl_command_queue var21, long[] var22);

    public static int CLBlastClearCache() {
        return CLBlast.checkResult(CLBlast.CLBlastClearCacheNative());
    }

    private static native int CLBlastClearCacheNative();

    public static int CLBlastFillCache(cl_device_id device) {
        return CLBlast.checkResult(CLBlast.CLBlastFillCacheNative(device));
    }

    private static native int CLBlastFillCacheNative(cl_device_id var0);

    public static int CLBlastOverrideParameters(cl_device_id device, String kernel_name, int precision, long num_parameters, String[] parameters_names, long[] parameters_values) {
        return CLBlast.checkResult(CLBlast.CLBlastOverrideParametersNative(device, kernel_name, precision, num_parameters, parameters_names, parameters_values));
    }

    private static native int CLBlastOverrideParametersNative(cl_device_id var0, String var1, int var2, long var3, String[] var5, long[] var6);

    private CLBlast() {
    }

    static {
        String versionString = "1_4_1";
        String libraryBaseName = "JOCLBlast_" + versionString;
        String libraryName = LibUtils.createPlatformLibraryName(libraryBaseName);
        String[] dependentLibraryNames = new String[]{"clblast"};
        LibUtils.loadLibrary(libraryName, dependentLibraryNames);
        exceptionsEnabled = false;
    }
}

