/*
 * Decompiled with CFR 0.152.
 */
package org.jocl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.jocl.NativePointerObject;

public final class Pointer
extends NativePointerObject {
    private static final String BUFFER_MAY_NOT_BE_NULL = "The buffer may not be null";
    private static final String BUFFER_MUST_HAVE_ARRAY_OR_BE_DIRECT = "The buffer must have an array or be direct";

    public Pointer() {
    }

    protected Pointer(Buffer buffer) {
        super(buffer);
    }

    private Pointer(NativePointerObject[] pointers) {
        super(pointers);
    }

    protected Pointer(Pointer other) {
        super(other);
    }

    protected Pointer(Pointer other, long byteOffset) {
        super(other, byteOffset);
    }

    public static Pointer to(byte[] values) {
        return new Pointer(ByteBuffer.wrap(values));
    }

    public static Pointer to(char[] values) {
        return new Pointer(CharBuffer.wrap(values));
    }

    public static Pointer to(short[] values) {
        return new Pointer(ShortBuffer.wrap(values));
    }

    public static Pointer to(int[] values) {
        return new Pointer(IntBuffer.wrap(values));
    }

    public static Pointer to(float[] values) {
        return new Pointer(FloatBuffer.wrap(values));
    }

    public static Pointer to(long[] values) {
        return new Pointer(LongBuffer.wrap(values));
    }

    public static Pointer to(double[] values) {
        return new Pointer(DoubleBuffer.wrap(values));
    }

    public static Pointer to(Buffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(BUFFER_MAY_NOT_BE_NULL);
        }
        if (!buffer.isDirect() && !buffer.hasArray()) {
            throw new IllegalArgumentException(BUFFER_MUST_HAVE_ARRAY_OR_BE_DIRECT);
        }
        return new Pointer(buffer);
    }

    public static Pointer toBuffer(Buffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(BUFFER_MAY_NOT_BE_NULL);
        }
        if (buffer instanceof ByteBuffer) {
            return Pointer.computePointer((ByteBuffer)buffer);
        }
        if (buffer instanceof ShortBuffer) {
            return Pointer.computePointer((ShortBuffer)buffer);
        }
        if (buffer instanceof IntBuffer) {
            return Pointer.computePointer((IntBuffer)buffer);
        }
        if (buffer instanceof LongBuffer) {
            return Pointer.computePointer((LongBuffer)buffer);
        }
        if (buffer instanceof FloatBuffer) {
            return Pointer.computePointer((FloatBuffer)buffer);
        }
        if (buffer instanceof DoubleBuffer) {
            return Pointer.computePointer((DoubleBuffer)buffer);
        }
        throw new IllegalArgumentException("Unknown buffer type: " + buffer);
    }

    private static Pointer computePointer(ByteBuffer buffer) {
        Pointer result;
        if (buffer.isDirect()) {
            int oldPosition = buffer.position();
            buffer.position(0);
            result = Pointer.to(buffer.slice()).withByteOffset(oldPosition * 1);
            buffer.position(oldPosition);
        } else if (buffer.hasArray()) {
            ByteBuffer t = ByteBuffer.wrap(buffer.array());
            int elementOffset = buffer.position() + buffer.arrayOffset();
            result = Pointer.to(t).withByteOffset(elementOffset * 1);
        } else {
            throw new IllegalArgumentException(BUFFER_MUST_HAVE_ARRAY_OR_BE_DIRECT);
        }
        return result;
    }

    private static Pointer computePointer(ShortBuffer buffer) {
        Pointer result;
        if (buffer.isDirect()) {
            int oldPosition = buffer.position();
            buffer.position(0);
            result = Pointer.to(buffer.slice()).withByteOffset(oldPosition * 2);
            buffer.position(oldPosition);
        } else if (buffer.hasArray()) {
            ShortBuffer t = ShortBuffer.wrap(buffer.array());
            int elementOffset = buffer.position() + buffer.arrayOffset();
            result = Pointer.to(t).withByteOffset(elementOffset * 2);
        } else {
            throw new IllegalArgumentException(BUFFER_MUST_HAVE_ARRAY_OR_BE_DIRECT);
        }
        return result;
    }

    private static Pointer computePointer(IntBuffer buffer) {
        Pointer result;
        if (buffer.isDirect()) {
            int oldPosition = buffer.position();
            buffer.position(0);
            result = Pointer.to(buffer.slice()).withByteOffset(oldPosition * 4);
            buffer.position(oldPosition);
        } else if (buffer.hasArray()) {
            IntBuffer t = IntBuffer.wrap(buffer.array());
            int elementOffset = buffer.position() + buffer.arrayOffset();
            result = Pointer.to(t).withByteOffset(elementOffset * 4);
        } else {
            throw new IllegalArgumentException(BUFFER_MUST_HAVE_ARRAY_OR_BE_DIRECT);
        }
        return result;
    }

    private static Pointer computePointer(LongBuffer buffer) {
        Pointer result;
        if (buffer.isDirect()) {
            int oldPosition = buffer.position();
            buffer.position(0);
            result = Pointer.to(buffer.slice()).withByteOffset(oldPosition * 8);
            buffer.position(oldPosition);
        } else if (buffer.hasArray()) {
            LongBuffer t = LongBuffer.wrap(buffer.array());
            int elementOffset = buffer.position() + buffer.arrayOffset();
            result = Pointer.to(t).withByteOffset(elementOffset * 8);
        } else {
            throw new IllegalArgumentException(BUFFER_MUST_HAVE_ARRAY_OR_BE_DIRECT);
        }
        return result;
    }

    private static Pointer computePointer(FloatBuffer buffer) {
        Pointer result;
        if (buffer.isDirect()) {
            int oldPosition = buffer.position();
            buffer.position(0);
            result = Pointer.to(buffer.slice()).withByteOffset(oldPosition * 4);
            buffer.position(oldPosition);
        } else if (buffer.hasArray()) {
            FloatBuffer t = FloatBuffer.wrap(buffer.array());
            int elementOffset = buffer.position() + buffer.arrayOffset();
            result = Pointer.to(t).withByteOffset(elementOffset * 4);
        } else {
            throw new IllegalArgumentException(BUFFER_MUST_HAVE_ARRAY_OR_BE_DIRECT);
        }
        return result;
    }

    private static Pointer computePointer(DoubleBuffer buffer) {
        Pointer result;
        if (buffer.isDirect()) {
            int oldPosition = buffer.position();
            buffer.position(0);
            result = Pointer.to(buffer.slice()).withByteOffset(oldPosition * 8);
            buffer.position(oldPosition);
        } else if (buffer.hasArray()) {
            DoubleBuffer t = DoubleBuffer.wrap(buffer.array());
            int elementOffset = buffer.position() + buffer.arrayOffset();
            result = Pointer.to(t).withByteOffset(elementOffset * 8);
        } else {
            throw new IllegalArgumentException(BUFFER_MUST_HAVE_ARRAY_OR_BE_DIRECT);
        }
        return result;
    }

    public static Pointer to(NativePointerObject pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException("Pointer may not point to null objects");
        }
        return new Pointer(new NativePointerObject[]{pointer});
    }

    public static Pointer to(NativePointerObject ... pointers) {
        if (pointers == null) {
            throw new IllegalArgumentException("Pointer may not point to null objects");
        }
        return new Pointer(pointers);
    }

    boolean isDirectBufferPointer() {
        return this.getBuffer() != null && this.getBuffer().isDirect();
    }

    @Override
    public Pointer withByteOffset(long byteOffset) {
        return new Pointer(this, byteOffset);
    }

    public ByteBuffer getByteBuffer(long byteOffset, long byteSize) {
        Buffer buffer = this.getBuffer();
        if (buffer == null) {
            return null;
        }
        if (!(buffer instanceof ByteBuffer)) {
            return null;
        }
        ByteBuffer byteBuffer = (ByteBuffer)buffer;
        byteBuffer.limit((int)(byteOffset + byteSize));
        byteBuffer.position((int)byteOffset);
        return byteBuffer.slice();
    }
}

