/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils.cache.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.cache.MemberCacheView;
import net.dv8tion.jda.core.utils.cache.impl.AbstractCacheView;

public class MemberCacheViewImpl
extends AbstractCacheView<Member>
implements MemberCacheView {
    public MemberCacheViewImpl() {
        super(Member::getEffectiveName);
    }

    @Override
    public Member getElementById(long id) {
        return (Member)this.elements.get(id);
    }

    @Override
    public List<Member> getElementsByUsername(String name, boolean ignoreCase) {
        Checks.notEmpty(name, "Name");
        LinkedList<Member> members = new LinkedList<Member>();
        for (Member member : this.elements.valueCollection()) {
            String nick = member.getUser().getName();
            if (ignoreCase) {
                if (!nick.equalsIgnoreCase(name)) continue;
                members.add(member);
                continue;
            }
            if (!nick.equals(name)) continue;
            members.add(member);
        }
        return Collections.unmodifiableList(members);
    }

    @Override
    public List<Member> getElementsByNickname(String name, boolean ignoreCase) {
        LinkedList<Member> members = new LinkedList<Member>();
        for (Member member : this.elements.valueCollection()) {
            String nick = member.getNickname();
            if (nick == null) {
                if (name != null) continue;
                members.add(member);
                continue;
            }
            if (ignoreCase) {
                if (!nick.equalsIgnoreCase(name)) continue;
                members.add(member);
                continue;
            }
            if (!nick.equals(name)) continue;
            members.add(member);
        }
        return Collections.unmodifiableList(members);
    }

    @Override
    public List<Member> getElementsByName(String name, boolean ignoreCase) {
        Checks.notEmpty(name, "Name");
        LinkedList<Member> members = new LinkedList<Member>();
        for (Member member : this.elements.valueCollection()) {
            String nick = member.getEffectiveName();
            if (ignoreCase) {
                if (!nick.equalsIgnoreCase(name)) continue;
                members.add(member);
                continue;
            }
            if (!nick.equals(name)) continue;
            members.add(member);
        }
        return Collections.unmodifiableList(members);
    }

    @Override
    public List<Member> getElementsWithRoles(Role ... roles) {
        Checks.notNull(roles, "Roles");
        for (Role role : roles) {
            Checks.notNull(role, "Roles");
        }
        LinkedList<Member> members = new LinkedList<Member>();
        block1: for (Member member : this.elements.valueCollection()) {
            for (Role role : roles) {
                if (!member.getRoles().contains(role)) continue block1;
            }
            members.add(member);
        }
        return members;
    }

    @Override
    public List<Member> getElementsWithRoles(Collection<Role> roles) {
        Checks.noneNull(roles, "Roles");
        LinkedList<Member> members = new LinkedList<Member>();
        for (Member member : this.elements.valueCollection()) {
            if (!member.getRoles().containsAll(roles)) continue;
            members.add(member);
        }
        return members;
    }
}

