/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction;

import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.RequestFuture;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.RestFuture;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.MiscUtil;
import okhttp3.RequestBody;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.json.JSONObject;

public abstract class AuditableRestAction<T>
extends RestAction<T> {
    protected String reason = null;

    public AuditableRestAction(JDA api, Route.CompiledRoute route) {
        super(api, route);
    }

    public AuditableRestAction(JDA api, Route.CompiledRoute route, RequestBody data) {
        super(api, route, data);
    }

    public AuditableRestAction(JDA api, Route.CompiledRoute route, JSONObject data) {
        super(api, route, data);
    }

    @CheckReturnValue
    public AuditableRestAction<T> reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    protected CaseInsensitiveMap<String, String> finalizeHeaders() {
        CaseInsensitiveMap<String, String> headers = super.finalizeHeaders();
        if (this.reason == null || this.reason.isEmpty()) {
            return headers;
        }
        if (headers == null) {
            headers = new CaseInsensitiveMap();
        }
        headers.put("X-Audit-Log-Reason", this.uriEncode(this.reason));
        return headers;
    }

    private String uriEncode(String input) {
        String formEncode = MiscUtil.encodeUTF8(input);
        return formEncode.replace('+', ' ');
    }

    public static class EmptyRestAction<T>
    extends AuditableRestAction<T> {
        protected final T content;

        public EmptyRestAction(JDA api) {
            this(api, null);
        }

        public EmptyRestAction(JDA api, T content) {
            super(api, null);
            this.content = content;
        }

        @Override
        public void queue(Consumer<T> success, Consumer<Throwable> failure) {
            if (success != null) {
                success.accept(this.content);
            }
        }

        @Override
        public RequestFuture<T> submit(boolean shouldQueue) {
            return new RestFuture<T>(this.content);
        }

        @Override
        protected void handleResponse(Response response, Request<T> request) {
        }
    }
}

