/*
 * Decompiled with CFR 0.152.
 */
package model;

import autodiff.Graph;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.List;
import matrix.Matrix;
import model.DenseLayer;

public class DebugLayer
implements DenseLayer {
    private boolean crash;
    private boolean forward;

    public DebugLayer(boolean crash, boolean forward) {
        this.crash = crash;
        this.forward = forward;
    }

    @Override
    public Matrix forward(final Matrix input, Graph g) throws Exception {
        if (this.forward) {
            System.out.println(input.toString());
            if (this.crash) {
                System.exit(1);
            }
        } else if (g.isApplyingBackprop()) {
            g.addBackprop(new Runnable(){

                @Override
                public void run() {
                    System.out.println(input.dwToString());
                    if (DebugLayer.this.crash) {
                        System.exit(1);
                    }
                }
            });
        }
        return input;
    }

    @Override
    public void resetState() {
    }

    @Override
    public List<Matrix> getParameters() {
        return null;
    }

    @Override
    public void saveState(DataOutputStream fos) throws Exception {
    }

    @Override
    public void loadState(DataInputStream fis) throws Exception {
    }

    @Override
    public DenseLayer clone() {
        return new DebugLayer(this.crash, this.forward);
    }
}

