/*
 * Decompiled with CFR 0.152.
 */
package model;

import autodiff.Graph;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.List;
import matrix.Matrix;
import matrix.Tensor;
import model.TensorLayer;

public class ConvDebug
implements TensorLayer {
    private boolean crash = false;
    private boolean forward;

    public ConvDebug(boolean crash, boolean forward) {
        this.crash = crash;
        this.forward = forward;
    }

    @Override
    public Tensor forward(final Tensor input, Graph g) throws Exception {
        if (this.forward) {
            int i = 0;
            while (i < input.depth) {
                System.out.println(String.valueOf(input.matrices[i].toString()) + "\n");
                ++i;
            }
            if (this.crash) {
                System.exit(0);
            }
        }
        if (g.isApplyingBackprop()) {
            g.addBackprop(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < input.depth) {
                        System.out.println(String.valueOf(input.matrices[i].dwToString()) + "\n");
                        ++i;
                    }
                    if (ConvDebug.this.crash) {
                        System.exit(0);
                    }
                }
            });
        }
        return input;
    }

    @Override
    public void resetState() {
    }

    @Override
    public List<Matrix> getParameters() {
        return null;
    }

    @Override
    public TensorLayer clone() {
        return new ConvDebug(this.crash, this.forward);
    }

    @Override
    public void saveState(DataOutputStream fos) throws Exception {
    }

    @Override
    public void loadState(DataInputStream fis) throws Exception {
    }
}

