/*
 * Decompiled with CFR 0.152.
 */
package loss;

import loss.Loss;
import matrix.Matrix;

public class LossHuber
implements Loss {
    private double delta;

    public LossHuber(double delta) {
        this.delta = delta;
    }

    @Override
    public void backward(Matrix actualOutput, Matrix targetOutput) throws Exception {
        int i = 0;
        while (i < targetOutput.w.length) {
            double errDelta = actualOutput.w[i] - targetOutput.w[i];
            double errDeltaAbs = Math.abs(errDelta);
            if (errDeltaAbs <= this.delta) {
                int n = i;
                actualOutput.dw[n] = actualOutput.dw[n] + errDelta;
            } else {
                int n = i;
                actualOutput.dw[n] = actualOutput.dw[n] + 0.0;
            }
            ++i;
        }
    }

    @Override
    public double measure(Matrix actualOutput, Matrix targetOutput) throws Exception {
        double sum = 0.0;
        int i = 0;
        while (i < targetOutput.w.length) {
            double errDelta = actualOutput.w[i] - targetOutput.w[i];
            double errDeltaAbs = Math.abs(errDelta);
            sum = errDeltaAbs <= this.delta ? (sum += 0.5 * errDelta * errDelta) : (sum += this.delta * (errDeltaAbs - 0.5 * this.delta));
            ++i;
        }
        return sum;
    }
}

