/*
 * Decompiled with CFR 0.152.
 */
package examples.deepRL;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import matrix.Matrix;

public class NeuralNetworkDisplay
extends JFrame {
    private boolean frozen = false;
    private boolean showGradients = false;

    public NeuralNetworkDisplay(int width, int height, int scale) {
        super("Layer 0, feature 0");
        this.getContentPane().setPreferredSize(new Dimension(scale * width, scale * height));
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.pack();
    }

    public void setTitle(int layer, int feature) {
        if (this.frozen) {
            return;
        }
        this.setTitle("Layer " + Integer.toString(layer) + ", output " + Integer.toString(feature));
    }

    public void setTitle(int layer, int ... features) {
        if (this.frozen) {
            return;
        }
        String s = "Layer " + Integer.toString(layer) + ", outputs ";
        int i = 0;
        while (i < features.length) {
            s = String.valueOf(s) + Integer.toString(features[i]) + (i == features.length - 1 ? "" : ",");
            ++i;
        }
        this.setTitle(s);
    }

    public void showFeature(Matrix m) {
        if (this.frozen) {
            return;
        }
        this.getContentPane().getGraphics().drawImage(this.matrixToImage(m), 0, 0, this.getContentPane().getWidth(), this.getContentPane().getHeight(), this);
    }

    public void showFeatures(Matrix ... ms) {
        if (this.frozen) {
            return;
        }
        if (ms.length == 3) {
            this.getContentPane().getGraphics().drawImage(this.matricesToImage(ms[0], ms[1], ms[2]), 0, 0, this.getContentPane().getWidth(), this.getContentPane().getHeight(), this);
        }
        if (ms.length == 2) {
            this.getContentPane().getGraphics().drawImage(this.matricesToImage(ms[0], ms[1], new Matrix(ms[0].rows, ms[0].cols)), 0, 0, this.getContentPane().getWidth(), this.getContentPane().getHeight(), this);
        }
        if (ms.length == 1) {
            this.showFeature(ms[0]);
        }
    }

    private BufferedImage matricesToImage(Matrix r, Matrix g, Matrix b) {
        BufferedImage result = new BufferedImage(r.cols, r.rows, 1);
        double largestr = -10000.0;
        double[] dArray = r.w;
        int n = r.w.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d > largestr) {
                largestr = d;
            }
            ++n2;
        }
        double largestg = -10000.0;
        double[] dArray2 = g.w;
        int n3 = g.w.length;
        int n4 = 0;
        while (n4 < n3) {
            double d = dArray2[n4];
            if (d > largestg) {
                largestg = d;
            }
            ++n4;
        }
        double largestb = -10000.0;
        double[] dArray3 = b.w;
        int n5 = b.w.length;
        int n6 = 0;
        while (n6 < n5) {
            double d = dArray3[n6];
            if (d > largestb) {
                largestb = d;
            }
            ++n6;
        }
        largestr = Math.max(0.1, largestr);
        largestg = Math.max(0.1, largestg);
        largestb = Math.max(0.1, largestb);
        int i = 0;
        while (i < r.cols) {
            int j = 0;
            while (j < r.rows) {
                int red = (int)(r.getW(j, i) / largestr * 255.0);
                int green = (int)(g.getW(j, i) / largestg * 255.0);
                int blue = (int)(b.getW(j, i) / largestb * 255.0);
                if (red > 255) {
                    red = 255;
                }
                if (red < 0) {
                    red = 0;
                }
                if (green > 255) {
                    green = 255;
                }
                if (green < 0) {
                    green = 0;
                }
                if (blue > 255) {
                    blue = 255;
                }
                if (blue < 0) {
                    blue = 0;
                }
                result.setRGB(i, j, new Color(red, green, blue).getRGB());
                ++j;
            }
            ++i;
        }
        return result;
    }

    private BufferedImage matrixToImage(Matrix m) {
        BufferedImage result = new BufferedImage(m.cols, m.rows, 1);
        double largest = -10000.0;
        double[] dArray = this.showGradients ? m.dw : m.w;
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d > largest) {
                largest = d;
            }
            ++n2;
        }
        largest = Math.max(0.1, largest);
        int i = 0;
        while (i < m.cols) {
            int j = 0;
            while (j < m.rows) {
                int color = (int)((this.showGradients ? m.getDW(j, i) : m.getW(j, i)) / largest * 255.0);
                if (color > 255) {
                    color = 255;
                }
                if (color < 0) {
                    color = 0;
                }
                result.setRGB(i, j, new Color(color, color, color).getRGB());
                ++j;
            }
            ++i;
        }
        return result;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public boolean isShowGradients() {
        return this.showGradients;
    }

    public void setShowGradients(boolean showGradients) {
        this.showGradients = showGradients;
    }
}

