/*
 * Decompiled with CFR 0.152.
 */
package examples;

import autodiff.GPUGraph;
import java.util.Random;
import matrix.Matrix;
import matrix.Tensor;
import nonlinearities.SigmoidUnit;
import util.CLUtils;
import util.NNDevice;

public class OpenCLTest {
    private static final String platform = "AMD";
    private static final String device = "Tahiti";

    public static void main(String[] args) {
        if (args.length != 0 && args[0].equalsIgnoreCase("true")) {
            NNDevice dev = CLUtils.findDevice(platform, device)[0];
            try {
                GPUGraph g = CLUtils.createGraph(dev, true);
                Matrix[] filters = new Matrix[256];
                int i = 0;
                while (i < filters.length) {
                    filters[i] = Matrix.rand(4, 4, 0.08, new Random());
                    ++i;
                }
                Matrix bias = Matrix.rand(256, 1, 0.08, new Random());
                g.fullConv(true, 1, 1, 16, Tensor.rand(32, 32, 16, 0.08, new Random()), bias, filters, new SigmoidUnit(), null);
                g.backward();
                g.cleanUp();
                System.out.println("Done.");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            try {
                CLUtils.printDevices();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

