/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.lassp.houle.RngPack;

import edu.cornell.lassp.houle.RngPack.RanMT;
import edu.cornell.lassp.houle.RngPack.RandomSeedable;
import java.util.Random;

public class BetterRandom
extends Random {
    private RandomSeedable rng;

    public BetterRandom(RandomSeedable rng) {
        this.rng = rng;
    }

    public BetterRandom() {
        this.rng = new RanMT();
    }

    public BetterRandom(long seed) {
        this.rng = new RanMT(seed);
    }

    @Override
    public synchronized void setSeed(long seed) {
        if (this.rng != null) {
            this.rng.setSeed(seed);
        }
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)this.rng.choose(-128, 127);
            ++i;
        }
    }

    @Override
    public int nextInt(int bound) {
        return this.rng.choose(bound + 1) - 1;
    }

    @Override
    public int nextInt() {
        return (int)Math.round(this.rng.choose(-2.147483648E9, 2.147483647E9));
    }

    @Override
    public long nextLong() {
        return Math.round(this.rng.choose(-9.223372036854776E18, 9.223372036854776E18));
    }

    @Override
    public boolean nextBoolean() {
        return this.rng.coin();
    }

    @Override
    public float nextFloat() {
        return (float)this.rng.raw();
    }

    @Override
    public double nextDouble() {
        return this.rng.raw();
    }

    @Override
    public synchronized double nextGaussian() {
        return this.rng.gaussian(1.0);
    }
}

