/*
 * Decompiled with CFR 0.152.
 */
package com.leff.midi.event.meta;

import com.leff.midi.event.MidiEvent;
import com.leff.midi.event.meta.GenericMetaEvent;
import com.leff.midi.event.meta.MetaEvent;
import com.leff.midi.util.MidiUtil;
import com.leff.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.OutputStream;

public class Tempo
extends MetaEvent {
    public static final float DEFAULT_BPM = 120.0f;
    public static final int DEFAULT_MPQN = 500000;
    private int mMPQN;
    private float mBPM;

    public Tempo() {
        this(0L, 0L, 500000);
    }

    @Override
    public MidiEvent clone() {
        Tempo t = new Tempo(this.mTick, this.mDelta.getValue(), this.mMPQN);
        t.setBpm(this.mBPM);
        return t;
    }

    public Tempo(long tick, long delta, int mpqn) {
        super(tick, delta, 81, new VariableLengthInt(3));
        this.setMpqn(mpqn);
    }

    public int getMpqn() {
        return this.mMPQN;
    }

    public float getBpm() {
        return this.mBPM;
    }

    public void setMpqn(int m) {
        this.mMPQN = m;
        this.mBPM = 6.0E7f / (float)this.mMPQN;
    }

    public void setBpm(float b) {
        this.mBPM = b;
        this.mMPQN = (int)(6.0E7f / this.mBPM);
    }

    @Override
    protected int getEventSize() {
        return 6;
    }

    @Override
    public void writeToFile(OutputStream out) throws IOException {
        super.writeToFile(out);
        out.write(3);
        out.write(MidiUtil.intToBytes(this.mMPQN, 3));
    }

    public static MetaEvent parseTempo(long tick, long delta, MetaEvent.MetaEventData info) {
        if (info.length.getValue() != 3) {
            return new GenericMetaEvent(tick, delta, info);
        }
        int mpqn = MidiUtil.bytesToInt(info.data, 0, 3);
        return new Tempo(tick, delta, mpqn);
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick != other.getTick()) {
            return this.mTick < other.getTick() ? -1 : 1;
        }
        if ((long)this.mDelta.getValue() != other.getDelta()) {
            return (long)this.mDelta.getValue() < other.getDelta() ? 1 : -1;
        }
        if (!(other instanceof Tempo)) {
            return 1;
        }
        Tempo o = (Tempo)other;
        if (this.mMPQN != o.mMPQN) {
            return this.mMPQN < o.mMPQN ? -1 : 1;
        }
        return 0;
    }
}

