/*
 * Decompiled with CFR 0.152.
 */
package com.leff.midi.event.meta;

import com.leff.midi.event.MidiEvent;
import com.leff.midi.event.meta.MetaEvent;
import com.leff.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.OutputStream;

public class EndOfTrack
extends MetaEvent {
    public EndOfTrack(long tick, long delta) {
        super(tick, delta, 47, new VariableLengthInt(0));
    }

    @Override
    public MidiEvent clone() {
        return new EndOfTrack(this.mTick, this.mDelta.getValue());
    }

    @Override
    protected int getEventSize() {
        return 3;
    }

    @Override
    public void writeToFile(OutputStream out) throws IOException {
        super.writeToFile(out);
        out.write(0);
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick != other.getTick()) {
            return this.mTick < other.getTick() ? -1 : 1;
        }
        if ((long)this.mDelta.getValue() != other.getDelta()) {
            return (long)this.mDelta.getValue() < other.getDelta() ? 1 : -1;
        }
        if (!(other instanceof EndOfTrack)) {
            return 1;
        }
        return 0;
    }
}

