/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.Random;
import model.FeedForwardLayer;
import model.GruLayer;
import model.LinearLayer;
import model.LstmLayer;
import model.Model;
import model.NeuralNetwork;
import model.RnnLayer;
import nonlinearities.Nonlinearity;

public class NeuralNetworkHelper {
    public static NeuralNetwork makeLstm(int inputDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        ArrayList<Model> layers = new ArrayList<Model>();
        int h = 0;
        while (h < hiddenLayers) {
            if (h == 0) {
                layers.add(new LstmLayer(inputDimension, hiddenDimension, initParamsStdDev, rng));
            } else {
                layers.add(new LstmLayer(hiddenDimension, hiddenDimension, initParamsStdDev, rng));
            }
            ++h;
        }
        layers.add(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return new NeuralNetwork(layers);
    }

    public static NeuralNetwork makeLstmWithInputBottleneck(int inputDimension, int bottleneckDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        ArrayList<Model> layers = new ArrayList<Model>();
        layers.add(new LinearLayer(inputDimension, bottleneckDimension, initParamsStdDev, rng));
        int h = 0;
        while (h < hiddenLayers) {
            if (h == 0) {
                layers.add(new LstmLayer(bottleneckDimension, hiddenDimension, initParamsStdDev, rng));
            } else {
                layers.add(new LstmLayer(hiddenDimension, hiddenDimension, initParamsStdDev, rng));
            }
            ++h;
        }
        layers.add(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return new NeuralNetwork(layers);
    }

    public static NeuralNetwork makeLstmWithMultiLayerInputBottleneck(int inputDimension, int[] bottleneckDimensions, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        ArrayList<Model> layers = new ArrayList<Model>();
        int i = 0;
        while (i < bottleneckDimensions.length) {
            layers.add(new LinearLayer(i == 0 ? inputDimension : bottleneckDimensions[i - 1], bottleneckDimensions[i], initParamsStdDev, rng));
            ++i;
        }
        int h = 0;
        while (h < hiddenLayers) {
            if (h == 0) {
                layers.add(new LstmLayer(bottleneckDimensions[bottleneckDimensions.length - 1], hiddenDimension, initParamsStdDev, rng));
            } else {
                layers.add(new LstmLayer(hiddenDimension, hiddenDimension, initParamsStdDev, rng));
            }
            ++h;
        }
        layers.add(new LinearLayer(hiddenDimension, hiddenDimension / 3, initParamsStdDev, rng));
        layers.add(new FeedForwardLayer(hiddenDimension / 3, outputDimension, decoderUnit, initParamsStdDev, rng));
        return new NeuralNetwork(layers);
    }

    public static NeuralNetwork makeFeedForward(int inputDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity hiddenUnit, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        ArrayList<Model> layers = new ArrayList<Model>();
        if (hiddenLayers == 0) {
            layers.add(new FeedForwardLayer(inputDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
            return new NeuralNetwork(layers);
        }
        int h = 0;
        while (h < hiddenLayers) {
            if (h == 0) {
                layers.add(new FeedForwardLayer(inputDimension, hiddenDimension, hiddenUnit, initParamsStdDev, rng));
            } else {
                layers.add(new FeedForwardLayer(hiddenDimension, hiddenDimension, hiddenUnit, initParamsStdDev, rng));
            }
            ++h;
        }
        layers.add(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return new NeuralNetwork(layers);
    }

    public static NeuralNetwork makeGru(int inputDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        ArrayList<Model> layers = new ArrayList<Model>();
        int h = 0;
        while (h < hiddenLayers) {
            if (h == 0) {
                layers.add(new GruLayer(inputDimension, hiddenDimension, initParamsStdDev, rng));
            } else {
                layers.add(new GruLayer(hiddenDimension, hiddenDimension, initParamsStdDev, rng));
            }
            ++h;
        }
        layers.add(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return new NeuralNetwork(layers);
    }

    public static NeuralNetwork makeRnn(int inputDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity hiddenUnit, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        ArrayList<Model> layers = new ArrayList<Model>();
        int h = 0;
        while (h < hiddenLayers) {
            if (h == 0) {
                layers.add(new RnnLayer(inputDimension, hiddenDimension, hiddenUnit, initParamsStdDev, rng));
            } else {
                layers.add(new RnnLayer(hiddenDimension, hiddenDimension, hiddenUnit, initParamsStdDev, rng));
            }
            ++h;
        }
        layers.add(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return new NeuralNetwork(layers);
    }
}

