/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import matrix.Matrix;
import theGhastModding.utils.math.ByteConverters;

public class MatrixPagefile {
    private File folder;
    private int temp = 0;

    public MatrixPagefile(File folder) throws Exception {
        if (!folder.exists()) {
            folder.mkdir();
        } else {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
        }
        this.folder = folder;
    }

    public void updateMatrix(Matrix m, int index) throws Exception {
        double d;
        File matrixFile = new File(this.folder + "/matrix" + Integer.toString(this.temp) + ".mat");
        if (!matrixFile.exists()) {
            throw new FileNotFoundException();
        }
        matrixFile.delete();
        FileOutputStream fos = new FileOutputStream(matrixFile);
        fos.write(ByteConverters.intToBytes(m.cols));
        fos.write(ByteConverters.intToBytes(m.rows));
        double[] dArray = m.w;
        int n = m.w.length;
        int n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            fos.write(ByteConverters.doubleToBytes(d));
            fos.flush();
            ++n2;
        }
        dArray = m.dw;
        n = m.dw.length;
        n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            fos.write(ByteConverters.doubleToBytes(d));
            fos.flush();
            ++n2;
        }
        dArray = m.stepCache;
        n = m.stepCache.length;
        n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            fos.write(ByteConverters.doubleToBytes(d));
            fos.flush();
            ++n2;
        }
        fos.close();
    }

    public int writeMatrix(Matrix m) throws Exception {
        double d;
        ++this.temp;
        File matrixFile = new File(this.folder + "/matrix" + Integer.toString(this.temp) + ".mat");
        FileOutputStream fos = new FileOutputStream(matrixFile);
        fos.write(ByteConverters.intToBytes(m.cols));
        fos.write(ByteConverters.intToBytes(m.rows));
        double[] dArray = m.w;
        int n = m.w.length;
        int n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            fos.write(ByteConverters.doubleToBytes(d));
            fos.flush();
            ++n2;
        }
        dArray = m.dw;
        n = m.dw.length;
        n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            fos.write(ByteConverters.doubleToBytes(d));
            fos.flush();
            ++n2;
        }
        dArray = m.stepCache;
        n = m.stepCache.length;
        n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            fos.write(ByteConverters.doubleToBytes(d));
            fos.flush();
            ++n2;
        }
        fos.close();
        return this.temp;
    }

    public Matrix readMatrix(int location) throws Exception {
        File matrixFile = new File(this.folder + "/matrix" + Integer.toString(location) + ".mat");
        if (!matrixFile.exists()) {
            throw new FileNotFoundException();
        }
        FileInputStream fis = new FileInputStream(matrixFile);
        byte[] tempIntBytes = new byte[4];
        byte[] tempDoubleBytes = new byte[8];
        fis.read(tempIntBytes);
        int colums = ByteConverters.bytesToInt(tempIntBytes);
        fis.read(tempIntBytes);
        int rows = ByteConverters.bytesToInt(tempIntBytes);
        double[] w = new double[rows * colums];
        int i = 0;
        while (i < w.length) {
            fis.read(tempDoubleBytes);
            w[i] = ByteConverters.bytesToDouble(tempDoubleBytes);
            ++i;
        }
        double[] dw = new double[rows * colums];
        int i2 = 0;
        while (i2 < dw.length) {
            fis.read(tempDoubleBytes);
            dw[i2] = ByteConverters.bytesToDouble(tempDoubleBytes);
            ++i2;
        }
        double[] stepCache = new double[rows * colums];
        int i3 = 0;
        while (i3 < stepCache.length) {
            fis.read(tempDoubleBytes);
            stepCache[i3] = ByteConverters.bytesToDouble(tempDoubleBytes);
            ++i3;
        }
        fis.close();
        Matrix toReturn = new Matrix(rows, colums);
        toReturn.w = w;
        toReturn.dw = dw;
        toReturn.stepCache = stepCache;
        return toReturn;
    }
}

