/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.leff.midi.MidiFile;
import com.leff.midi.MidiTrack;
import com.leff.midi.event.MidiEvent;
import com.leff.midi.event.NoteOff;
import com.leff.midi.event.NoteOn;
import com.leff.midi.event.meta.Tempo;
import com.leff.midi.event.meta.Text;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

public class MIDIUtil {
    static {
        MidiTrack.deltaFix = true;
        MidiEvent.statusByteFix = true;
    }

    public static MidiFile toMidiFile(File inputFile) throws Exception {
        FileInputStream fis = new FileInputStream(inputFile);
        String name = MIDIUtil.readLine(fis);
        String l = MIDIUtil.readLine(fis);
        if (!l.startsWith("R:")) {
            throw new Exception("Invalid header: no resolution specified");
        }
        int resolution = Integer.parseInt(l.substring(2), 16);
        l = MIDIUtil.readLine(fis);
        if (!l.startsWith("T:")) {
            throw new Exception("Invalid header: no tempo specified");
        }
        float bpm = Float.parseFloat(l.substring(2));
        MidiFile midi = new MidiFile(resolution);
        MidiTrack tempoTrack = new MidiTrack();
        Tempo tempo = new Tempo();
        tempo.setBpm(bpm);
        Text text = new Text(0L, 0L, name);
        tempoTrack.insertEvent(tempo);
        tempoTrack.insertEvent(text);
        MidiTrack noteTrack = new MidiTrack();
        long totalTime = 0L;
        int cntr = 0;
        while (fis.available() > 0) {
            ++cntr;
            try {
                String[] a;
                l = MIDIUtil.readLine(fis);
                if (l.equals("E")) break;
                if (l.startsWith("T")) {
                    a = l.substring(1).split(",");
                    float newBpm = Float.parseFloat(a[0]);
                    Tempo newTempo = new Tempo(totalTime += Long.parseLong(a[1], 16), 0L, (int)(6.0E7f / newBpm));
                    tempoTrack.insertEvent(newTempo);
                    continue;
                }
                a = l.substring(3).split(",");
                short noteVal = (short)l.charAt(1);
                int channel = (short)l.charAt(2) - 35;
                totalTime += Long.parseLong(a[1], 16);
                if (Long.parseLong(a[1], 16) == 0L) {
                    ++totalTime;
                }
                long length = Long.parseLong(a[2], 16);
                NoteOn on = new NoteOn(totalTime, channel, noteVal, 100);
                NoteOff off = new NoteOff(totalTime + length, channel, noteVal, 0);
                noteTrack.insertEvent(on);
                noteTrack.insertEvent(off);
            }
            catch (Exception e) {
                System.err.println("Error in line " + Integer.toString(cntr + 3));
                e.printStackTrace();
                System.exit(1);
            }
        }
        midi.addTrack(tempoTrack);
        midi.addTrack(noteTrack);
        fis.close();
        return midi;
    }

    public static void toMidiFile(File inputFile, File outputFile) throws Exception {
        MIDIUtil.toMidiFile(inputFile).writeToFile(outputFile);
    }

    public static String readLine(FileInputStream fis) throws Exception {
        String line = "";
        while (fis.available() > 0) {
            char c = (char)fis.read();
            if (c == '\n') {
                return line.trim();
            }
            line = String.valueOf(line) + c;
        }
        return line.trim();
    }

    public static void toTextFile(File midiFile, File outputFile, int maxLineCount) throws Exception {
        MIDIUtil.toTextFile(new MidiFile(midiFile), outputFile, maxLineCount);
    }

    public static void toTextFile(MidiFile midi, File outputFile, int maxLineCount) throws Exception {
        ArrayList<MidiEvent> importantEvents = new ArrayList<MidiEvent>();
        ArrayList tempos = new ArrayList();
        boolean b = false;
        int i = 0;
        while (i < midi.getTrackCount()) {
            for (MidiEvent midiEvent : midi.getTrack(i).getEvents()) {
                if (midiEvent instanceof NoteOn || midiEvent instanceof NoteOff) {
                    importantEvents.add(midiEvent);
                }
                if (!(midiEvent instanceof Tempo)) continue;
                importantEvents.add((Tempo)midiEvent);
                if (midiEvent.getTick() != 0L) continue;
                b = true;
            }
            ++i;
        }
        if (!b) {
            System.out.println("No beginning Tempo event found. Using default speed of 120BPM");
            importantEvents.add(new Tempo());
        }
        FileOutputStream strem = new FileOutputStream(outputFile);
        strem.write((String.valueOf(outputFile.getName()) + "\nR:" + Integer.toHexString(midi.getResolution()) + "\n").getBytes());
        for (MidiEvent event : importantEvents) {
            if (!(event instanceof Tempo) || event.getTick() != 0L) continue;
            strem.write(("T:" + Float.toString(((Tempo)event).getBpm()) + "\n").getBytes());
            strem.flush();
            break;
        }
        List<Note> ns = MIDIUtil.connectNotes(importantEvents);
        ns = MIDIUtil.sortByTickNotes(ns);
        long l = 0L;
        int cntr = 0;
        for (Note n : ns) {
            if (n.getStart().getNoteValue() < 32) continue;
            strem.write(("N" + (char)n.getStart().getNoteValue() + (char)(n.getStart().getChannel() + 35) + "," + Long.toHexString(n.getStart().getTick() - l) + "," + Long.toHexString(n.getEnd().getTick() - n.getStart().getTick()) + "\n").getBytes());
            strem.flush();
            l = n.getStart().getTick();
            for (Tempo t : tempos) {
                if (t.getMpqn() <= 1 || t.getTick() < l) continue;
                strem.write(("T" + Float.toString(t.getBpm()) + "," + Long.toHexString(t.getTick() - l) + "\n").getBytes());
                strem.flush();
                t.setMpqn(1);
                l = t.getTick();
            }
            if (++cntr >= maxLineCount) break;
        }
        strem.write(69);
        strem.flush();
        strem.close();
    }

    public static List<Note> sortByTickNotes(List<Note> list) {
        int i = 1;
        while (i < list.size()) {
            Note event = list.get(i);
            int j = i;
            while (j > 0 && list.get(j - 1).getStart().getTick() > event.getStart().getTick()) {
                list.set(j, list.get(j - 1));
                --j;
            }
            list.set(j, event);
            ++i;
        }
        return list;
    }

    public static List<Note> connectNotes(List<MidiEvent> events) {
        if (events == null) {
            return null;
        }
        if (events.isEmpty()) {
            return null;
        }
        ArrayList<Note> returnnotes = new ArrayList<Note>();
        ArrayList<Note> tempNotes = new ArrayList<Note>();
        int o = 0;
        while (o < 128) {
            int l = 0;
            while (l < events.size()) {
                MidiEvent event = events.get(l);
                if (event instanceof NoteOn && ((NoteOn)event).getNoteValue() == o) {
                    tempNotes.add(new Note((NoteOn)event, null));
                }
                if (event instanceof NoteOff && ((NoteOff)event).getNoteValue() == o && !tempNotes.isEmpty()) {
                    int start = tempNotes.size();
                    if (start != 0) {
                        // empty if block
                    }
                    int m = --start;
                    while (m > -1) {
                        Note currentNote = (Note)tempNotes.get(m);
                        if (currentNote.getEnd() == null && currentNote.getStart().getTick() < event.getTick() && currentNote.getStart().getChannel() == ((NoteOff)event).getChannel()) {
                            currentNote.setEnd((NoteOff)event);
                            break;
                        }
                        --m;
                    }
                }
                ++l;
            }
            if (!tempNotes.isEmpty()) {
                for (Note n : tempNotes) {
                    if (n.getStart() == null || n.getEnd() == null || n.getEnd().getTick() <= n.getStart().getTick()) continue;
                    returnnotes.add(n);
                }
                tempNotes.clear();
            }
            ++o;
        }
        return returnnotes;
    }

    public static class Note {
        private NoteOn start;
        private NoteOff end;

        public Note(NoteOn start, NoteOff end) {
            this.start = start;
            this.end = end;
        }

        public NoteOn getStart() {
            return this.start;
        }

        public void setStart(NoteOn start) {
            this.start = start;
        }

        public NoteOff getEnd() {
            return this.end;
        }

        public void setEnd(NoteOff end) {
            this.end = end;
        }

        public String toString() {
            return "Start: " + this.start.toString() + ", end: " + this.end.toString();
        }
    }
}

