/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class ImageUtil {
    public static void toText(BufferedImage image, File output, String comment) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(output));
        bw.write("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.@#_:/-, \n");
        bw.newLine();
        bw.flush();
        bw.write("@W:" + Integer.toString(image.getWidth()) + "#");
        bw.newLine();
        bw.write("H:" + Integer.toString(image.getHeight()) + "#");
        bw.newLine();
        bw.flush();
        if (comment != null && !comment.isEmpty()) {
            bw.write("//" + comment);
        }
        bw.newLine();
        bw.flush();
        int i = 0;
        while (i < image.getWidth()) {
            int j = 0;
            while (j < image.getHeight()) {
                Color c = new Color(image.getRGB(i, j));
                bw.write(String.valueOf(ImageUtil.fancyFormat(c.getRed())) + ImageUtil.fancyFormat(c.getGreen()) + ImageUtil.fancyFormat(c.getBlue()) + ",");
                ++j;
            }
            bw.flush();
            bw.newLine();
            ++i;
        }
        bw.close();
    }

    public static String fancyFormat(int number) {
        String toReturn = Integer.toHexString(number);
        if (number < 16) {
            toReturn = "0" + toReturn;
        }
        return toReturn;
    }

    public static BufferedImage toImage(File input) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(input));
        br.readLine();
        int width = Integer.parseInt(br.readLine().substring(3).replaceAll("#", ""));
        int height = Integer.parseInt(br.readLine().substring(2).replaceAll("#", ""));
        BufferedImage image = new BufferedImage(width, height, 1);
        int i = 0;
        while (i < width) {
            String s = br.readLine();
            if (s.startsWith("//")) {
                --i;
            } else {
                String[] numbers = s.split(",");
                int j = 0;
                while (j < numbers.length) {
                    if (numbers[j] != null && !numbers[j].isEmpty()) {
                        image.setRGB(i, j, Integer.parseInt(numbers[j]));
                    }
                    ++j;
                }
            }
            ++i;
        }
        br.close();
        return image;
    }
}

