/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.lstmStuff.main;

import autodiff.Graph;
import datastructs.TensorDataSequence;
import datastructs.TensorDataSet;
import datastructs.TensorDataStep;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import loss.LossSumOfSquares;
import matrix.Matrix;
import matrix.Tensor;
import model.ConvFlatten;
import model.ConvLayer;
import model.ConvNet;
import model.ConvNonlinLayer;
import model.FeedForwardLayer;
import model.Model;
import model.NeuralNetwork;
import model.TensorLayer;
import nonlinearities.LinearUnit;
import nonlinearities.Nonlinearity;
import nonlinearities.ReLuUnit;
import theGhastModding.console.main.Console;
import theGhastModding.lstmStuff.gameThingy.TouhouWrapper;
import theGhastModding.lstmStuff.gui.ResourceDisplay;
import theGhastModding.utils.math.ByteConverters;
import trainer.Adam;
import trainer.NewTrainer;
import trainer.TrainingMethod;
import util.FileIO;

public class TouhouAI
implements Runnable {
    private TouhouWrapper wrapper;
    private Robot robot;
    private int currentlySelectedStage = 1;
    private ConvNet model;
    private ThreadPoolExecutor threadPool;
    private KeyPresser keyPresserThread;
    private GameInput gameIn;
    private ReplayFrame[] replayBuffer;
    private ReplaySaver replaySaver;
    public static final int bufferSizeInSeconds = 10;
    private String savePath;
    private File replaySavePath;
    private NewTrainer trainer;
    private double epsilon = 0.9;
    private Random randomKeyRandom = new Random();

    public TouhouAI(String gameExecutable, ConvNet model, String savePath, TrainingMethod method) throws Exception {
        this.wrapper = new TouhouWrapper(new File(gameExecutable));
        this.robot = new Robot();
        this.model = model;
        this.savePath = savePath;
        if (new File(savePath).exists()) {
            FileIO.loadNeuralNetwork(savePath, model);
        }
        if (new File(String.valueOf(savePath) + ".a").exists()) {
            try {
                this.loadSettings(String.valueOf(savePath) + ".a");
            }
            catch (Exception e) {
                System.err.println("Error loading TouhouAI settings. Using defaults.");
                e.printStackTrace();
                this.epsilon = 0.9;
            }
        }
        this.threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(8);
        this.keyPresserThread = new KeyPresser();
        this.gameIn = new GameInput();
        this.replayBuffer = new ReplayFrame[250];
        this.replaySavePath = new File("G:/TouhouAI/");
        this.replaySaver = new ReplaySaver(this.replaySavePath);
        this.trainer = new NewTrainer(method, false);
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    private void loadSettings(String path) throws Exception {
        FileInputStream fis = new FileInputStream(new File(path));
        byte[] doubleBuffer = new byte[8];
        fis.read(doubleBuffer);
        this.epsilon = ByteConverters.bytesToDouble(doubleBuffer);
        fis.close();
    }

    private void saveSettings(String path) throws Exception {
        FileOutputStream fos = new FileOutputStream(new File(path));
        fos.write(ByteConverters.doubleToBytes(this.epsilon));
        fos.close();
    }

    public void startGame() throws Exception {
        this.wrapper.start();
        this.sleep(1000L);
        this.pressKey(40);
        this.sleep(1000L);
        this.pressKey(89);
        this.sleep(1000L);
        this.pressKey(89);
        this.sleep(1000L);
        this.pressKey(89);
        this.sleep(1000L);
        this.pressKey(89);
        this.sleep(1000L);
    }

    public void closeGame() throws Exception {
        this.wrapper.stop();
        this.robot.keyPress(18);
        this.pressKey(115);
        this.robot.keyRelease(18);
    }

    public void selectStage(int stage) {
        if (this.currentlySelectedStage - stage < 0) {
            int i = 0;
            while (i < -(this.currentlySelectedStage - stage)) {
                this.pressKey(40);
                this.sleep(500L);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.currentlySelectedStage - stage) {
                this.pressKey(38);
                this.sleep(500L);
                ++i;
            }
        }
        this.currentlySelectedStage = stage;
    }

    public void startStage() {
        this.sleep(1000L);
        this.pressKey(89);
        this.sleep(1000L);
    }

    public void finishStage(boolean died) {
        if (!died) {
            this.sleep(5000L);
            this.pressKey(89);
            this.sleep(5000L);
            this.pressKey(88);
            this.sleep(5000L);
        } else {
            this.sleep(1000L);
            this.pressKey(27);
            this.sleep(1000L);
            this.pressKey(40);
            this.sleep(1500L);
            this.pressKey(89);
            this.sleep(1000L);
            this.pressKey(38);
            this.sleep(1000L);
            this.pressKey(89);
            this.sleep(5000L);
        }
    }

    @Override
    public void run() {
        this.model.resetState();
        this.startStage();
        BufferedImage t1 = null;
        BufferedImage t2 = null;
        BufferedImage t3 = null;
        BufferedImage t4 = null;
        Tensor inBuffer = null;
        Matrix outBuffer = null;
        this.gameIn.b = true;
        this.threadPool.execute(this.gameIn);
        this.sleep(12000L);
        try {
            Graph g = new Graph(false);
            while (this.wrapper.getScore() == -1) {
                this.sleep(10L);
            }
            this.sleep(100L);
            inBuffer = new Tensor(384, 448, 4);
            boolean died = false;
            long fpsTimer = System.currentTimeMillis();
            long thingTimer = System.nanoTime();
            long targetTime = 37037037L;
            int gameScore = 0;
            int seconds = 0;
            int previousScore = 0;
            int previousLives = 8;
            Random random = new Random();
            double totalReward = 0.0;
            int fps = 0;
            while (this.wrapper.isInStage()) {
                if (System.nanoTime() - thingTimer < targetTime) continue;
                thingTimer = System.nanoTime();
                t1 = t2;
                t2 = t3;
                t3 = t4;
                t4 = this.gameIn.getScreenshot();
                gameScore = this.gameIn.getScore();
                double reward = gameScore - previousScore - 1;
                reward /= 40.0;
                previousScore = gameScore;
                if (this.gameIn.getExtraLives() < previousLives) {
                    reward -= 2.5;
                    if (this.gameIn.getExtraLives() == 6) {
                        reward -= 2.5;
                    }
                }
                if (this.gameIn.getExtraLives() > previousLives) {
                    reward += 5.0;
                }
                totalReward += reward;
                if (t1 == null) continue;
                inBuffer.setMatrixAt(0, inBuffer.getMatrixAt(1));
                inBuffer.setMatrixAt(1, inBuffer.getMatrixAt(2));
                inBuffer.setMatrixAt(2, inBuffer.getMatrixAt(3));
                inBuffer.setMatrixAt(3, this.grayscale(t4));
                int i = this.replayBuffer.length - 1;
                while (i > 0) {
                    this.replayBuffer[i] = this.replayBuffer[i - 1];
                    --i;
                }
                outBuffer = this.model.forward(inBuffer, g).getMatrixAt(0);
                int action = this.evaluateOutput(outBuffer);
                this.replayBuffer[0] = new ReplayFrame(t4, gameScore, reward, action);
                if (this.gameIn.getExtraLives() < previousLives) {
                    if (this.replaySaver.saving) {
                        this.replaySaver.abort = true;
                        if (this.replaySaver.saving) {
                            while (this.replaySaver.saving) {
                                this.sleep(1L);
                            }
                        }
                    }
                    System.arraycopy(this.replayBuffer, 0, this.replaySaver.replayFrames, 0, this.replayBuffer.length);
                    this.replaySaver.important = true;
                    this.threadPool.execute(this.replaySaver);
                }
                previousLives = this.gameIn.getExtraLives();
                ++fps;
                if (System.currentTimeMillis() - fpsTimer >= 1000L) {
                    fpsTimer = System.currentTimeMillis();
                    System.gc();
                    if (++seconds >= 10) {
                        seconds = 0;
                        if (random.nextInt(4) == 0 && !this.replaySaver.saving) {
                            System.arraycopy(this.replayBuffer, 0, this.replaySaver.replayFrames, 0, this.replayBuffer.length);
                            this.replaySaver.important = false;
                            this.threadPool.execute(this.replaySaver);
                        }
                    }
                    System.out.println("[DEBUG] FPS: " + Integer.toString(fps));
                    fps = 0;
                    System.out.println("[DEBUG] Game Score = " + Integer.toString(this.gameIn.getScore()) + " | Total reward = " + Double.toString(totalReward) + " | Last reward: " + Double.toString(reward) + " | Extra lives = " + Integer.toString(this.gameIn.getExtraLives() - 6));
                }
                if (this.gameIn.getExtraLives() != 6) continue;
                died = true;
                break;
            }
            if (!died) {
                if (this.replaySaver.saving) {
                    while (this.replaySaver.saving) {
                    }
                }
                System.arraycopy(this.replayBuffer, 0, this.replaySaver.replayFrames, 0, this.replayBuffer.length);
                this.replaySaver.important = true;
                this.threadPool.execute(this.replaySaver);
            }
            this.model.resetState();
            this.gameIn.b = false;
            this.robot.keyRelease(39);
            this.robot.keyRelease(37);
            this.robot.keyRelease(38);
            this.robot.keyRelease(40);
            this.robot.keyRelease(16);
            this.robot.keyRelease(89);
            this.finishStage(died);
            Thread.sleep(15000L);
        }
        catch (Exception e) {
            System.err.println("Error in main thread: ");
            e.printStackTrace();
            try {
                this.closeGame();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return;
        }
    }

    private int evaluateOutput(Matrix m) {
        int i = this.findLargestIndx(m);
        if (this.epsilon > 0.0 && this.randomKeyRandom.nextDouble() <= this.epsilon) {
            i = 0;
            i = this.randomKeyRandom.nextInt(2) == 0 ? (i |= 1) : (i |= 2);
            i = this.randomKeyRandom.nextInt(2) == 0 ? (i |= 4) : (i |= 8);
            if (this.randomKeyRandom.nextInt(3) != 0) {
                i |= 0x10;
            }
            if (this.randomKeyRandom.nextInt(3) != 0) {
                i |= 0x20;
            }
        }
        this.keyPresserThread.i = i;
        this.threadPool.execute(this.keyPresserThread);
        return i;
    }

    private int findLargestIndx(Matrix m) {
        int largestIndx = 0;
        double largest = -1.0E8;
        int i = 0;
        while (i < m.w.length) {
            if (m.w[i] > largest) {
                largestIndx = i;
                largest = m.w[i];
            }
            ++i;
        }
        return largestIndx;
    }

    public Matrix grayscale(BufferedImage in) throws Exception {
        Matrix toReturn = new Matrix(in.getHeight(), in.getWidth());
        int i = 0;
        while (i < in.getWidth()) {
            int j = 0;
            while (j < in.getHeight()) {
                int argb = in.getRGB(i, j);
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb >> 0 & 0xFF;
                float gray = (float)r / 3.0f + (float)g / 3.0f + (float)b / 3.0f;
                toReturn.setW(j, i, gray / 256.0f);
                ++j;
            }
            ++i;
        }
        return toReturn;
    }

    private void pressKey(int keycode) {
        this.robot.keyPress(keycode);
        this.sleep(20L);
        this.robot.keyRelease(keycode);
    }

    private void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double train(Random random, int epochs, double learningRate, int reportEveryNthEpoch) throws Exception {
        System.out.println("[DEBUG] Training starts");
        ArrayList<Integer> cs = new ArrayList<Integer>();
        for (TensorLayer tl : this.model.getLayers()) {
            if (!(tl instanceof ConvLayer)) continue;
            cs.add(((ConvLayer)tl).getCores());
            ((ConvLayer)tl).setCores(Runtime.getRuntime().availableProcessors());
        }
        ReplayDataset dataset = new ReplayDataset(this.replaySavePath, 32, random);
        if (new File(this.savePath).exists()) {
            System.out.println("initializing model from saved state...");
            FileIO.loadNeuralNetwork(this.savePath, this.model);
        }
        double currLoss = this.trainer.trainConvNet(this.model, learningRate, epochs, dataset, reportEveryNthEpoch, this.savePath, false, false, random, null);
        dataset = null;
        System.out.println("Autosaving model...");
        FileIO.saveNeuralNetwork(this.savePath, this.model);
        System.gc();
        System.out.println("[DEBUG] Training finished");
        this.epsilon *= this.epsilon;
        if (this.epsilon < 0.001) {
            this.epsilon = 0.0;
        }
        System.out.println("Epsilon is now " + Double.toString(this.epsilon));
        int z = 0;
        for (TensorLayer tl : this.model.getLayers()) {
            if (!(tl instanceof ConvLayer)) continue;
            ((ConvLayer)tl).setCores((Integer)cs.get(z));
            ++z;
        }
        try {
            this.saveSettings(String.valueOf(this.savePath) + ".a");
        }
        catch (Exception e) {
            System.err.println("Error saving settings");
            e.printStackTrace();
        }
        return currLoss;
    }

    public static void main(String[] args) {
        boolean trainOnly;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TouhouAI ai = null;
        Random random = new Random();
        ConvNet model = new ConvNet();
        model.addLayer(new ConvLayer(8, 384, 448, 4, 16, 16, 16, 0.12, random, true, 6));
        model.addLayer(new ConvNonlinLayer(new ReLuUnit()));
        model.addLayer(new ConvLayer(2, 47, 55, 16, 5, 5, 16, 0.1, random, true, 6));
        model.addLayer(new ConvNonlinLayer(new ReLuUnit()));
        model.addLayer(new ConvLayer(2, 22, 26, 16, 4, 4, 16, 0.08, random, true, 6));
        model.addLayer(new ConvLayer(1, 10, 12, 16, 3, 3, 16, 0.04, random, true, 6));
        model.addLayer(new ConvFlatten(8, 10, 16));
        ArrayList<Model> fcLayers = new ArrayList<Model>();
        fcLayers.add(new FeedForwardLayer(1280, 512, new LinearUnit(), 0.008, random));
        fcLayers.add(new FeedForwardLayer(512, 64, new LinearUnit(), 0.04, random));
        NeuralNetwork fc = new NeuralNetwork(fcLayers);
        model.setFullyConnected(fc);
        ResourceDisplay rd = null;
        try {
            rd = new ResourceDisplay(null, "Intel(R) Xeon(R) CPU E5-1620 v4", "DDR4 SDRAM PC4-17000, ECC, registered");
            rd.setLocation(650, 16);
            rd.showFrame();
        }
        catch (Exception e) {
            System.err.println("Error creating resource display: ");
            e.printStackTrace();
            rd = null;
        }
        try {
            ai = new TouhouAI("th.lnk", model, "touhouGameAI.ser", new Adam(0.9, 0.999, 0.001));
        }
        catch (Exception e) {
            System.err.println("Error creating AI: ");
            e.printStackTrace();
            System.exit(1);
        }
        boolean bl = trainOnly = args.length > 0 && args[0].equalsIgnoreCase("train");
        if (!trainOnly) {
            try {
                ai.setEpsilon(-1.0);
                ai.startGame();
            }
            catch (Exception e) {
                System.err.println("Error starting game: ");
                e.printStackTrace();
                System.exit(1);
            }
            ai.selectStage(3);
            Thread t = new Thread(ai);
            t.start();
            try {
                t.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(1000L);
                ai.closeGame();
            }
            catch (Exception e) {
                System.err.println("Error closing game: ");
                e.printStackTrace();
                System.exit(1);
            }
        }
        try {
            File fff = new File("touhouAIBackups/");
            if (!fff.exists()) {
                fff.mkdir();
            }
            int i = 0;
            while (i < 50) {
                System.err.println(String.valueOf(Integer.toString(i)) + "/50");
                double loss = ai.train(new Random(), 1, 0.001, 1);
                System.out.println("Loss after training is " + Double.toString(loss));
                System.out.println("Creating backup of network...");
                FileOutputStream fos = new FileOutputStream("touhouAIBackups/touhouGameAI_backup" + Integer.toString(LocalDateTime.now().getMinute()) + ".ser");
                Files.copy(new File("touhouGameAI.ser").toPath(), fos);
                fos.close();
                fos = new FileOutputStream("touhouAIBackups/touhouGameAI_backup" + Integer.toString(LocalDateTime.now().getMinute()) + ".txt");
                fos.write(("Last reported loss here was: " + Double.toString(loss)).getBytes());
                fos.flush();
                fos.close();
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Error training model: ");
            e.printStackTrace();
            System.exit(1);
        }
        if (rd != null) {
            rd.closeFrame();
        }
        System.exit(0);
    }

    private class GameInput
    implements Runnable {
        private BufferedImage screenshot;
        private int score = 0;
        private int extraLives = 0;
        private boolean b = false;
        private BufferedImage fullScreenshot;

        private GameInput() {
        }

        @Override
        public void run() {
            long debugTimer = System.currentTimeMillis();
            long fpsTimer = System.currentTimeMillis();
            double targetTime = 33.333333333333336;
            int fps = 0;
            while (this.b) {
                if ((double)(System.currentTimeMillis() - fpsTimer) >= targetTime) {
                    fpsTimer = System.currentTimeMillis();
                    try {
                        this.score = TouhouAI.this.wrapper.getScore();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.fullScreenshot = TouhouAI.this.wrapper.getGameScreen();
                    this.screenshot = this.fullScreenshot.getSubimage(32, 16, 384, 448);
                    this.extraLives = TouhouAI.this.wrapper.getExtraLivesFromGameScreen(this.fullScreenshot);
                    ++fps;
                    if (System.currentTimeMillis() - debugTimer >= 1000L) {
                        debugTimer = System.currentTimeMillis();
                        System.out.println("[DEBUG] Game capture FPS = " + Integer.toString(fps));
                        fps = 0;
                    }
                }
                try {
                    Thread.sleep(2L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public BufferedImage getScreenshot() {
            return this.screenshot;
        }

        public int getScore() {
            return this.score;
        }

        public int getExtraLives() {
            return this.extraLives;
        }
    }

    private class KeyPresser
    implements Runnable {
        private int i;
        private boolean r;
        private boolean l;
        private boolean u;
        private boolean d;
        private boolean s;
        private boolean y;
        private boolean old_y;
        private boolean old_s = false;

        private KeyPresser() {
        }

        @Override
        public void run() {
            this.r = this.isBitSet(this.i, 0);
            this.l = this.isBitSet(this.i, 1);
            this.u = this.isBitSet(this.i, 2);
            this.d = this.isBitSet(this.i, 3);
            this.old_s = this.s;
            this.s = this.isBitSet(this.i, 4);
            this.old_y = this.y;
            this.y = this.isBitSet(this.i, 5);
            if (this.old_y && !this.y) {
                TouhouAI.this.robot.keyRelease(89);
            }
            if (!this.old_y && this.y) {
                TouhouAI.this.robot.keyPress(89);
            }
            if (this.old_s && !this.s) {
                TouhouAI.this.robot.keyRelease(16);
            }
            if (!this.old_s && this.s) {
                TouhouAI.this.robot.keyPress(16);
            }
            if (this.r) {
                TouhouAI.this.robot.keyPress(39);
            }
            if (this.l) {
                TouhouAI.this.robot.keyPress(37);
            }
            if (this.u) {
                TouhouAI.this.robot.keyPress(38);
            }
            if (this.d) {
                TouhouAI.this.robot.keyPress(40);
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.r) {
                TouhouAI.this.robot.keyRelease(39);
            }
            if (this.l) {
                TouhouAI.this.robot.keyRelease(37);
            }
            if (this.u) {
                TouhouAI.this.robot.keyRelease(38);
            }
            if (this.d) {
                TouhouAI.this.robot.keyRelease(40);
            }
        }

        private boolean isBitSet(int i, int position) {
            return (i >> position & 1) == 1;
        }
    }

    private class ReplayDataset
    extends TensorDataSet {
        private ReplayDataset(File replayFolder, int maxSize, Random random) throws Exception {
            this.inputDimension = new TensorDataSet.TensorDimensions(384, 448, 4);
            this.outputDimension = new TensorDataSet.TensorDimensions(1, 64, 1);
            this.lossTraining = new LossSumOfSquares();
            this.lossReporting = new LossSumOfSquares();
            this.training = new ArrayList();
            File[] replays = replayFolder.listFiles();
            ArrayList<File> importantReplays = new ArrayList<File>();
            ArrayList<File> unimportantReplays = new ArrayList<File>();
            File[] fileArray = replays;
            int n = replays.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.listFiles().length >= 200) {
                    if (this.isImportant(f)) {
                        importantReplays.add(f);
                    } else {
                        unimportantReplays.add(f);
                    }
                }
                ++n2;
            }
            if (importantReplays.size() == 0 && unimportantReplays.size() == 0) {
                throw new Exception("No usable replays found");
            }
            unimportantReplays.isEmpty();
            if (!importantReplays.isEmpty()) {
                this.addData(random, maxSize, importantReplays);
            }
            if (this.training.isEmpty()) {
                throw new Exception("No data loaded successfully; dataset is empty");
            }
            System.gc();
        }

        private void addData(Random random, int maxSize, List<File> replayFiles) throws Exception {
            TensorDataSequence seq = new TensorDataSequence();
            int i = 0;
            while (i < maxSize) {
                block9: {
                    System.out.println(String.valueOf(Integer.toString(i + 1)) + "/" + Integer.toString(maxSize));
                    int randomReplay = random.nextInt(replayFiles.size());
                    File[] fs = replayFiles.get(randomReplay).listFiles();
                    int randomFile = random.nextInt(fs.length / 2 - 10) + 5;
                    int maxForward = randomFile >= 30 ? 30 : randomFile;
                    ReplayFrame[] replayFrames = new ReplayFrame[maxForward + 4];
                    Tensor netInput = new Tensor(384, 448, 4);
                    try {
                        int j = 0;
                        while (j < replayFrames.length) {
                            replayFrames[j] = new ReplayFrame(null, 0, 0.0, 0);
                            replayFrames[j].load(new File(String.valueOf(replayFiles.get(randomReplay).getPath()) + "/" + Integer.toString(randomFile + 3 - j) + ".dat"), new File(String.valueOf(replayFiles.get(randomReplay).getPath()) + "/" + Integer.toString(randomFile + 3 - j) + ".png"));
                            ++j;
                        }
                        netInput.setMatrixAt(3, TouhouAI.this.grayscale(replayFrames[3].getFrame()));
                        netInput.setMatrixAt(2, TouhouAI.this.grayscale(replayFrames[2].getFrame()));
                        netInput.setMatrixAt(1, TouhouAI.this.grayscale(replayFrames[1].getFrame()));
                        netInput.setMatrixAt(0, TouhouAI.this.grayscale(replayFrames[0].getFrame()));
                    }
                    catch (Exception e) {
                        System.err.println("Error reading a replay frame. Skipping this one (" + Integer.toString(randomFile) + "). Error: ");
                        e.printStackTrace();
                        break block9;
                    }
                    Tensor targetOutput = new Tensor(1, 64, 1);
                    targetOutput.getMatrixAt((int)0).w[replayFrames[3].getAction()] = replayFrames[4].getReward() / 5.0;
                    int j = 5;
                    while (j < replayFrames.length) {
                        int n = replayFrames[3].getAction();
                        targetOutput.getMatrixAt((int)0).w[n] = targetOutput.getMatrixAt((int)0).w[n] + Math.pow(0.8, j - 4) * (replayFrames[j].getReward() / 5.0);
                        ++j;
                    }
                    int x = 0;
                    while (x < 64) {
                        if (x != replayFrames[3].getAction()) {
                            targetOutput.getMatrixAt((int)0).w[x] = Double.NEGATIVE_INFINITY;
                        }
                        ++x;
                    }
                    if (targetOutput.getMatrixAt((int)0).w[replayFrames[3].getAction()] < -2.5) {
                        targetOutput.getMatrixAt((int)0).w[replayFrames[3].getAction()] = -2.5;
                    }
                    if (targetOutput.getMatrixAt((int)0).w[replayFrames[3].getAction()] > 2.5) {
                        targetOutput.getMatrixAt((int)0).w[replayFrames[3].getAction()] = 2.5;
                    }
                    seq.addDataStep(new TensorDataStep(netInput, targetOutput));
                }
                ++i;
            }
            this.training.add(seq);
        }

        private boolean isImportant(File f) {
            String[] stringArray = f.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.contains("important.txt")) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public void DisplayReport(ConvNet model, Random rng, Console c) throws Exception {
        }

        @Override
        public Nonlinearity getModelOutputUnitToUse() {
            return new LinearUnit();
        }
    }

    private class ReplayFrame {
        private BufferedImage frame;
        private int gameScore;
        private double aiScore;
        private int action;

        private ReplayFrame(BufferedImage frame, int gameScore, double aiScore, int action) {
            this.frame = frame;
            this.gameScore = gameScore;
            this.aiScore = aiScore;
            this.action = action;
        }

        private void save(File data, File image) throws Exception {
            FileOutputStream fos = new FileOutputStream(data);
            fos.write(ByteConverters.intToBytes(this.gameScore));
            fos.write(ByteConverters.doubleToBytes(this.aiScore));
            fos.write(ByteConverters.intToBytes(this.action));
            fos.flush();
            fos.close();
            ImageIO.write((RenderedImage)this.frame, "png", image);
        }

        private void load(File data, File image) throws Exception {
            FileInputStream fis = new FileInputStream(data);
            byte[] buffer1 = new byte[4];
            byte[] buffer2 = new byte[8];
            fis.read(buffer1);
            this.gameScore = ByteConverters.bytesToInt(buffer1);
            fis.read(buffer2);
            this.aiScore = ByteConverters.bytesToDouble(buffer2);
            fis.read(buffer1);
            this.action = ByteConverters.bytesToInt(buffer1);
            fis.close();
            this.frame = ImageIO.read(image);
        }

        public BufferedImage getFrame() {
            return this.frame;
        }

        public double getReward() {
            return this.aiScore;
        }

        public int getAction() {
            return this.action;
        }
    }

    private class ReplaySaver
    implements Runnable {
        private boolean saving = false;
        private boolean abort = false;
        private boolean important = false;
        private ReplayFrame[] replayFrames = new ReplayFrame[250];
        private File baseFolder;

        private ReplaySaver(File baseFolder) {
            this.baseFolder = baseFolder;
            baseFolder.mkdirs();
        }

        @Override
        public void run() {
            this.saving = true;
            this.abort = false;
            long startTime = System.currentTimeMillis();
            System.err.println("[DEBUG] Saving replay buffer");
            int fileCount = this.baseFolder.list().length;
            File folder = new File(String.valueOf(this.baseFolder.toString()) + "/" + Integer.toString(fileCount));
            try {
                folder.mkdir();
                int i = 0;
                while (i < this.replayFrames.length) {
                    if (this.abort) {
                        this.abort = false;
                        break;
                    }
                    this.replayFrames[i].save(new File(String.valueOf(folder.getPath()) + "/" + Integer.toString(i) + ".dat"), new File(String.valueOf(folder.getPath()) + "/" + Integer.toString(i) + ".png"));
                    ++i;
                }
                if (this.important) {
                    File f = new File(String.valueOf(folder.getPath()) + "/important.txt");
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.write("This an extremely important replay....and stuffz.".getBytes());
                    fos.close();
                }
            }
            catch (Exception e) {
                System.err.println("The replay saver thread has encountered an error. Program will continue, but training performance my be harmed. Error: ");
                e.printStackTrace();
                this.saving = false;
            }
            System.err.println("[DEBUG] Finished saving replay buffer. Took " + Long.toString((System.currentTimeMillis() - startTime) / 1000L) + " seconds");
            this.saving = false;
        }
    }
}

