/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.lstmStuff.main;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import theGhastModding.lstmStuff.gameThingy.TouhouWrapper;

public class GameWrapperTester {
    public static void main(String[] args) {
        try {
            String gamePath = "th.lnk";
            TouhouWrapper wrapper = new TouhouWrapper(new File(gamePath));
            wrapper.start();
            JFrame dialog = new JFrame("Test");
            dialog.setResizable(false);
            dialog.setContentPane(new JPanel());
            dialog.getContentPane().setPreferredSize(new Dimension(640, 480));
            dialog.getContentPane().setLayout(null);
            dialog.setDefaultCloseOperation(2);
            dialog.setLocation(660, 0);
            dialog.pack();
            dialog.setVisible(true);
            while (wrapper.getScore() == -1) {
                Thread.sleep(100L);
            }
            ImageIO.write((RenderedImage)wrapper.getGameScreen(), "png", new File("aaAaAaaAAaaA.png"));
            Graphics g = dialog.getContentPane().getGraphics();
            g.setColor(Color.BLUE);
            g.setFont(new Font("Arial", 0, 12));
            long startTime = System.currentTimeMillis();
            long targetTime = 33L;
            startTime = System.currentTimeMillis();
            long debugTime = System.currentTimeMillis();
            int i = 0;
            while (wrapper.isInStage() && dialog.isVisible()) {
                if (System.currentTimeMillis() - startTime < targetTime) continue;
                startTime = System.currentTimeMillis();
                g.drawImage(GameWrapperTester.grayscale(wrapper.getGameScreen()), 0, 0, dialog.getContentPane());
                ++i;
                if (System.currentTimeMillis() - debugTime < 1000L) continue;
                debugTime = System.currentTimeMillis();
                System.out.println("Score: " + Integer.toString(wrapper.getScore()));
                System.out.println("Point: " + Integer.toString(wrapper.getPoint()));
                System.out.println("FPS: " + Integer.toString(i));
                System.out.println("Extra lives: " + Integer.toString(wrapper.getExtraLivesFromGameScreen(wrapper.getGameScreen())));
                i = 0;
                System.out.println();
            }
            dialog.setVisible(false);
            g.dispose();
            wrapper.stop();
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Error: ");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static BufferedImage grayscale(BufferedImage in) throws Exception {
        BufferedImage toReturn = new BufferedImage(in.getWidth(), in.getHeight(), 1);
        int i = 0;
        while (i < in.getWidth()) {
            int j = 0;
            while (j < in.getHeight()) {
                int gray;
                int argb = in.getRGB(i, j);
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb >> 0 & 0xFF;
                int rgb = gray = (int)((double)r / 3.0 + (double)g / 3.0 + (double)b / 3.0);
                rgb = (rgb << 8) + gray;
                rgb = (rgb << 8) + gray;
                toReturn.setRGB(i, j, rgb);
                ++j;
            }
            ++i;
        }
        return toReturn;
    }
}

