/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.lstmStuff.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.InputStream;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;

public class ResourceDisplay
extends JFrame
implements Runnable {
    private Thread t;
    private Sigar sigar = new Sigar();
    private Mem mem;
    private JPanel cpuPanel;
    private JPanel memoryPanel;
    private Graphics cpuGraphics = null;
    private Graphics memoryGraphics = null;
    private CpuPerc cpu;
    private JLabel lblCpuInfo;
    private CpuInfo cpuInfo;
    private String customCpuName;
    private static Color cpuColor = new Color(17, 125, 187);
    private static Color cpuColor2 = new Color(206, 226, 240);
    private static Color memoryColor = new Color(149, 40, 180);
    private static Color memoryColor2 = new Color(227, 212, 230);
    private final boolean isHyperthreading;
    private int[] usages;
    private int[] memUsages;

    public ResourceDisplay() throws Exception {
        this(null, null, null);
    }

    public ResourceDisplay(String customTitle, String customCpuName, String customMemoryType) throws Exception {
        super(customTitle == null ? "System Resources" : customTitle);
        this.customCpuName = customCpuName;
        this.getContentPane().setLayout(null);
        this.getContentPane().setPreferredSize(new Dimension(400, 140));
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        JLabel lblCpu = new JLabel("CPU:");
        lblCpu.setBounds(10, 11, 46, 14);
        this.getContentPane().add(lblCpu);
        this.isHyperthreading = this.isHyperthreadingEnabled();
        this.cpuInfo = this.sigar.getCpuInfoList()[0];
        this.lblCpuInfo = new JLabel(String.valueOf(customCpuName == null ? this.cpuInfo.getModel() : customCpuName) + " @ " + Double.toString((double)this.cpuInfo.getMhz() / 1000.0) + "GHz (" + Integer.toString(this.cpuInfo.getTotalCores() / (this.isHyperthreading ? 2 : 1)) + "C/" + Integer.toString(this.cpuInfo.getTotalCores()) + "T)");
        this.lblCpuInfo.setBounds(66, 11, 324, 14);
        this.getContentPane().add(this.lblCpuInfo);
        this.cpuPanel = new JPanel();
        this.cpuPanel.setBackground(Color.WHITE);
        this.cpuPanel.setBounds(10, 31, 380, 35);
        this.getContentPane().add(this.cpuPanel);
        JLabel lblMemory = new JLabel("Memory:");
        lblMemory.setBounds(10, 77, 46, 14);
        this.getContentPane().add(lblMemory);
        this.mem = this.sigar.getMem();
        JLabel lblMemoryInfo = new JLabel(String.valueOf(Double.toString(Math.ceil((double)this.mem.getTotal() / 1024.0 / 1024.0 / 1024.0))) + "GB " + (customMemoryType == null ? "" : customMemoryType));
        lblMemoryInfo.setBounds(66, 77, 324, 14);
        this.getContentPane().add(lblMemoryInfo);
        this.memoryPanel = new JPanel();
        this.memoryPanel.setBackground(Color.WHITE);
        this.memoryPanel.setBounds(10, 95, 380, 35);
        this.getContentPane().add(this.memoryPanel);
        this.pack();
    }

    private boolean isHyperthreadingEnabled() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"wmic", "CPU", "Get", "NumberOfCores,NumberOfLogicalProcessors", "/Format:List"});
            p.waitFor();
            InputStream pIn = p.getInputStream();
            String sss = "";
            while (pIn.available() > 0) {
                sss = String.valueOf(sss) + (char)pIn.read();
            }
            String[] lines = sss.split("\n");
            int noc = -1;
            int nolp = -1;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.startsWith("NumberOfCores=")) {
                    noc = Integer.parseInt(s.substring(14).trim());
                } else if (s.startsWith("NumberOfLogicalProcessors=")) {
                    nolp = Integer.parseInt(s.substring(26).trim());
                }
                ++n2;
            }
            System.out.println("[DEBUG] Number of physical cores is " + Integer.toString(noc) + ", number of logical processors is " + Integer.toString(nolp));
            return noc != nolp;
        }
        catch (Exception e) {
            System.err.println("Error while trying to find out if hyperthreading is enabled: ");
            e.printStackTrace();
            return false;
        }
    }

    public void showFrame() {
        this.setVisible(true);
        this.t = new Thread(this);
        this.t.start();
    }

    public void closeFrame() {
        this.setVisible(false);
        try {
            this.t.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.usages = new int[this.cpuPanel.getWidth() + 1];
        this.memUsages = new int[this.memoryPanel.getWidth() + 1];
        while (this.isVisible()) {
            int pixelHeight;
            if (this.cpuGraphics == null) {
                this.cpuGraphics = this.cpuPanel.getGraphics();
            }
            if (this.memoryGraphics == null) {
                this.memoryGraphics = this.memoryPanel.getGraphics();
            }
            int i = this.usages.length - 1;
            while (i > 0) {
                this.usages[i] = this.usages[i - 1];
                --i;
            }
            i = this.memUsages.length - 1;
            while (i > 0) {
                this.memUsages[i] = this.memUsages[i - 1];
                --i;
            }
            try {
                this.cpu = this.sigar.getCpuPerc();
                this.mem = this.sigar.getMem();
                this.cpuInfo = this.sigar.getCpuInfoList()[0];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.lblCpuInfo.setText(String.valueOf(this.customCpuName == null ? this.cpuInfo.getModel() : this.customCpuName) + " @ " + Double.toString((double)this.cpuInfo.getMhz() / 1000.0) + "GHz (" + Integer.toString(this.cpuInfo.getTotalCores() / (this.isHyperthreading ? 2 : 1)) + "C/" + Integer.toString(this.cpuInfo.getTotalCores()) + "T)");
            this.usages[0] = pixelHeight = (int)(this.cpu.getCombined() * (double)this.cpuPanel.getHeight());
            this.memUsages[0] = pixelHeight = (int)(this.mem.getUsedPercent() / 100.0 * (double)this.memoryPanel.getHeight());
            this.cpuGraphics.setColor(Color.WHITE);
            this.memoryGraphics.setColor(Color.WHITE);
            this.cpuGraphics.fillRect(0, 0, this.cpuPanel.getWidth(), this.cpuPanel.getHeight());
            this.cpuGraphics.fillRect(0, 0, this.memoryPanel.getWidth(), this.memoryPanel.getHeight());
            int i2 = 1;
            while (i2 < this.usages.length) {
                this.cpuGraphics.setColor(cpuColor);
                this.cpuGraphics.drawLine(i2 - 1, this.cpuPanel.getHeight() - this.usages[this.usages.length - i2] - 1, i2, this.cpuPanel.getHeight() - this.usages[this.usages.length - i2 - 1] - 1);
                if (this.usages[this.usages.length - i2 - 1] != 0) {
                    this.cpuGraphics.setColor(cpuColor2);
                    this.cpuGraphics.drawLine(i2, this.cpuPanel.getHeight() - this.usages[this.usages.length - i2 - 1] - 1, i2, this.cpuPanel.getHeight() - 1);
                }
                ++i2;
            }
            i2 = 1;
            while (i2 < this.memUsages.length) {
                this.memoryGraphics.setColor(memoryColor);
                this.memoryGraphics.drawLine(i2 - 1, this.memoryPanel.getHeight() - this.memUsages[this.memUsages.length - i2] - 1, i2, this.memoryPanel.getHeight() - this.memUsages[this.memUsages.length - i2 - 1] - 1);
                if (this.usages[this.usages.length - i2 - 1] != 0) {
                    this.memoryGraphics.setColor(memoryColor2);
                    this.memoryGraphics.drawLine(i2, this.memoryPanel.getHeight() - this.memUsages[this.memUsages.length - i2 - 1] - 1, i2, this.memoryPanel.getHeight() - 1);
                }
                ++i2;
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ResourceDisplay rd = new ResourceDisplay(null, "Intel(R) Xeon(R) CPU E5-1620 v4", "DDR4 SDRAM PC4-17000, ECC, registered");
            rd.showFrame();
        }
        catch (Exception e) {
            System.err.println("Error: ");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

