/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.lstmStuff.gameThingy;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.File;

public class TouhouWrapper {
    static Kernel32 kernel32 = Native.loadLibrary("kernel32", Kernel32.class);
    static User32 user32 = Native.loadLibrary("user32", User32.class);
    public static int PROCESS_VM_READ = 16;
    public static Pointer SCORE_ADDR_1 = new Pointer(20243156L);
    public static Pointer SCORE_ADDR_2 = new Pointer(20243252L);
    public static Pointer POINT_ADDR = new Pointer(6935734L);
    public static Rectangle gameWindow = new Rectangle(3, 26, 640, 480);
    public static Rectangle innerGameWindow = new Rectangle(35, 42, 384, 448);
    private File executable;
    private Robot robot;
    private IntByReference pid;
    private WinNT.HANDLE process;
    private Memory pointBuffer = new Memory(4L);
    private Memory scoreBuffer = new Memory(8L);
    private int lastScore = 0;

    public TouhouWrapper(File gameExecutable) {
        this.executable = gameExecutable;
    }

    public void start() throws Exception {
        Desktop.getDesktop().open(this.executable);
        Thread.sleep(6000L);
        this.pid = new IntByReference(0);
        WinDef.HWND window = User32.INSTANCE.FindWindow(null, "Touhou Youyoumu - Perfect Cherry Blossom v1.00b");
        user32.GetWindowThreadProcessId(window, this.pid);
        this.process = kernel32.OpenProcess(PROCESS_VM_READ, true, this.pid.getValue());
        user32.MoveWindow(window, 0, 0, 646, 509, true);
        this.robot = new Robot();
        System.out.println("[DEBUG] Process ID of game is " + Integer.toString(this.pid.getValue()));
    }

    public void stop() throws Exception {
        kernel32.CloseHandle(this.process);
    }

    public int getExtraLivesFromGameScreen(BufferedImage screen) {
        int lives = 0;
        int i = 0;
        while (i < 8) {
            if ((screen.getRGB(504 + 16 * i, 105) >> 16 & 0xFF) > 125) {
                ++lives;
            }
            ++i;
        }
        return lives;
    }

    public int getScore() throws Exception {
        kernel32.ReadProcessMemory(this.process, SCORE_ADDR_1, this.scoreBuffer, 8, this.pid);
        String score1 = this.scoreBuffer.getString(0L).trim();
        score1 = score1.substring(0, Math.min(8, score1.length()));
        kernel32.ReadProcessMemory(this.process, SCORE_ADDR_2, this.scoreBuffer, 8, this.pid);
        String score2 = this.scoreBuffer.getString(0L).trim();
        score2 = score2.substring(0, Math.min(8, score2.length()));
        int score = 0;
        if (!this.isValidNumberString(score1) && !this.isValidNumberString(score2)) {
            score = -1;
        } else if (!this.isValidNumberString(score1)) {
            score = Integer.parseInt(score2);
        } else if (!this.isValidNumberString(score2)) {
            score = Integer.parseInt(score1);
        } else {
            int s1 = Integer.parseInt(score1);
            int s2 = Integer.parseInt(score2);
            score = Math.max(s1, s2);
        }
        if (score < this.lastScore) {
            score = this.lastScore;
        }
        this.lastScore = score;
        return score;
    }

    public int getPoint() throws Exception {
        kernel32.ReadProcessMemory(this.process, POINT_ADDR, this.pointBuffer, 4, this.pid);
        String s = this.pointBuffer.getString(0L).trim();
        String[] s2 = s.split("/");
        if (!this.isValidNumberString(s2[0])) {
            return -1;
        }
        return Integer.parseInt(s2[0]);
    }

    public boolean isInStage() {
        kernel32.ReadProcessMemory(this.process, SCORE_ADDR_1, this.scoreBuffer, 8, this.pid);
        String info = this.scoreBuffer.getString(0L).trim();
        info = info.substring(0, Math.min(8, info.length()));
        return !info.equals("Stage Cl");
    }

    public BufferedImage getGameScreen() {
        return this.robot.createScreenCapture(gameWindow);
    }

    public BufferedImage getInnerGameScreen() {
        return this.robot.createScreenCapture(innerGameWindow);
    }

    private boolean isValidNumberString(String s) {
        if (s.isEmpty()) {
            return false;
        }
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != '0' && c != '1' && c != '2' && c != '3' && c != '4' && c != '5' && c != '6' && c != '7' && c != '8' && c != '9') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public File getGameExecutable() {
        return this.executable;
    }
}

