/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.lstmStuff.gameThingy;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.JPanel;

public class BreakoutGame
extends JPanel
implements KeyListener,
Runnable {
    private Rectangle paddle;
    private Rectangle[] bricks;
    private Rectangle ball;
    private Color[] colors = new Color[]{new Color(205, 72, 72), new Color(202, 108, 58), new Color(182, 124, 48), new Color(165, 163, 56), new Color(82, 164, 74), new Color(73, 84, 164)};
    private int width = 84;
    private int height = 84;
    private BufferedImage image;
    private Graphics2D g2;
    private Graphics g = null;
    private boolean running = false;
    private int score = 0;
    private int scale = 5;
    private Thread t = null;
    private boolean right = false;
    private boolean left = false;
    private int paddleSpeed = 2;
    private int ballSpeed = 1;
    private int ballDirX = 1;
    private int ballDirY = 1;
    private int lives = 0;
    private boolean paused = false;
    private boolean gameOver = false;
    private Random random = new Random();

    public BreakoutGame() {
        this.setPreferredSize(new Dimension(this.width * this.scale, this.height * this.scale));
        this.bricks = new Rectangle[126];
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 21) {
                this.bricks[i * 21 + j] = new Rectangle(j * 4, i * 2 + 4, 4, 2);
                ++j;
            }
            ++i;
        }
        this.paddle = new Rectangle(this.width / 2 - 7, this.height - 5, 15, 3);
        this.ball = new Rectangle(7, this.height - 10, 2, 2);
        this.setFocusable(true);
        this.requestFocus();
        this.setLayout(null);
        this.addKeyListener(this);
    }

    public void startGame() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void init() {
        this.image = new BufferedImage(this.width, this.height, 1);
        this.g2 = (Graphics2D)this.image.getGraphics();
        while (this.g == null) {
            this.g = this.getGraphics();
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.score = 0;
        this.lives = 3;
        this.gameOver = false;
        this.paused = false;
        this.left = false;
        this.right = false;
        this.ballDirX = 1 - this.random.nextInt(3);
        this.ballDirY = 1;
        this.bricks = new Rectangle[126];
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 21) {
                this.bricks[i * 21 + j] = new Rectangle(j * 4, i * 2 + 4, 4, 2);
                ++j;
            }
            ++i;
        }
        this.paddle = new Rectangle(this.width / 2 - 7, this.height - 5, 15, 3);
        this.ball = new Rectangle(this.width / 2, this.height - 10, 2, 2);
    }

    public void renderNextFrame() {
        if (!this.paused) {
            this.update();
        }
        this.draw();
    }

    public BufferedImage getCurrentFrame() {
        return this.image;
    }

    public void setRight(boolean right) {
        this.right = right;
    }

    public void setLeft(boolean left) {
        this.left = left;
    }

    public boolean getRight() {
        return this.right;
    }

    public boolean getLeft() {
        return this.left;
    }

    public int getScore() {
        return this.score;
    }

    public int getExtraLives() {
        return this.lives;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    @Override
    public void run() {
        this.init();
        this.running = true;
        long targetTime = 33333333L;
        long timer = System.nanoTime();
        long debugTimer = System.currentTimeMillis();
        int fps = 0;
        while (this.running) {
            if (System.nanoTime() - timer >= targetTime) {
                timer = System.nanoTime();
                if (!this.paused) {
                    this.update();
                }
                this.draw();
                ++fps;
            }
            if (this.gameOver) {
                this.running = false;
            }
            if (System.currentTimeMillis() - debugTimer >= 1000L) {
                debugTimer = System.currentTimeMillis();
                System.out.println("FPS: " + Integer.toString(fps));
                fps = 0;
            }
            try {
                Thread.sleep(2L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void draw() {
        this.g2.setColor(Color.BLACK);
        this.g2.fillRect(0, 0, this.width, this.height);
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 21) {
                if (this.bricks[i * 21 + j] != null) {
                    this.g2.setColor(this.colors[i]);
                    this.g2.fillRect(this.bricks[i * 21 + j].x, this.bricks[i * 21 + j].y, this.bricks[i * 21 + j].width, this.bricks[i * 21 + j].height);
                }
                ++j;
            }
            ++i;
        }
        this.g2.setColor(Color.ORANGE);
        this.g2.fillRect(this.paddle.x, this.paddle.y, this.paddle.width, this.paddle.height);
        this.g2.setColor(Color.WHITE);
        this.g2.fillRect(this.ball.x, this.ball.y, this.ball.width, this.ball.height);
        this.g.drawImage(this.paused ? BreakoutGame.grayscale(this.image) : this.image, 0, 0, this.width * this.scale, this.height * this.scale, this);
        this.g.setColor(Color.WHITE);
        this.g.drawString(Integer.toString(this.score), 0, 10);
        this.g.drawString(Integer.toString(this.lives), this.width * this.scale - 7, 10);
    }

    public static BufferedImage grayscale(BufferedImage in) {
        BufferedImage toReturn = new BufferedImage(in.getWidth(), in.getHeight(), 1);
        int i = 0;
        while (i < in.getWidth()) {
            int j = 0;
            while (j < in.getHeight()) {
                int gray;
                int argb = in.getRGB(i, j);
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb >> 0 & 0xFF;
                int rgb = gray = (int)((double)r / 3.0 + (double)g / 3.0 + (double)b / 3.0);
                rgb = (rgb << 8) + gray;
                rgb = (rgb << 8) + gray;
                toReturn.setRGB(i, j, rgb);
                ++j;
            }
            ++i;
        }
        return toReturn;
    }

    private void update() {
        if (this.left) {
            this.paddle.x -= this.paddleSpeed;
        }
        if (this.right) {
            this.paddle.x += this.paddleSpeed;
        }
        if (this.paddle.x < 0) {
            this.paddle.x = 0;
        }
        if (this.paddle.x > this.width - this.paddle.width) {
            this.paddle.x = this.width - this.paddle.width;
        }
        boolean allIsNull = true;
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 21) {
                if (this.bricks[i * 21 + j] != null) {
                    allIsNull = false;
                    if (this.ball.intersects(this.bricks[i * 21 + j])) {
                        if (this.bricks[i * 21 + j].contains(this.ball.x + this.ball.width + 1, this.ball.y)) {
                            this.ballDirX = -1;
                        } else if (this.bricks[i * 21 + j].contains(this.ball.x - 1, this.ball.y)) {
                            this.ballDirX = 1;
                        }
                        if (this.bricks[i * 21 + j].contains(this.ball.x, this.ball.y - 1)) {
                            this.ballDirY = 1;
                        } else if (this.bricks[i * 21 + j].contains(this.ball.x, this.ball.y + this.ball.height + 1)) {
                            this.ballDirY = -1;
                        }
                        this.bricks[i * 21 + j] = null;
                        ++this.score;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (allIsNull) {
            this.gameOver = true;
        }
        this.ball.x += this.ballDirX * this.ballSpeed;
        this.ball.y += this.ballDirY * this.ballSpeed;
        if (this.ball.y >= this.height) {
            this.score -= 5;
            --this.lives;
            if (this.lives == 0) {
                this.gameOver = true;
            }
            this.ball.x = this.paddle.x + 8;
            this.ball.y = this.height - 10;
            this.ballDirX = 1 - this.random.nextInt(3);
            this.ballDirY = 1;
        }
        if (this.ball.y + this.ball.height >= this.paddle.y - 2 && this.ball.intersects(this.paddle)) {
            this.ballDirY = -1;
            ++this.score;
        }
        if (this.ball.x <= 0) {
            this.ballDirX = 1;
        }
        if (this.ball.x >= this.width - this.ball.width) {
            this.ballDirX = -1;
        }
        if (this.ball.y <= 0) {
            this.ballDirY = 1;
        }
        if (this.ballDirX == 0 && (this.ballDirY == -1 || this.ballDirY == 1)) {
            this.ballDirY *= 2;
        }
        if (this.ballDirX != 0 && (this.ballDirY == -2 || this.ballDirY == 2)) {
            this.ballDirY /= 2;
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        if (arg0.getKeyCode() == 39) {
            this.right = true;
        }
        if (arg0.getKeyCode() == 37) {
            this.left = true;
        }
        if (arg0.getKeyCode() == 27) {
            this.paused = !this.paused;
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        if (arg0.getKeyCode() == 39) {
            this.right = false;
        }
        if (arg0.getKeyCode() == 37) {
            this.left = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

