/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.console.main;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Console
implements Runnable {
    private JFrame frame;
    private JPanel contentPane;
    private Font font = new Font("Courier", 0, 12);
    private Thread t = null;
    private boolean running = false;
    private BufferedImage image;
    private Graphics2D g;
    private Color backgroundColor = Color.BLACK;
    private Color textColor = Color.LIGHT_GRAY;
    private String[] text;
    private int cursorPos = 0;
    public static final int NONE = 0;
    public static final int AUTOMATIC = 1;
    public static final int CUSTOM = 2;

    public Console(boolean decorated, int width, int height, int closeOperation, String title, int locationX, int locationY, int fullscreenMode) {
        this.contentPane = new JPanel();
        this.frame = new JFrame(title);
        this.frame.setDefaultCloseOperation(closeOperation);
        this.frame.setResizable(false);
        this.frame.setUndecorated(!decorated);
        this.frame.setContentPane(this.contentPane);
        if (fullscreenMode == 1) {
            this.frame.setExtendedState(6);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.contentPane.setPreferredSize(screenSize);
            this.image = new BufferedImage((int)screenSize.getWidth(), (int)screenSize.getHeight(), 1);
        } else if (fullscreenMode == 2) {
            this.contentPane.setPreferredSize(new Dimension(width, height));
            this.image = new BufferedImage(width, height, 1);
            this.frame.setExtendedState(6);
        } else {
            this.contentPane.setPreferredSize(new Dimension(width, height));
            this.image = new BufferedImage(width, height, 1);
        }
        this.g = (Graphics2D)this.image.getGraphics();
        this.frame.setLocation(locationX, locationY);
        this.frame.pack();
        this.text = new String[(int)this.contentPane.getPreferredSize().getHeight() / this.g.getFontMetrics(this.font).getAscent() - 1];
        this.cursorPos = 0;
        this.t = new Thread(this);
    }

    public void print(String s) {
        if (s.contains("\n")) {
            String[] strings;
            String[] stringArray = strings = s.split("\n");
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String s2 = stringArray[n2];
                this.print(s2);
                ++n2;
            }
            return;
        }
        int textWidth = (int)this.font.getStringBounds(s, this.g.getFontRenderContext()).getWidth();
        if ((double)textWidth > this.contentPane.getPreferredSize().getWidth()) {
            int a = this.findLongestPossiblePartOfString(s);
            String s1 = s.substring(0, a);
            this.print(s1);
            s1 = s.substring(a, s.length());
            if (!s1.isEmpty()) {
                this.print(s1);
            }
            return;
        }
        this.printText(s);
    }

    private int findLongestPossiblePartOfString(String s) {
        boolean found = false;
        int i = s.length() - 1;
        while (!found) {
            String s2 = s.substring(0, i);
            if ((double)((int)this.font.getStringBounds(s2, this.g.getFontRenderContext()).getWidth()) < this.contentPane.getPreferredSize().getWidth()) {
                found = true;
                continue;
            }
            --i;
        }
        return i;
    }

    private void printText(String s) {
        if (this.cursorPos < this.text.length - 1) {
            this.text[this.cursorPos] = s;
            ++this.cursorPos;
        } else {
            int i = 1;
            while (i < this.text.length) {
                this.text[i - 1] = this.text[i];
                ++i;
            }
            this.text[this.text.length - 1] = s;
        }
    }

    public void clear() {
        this.cursorPos = 0;
        this.text = new String[this.text.length];
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public void setCursorPos(int c) {
        this.cursorPos = c;
    }

    public int getCursorPos() {
        return this.cursorPos;
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            this.g.setColor(this.backgroundColor);
            this.g.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
            this.g.setColor(this.textColor);
            int i = 0;
            while (i < this.text.length) {
                if (this.text[i] != null) {
                    this.g.drawString(this.text[i], 0, i * this.g.getFontMetrics(this.font).getAscent() + this.g.getFontMetrics(this.font).getAscent());
                }
                ++i;
            }
            Graphics panelGraphics = this.contentPane.getGraphics();
            if (panelGraphics != null) {
                panelGraphics.drawImage(this.image, 0, 0, this.contentPane);
            }
            if (this.frame.isVisible()) {
                panelGraphics.dispose();
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.frame.isVisible()) continue;
            this.hideFrame();
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void showFrame() {
        this.t.start();
        this.frame.setVisible(true);
    }

    public void hideFrame() {
        this.running = false;
        try {
            this.t.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.frame.setVisible(false);
    }

    public void addKeyListener(KeyListener kl) {
        this.frame.addKeyListener(kl);
    }
}

