/*
 * Decompiled with CFR 0.152.
 */
package model;

import autodiff.Graph;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matrix.Matrix;
import model.Model;
import nonlinearities.Nonlinearity;

public class RnnLayer
implements Model {
    int inputDimension;
    int outputDimension;
    Matrix W;
    Matrix b;
    Matrix context;
    Nonlinearity f;

    public RnnLayer(int inputDimension, int outputDimension, Nonlinearity hiddenUnit, double initParamsStdDev, Random rng) {
        this.inputDimension = inputDimension;
        this.outputDimension = outputDimension;
        this.f = hiddenUnit;
        this.W = Matrix.rand(outputDimension, inputDimension + outputDimension, initParamsStdDev, rng);
        this.b = new Matrix(outputDimension);
    }

    @Override
    public Matrix forward(Matrix input, Graph g) throws Exception {
        Matrix output;
        Matrix concat = g.concatVectors(input, this.context);
        Matrix sum = g.mul(this.W, concat);
        sum = g.add(sum, this.b);
        this.context = output = g.nonlin(this.f, sum);
        return output;
    }

    @Override
    public void resetState() {
        this.context = new Matrix(this.outputDimension);
    }

    @Override
    public List<Matrix> getParameters() {
        ArrayList<Matrix> result = new ArrayList<Matrix>();
        result.add(this.W);
        result.add(this.b);
        return result;
    }

    @Override
    public void saveState(FileOutputStream fos) throws Exception {
        for (Matrix W : this.getParameters()) {
            W.save(fos);
        }
        this.context.save(fos);
    }

    @Override
    public void loadState(FileInputStream fis) throws Exception {
        for (Matrix W : this.getParameters()) {
            W.load(fis);
        }
        this.context.load(fis);
    }
}

