/*
 * Decompiled with CFR 0.152.
 */
package model;

import autodiff.Graph;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import matrix.Matrix;
import model.Model;
import theGhastModding.utils.math.ByteConverters;

public class NeuralNetwork
implements Model {
    private List<Model> layers = new ArrayList<Model>();
    public int t = 0;

    public NeuralNetwork(List<Model> layers) {
        this.layers = layers;
    }

    public NeuralNetwork() {
    }

    public void addLayer(Model layer) {
        this.layers.add(layer);
    }

    @Override
    public Matrix forward(Matrix input, Graph g) throws Exception {
        Matrix prev = input;
        for (Model layer : this.layers) {
            prev = layer.forward(prev, g);
        }
        return prev;
    }

    @Override
    public void resetState() {
        for (Model layer : this.layers) {
            layer.resetState();
        }
    }

    @Override
    public List<Matrix> getParameters() {
        ArrayList<Matrix> result = new ArrayList<Matrix>();
        for (Model layer : this.layers) {
            result.addAll(layer.getParameters());
        }
        return result;
    }

    @Override
    public void saveState(FileOutputStream fos) throws Exception {
        fos.write(ByteConverters.intToBytes(this.t));
        for (Model layer : this.layers) {
            layer.saveState(fos);
        }
    }

    @Override
    public void loadState(FileInputStream fis) throws Exception {
        byte[] intBuffer = new byte[4];
        fis.read(intBuffer);
        this.t = ByteConverters.bytesToInt(intBuffer);
        for (Model layer : this.layers) {
            layer.loadState(fis);
        }
    }
}

