/*
 * Decompiled with CFR 0.152.
 */
package model;

import autodiff.Graph;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matrix.Matrix;
import model.LstmLayer;
import model.Model;
import theGhastModding.utils.math.ByteConverters;

public class MultipathLayer
implements Model {
    private LstmLayer[] layers;

    public MultipathLayer(int inputDimension, int outputDimension, int paths, double initParamsStdDev, Random rng) {
        this.layers = new LstmLayer[paths];
        int i = 0;
        while (i < paths) {
            this.layers[i] = new LstmLayer(inputDimension, outputDimension, initParamsStdDev, rng);
            ++i;
        }
    }

    @Override
    public Matrix forward(Matrix input, Graph g) throws Exception {
        Matrix[] allOutputs = new Matrix[this.layers.length];
        Thread[] ts = new Thread[this.layers.length];
        ForwarderThread[] fts = new ForwarderThread[this.layers.length];
        int i = 0;
        while (i < this.layers.length) {
            fts[i] = new ForwarderThread(input, g, i);
            ts[i] = new Thread(fts[i]);
            ++i;
        }
        i = 0;
        while (i < this.layers.length) {
            ts[i].start();
            ++i;
        }
        i = 0;
        while (i < this.layers.length) {
            try {
                ts[i].join();
                if (fts[i].e != null) {
                    throw fts[i].e;
                }
                g.addBackprops(fts[i].g.getBackprops());
                allOutputs[i] = fts[i].output;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        Matrix finalOutput = allOutputs[0];
        int i2 = 1;
        while (i2 < allOutputs.length) {
            finalOutput = g.add(finalOutput, allOutputs[i2]);
            ++i2;
        }
        return finalOutput;
    }

    @Override
    public void resetState() {
        LstmLayer[] lstmLayerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            LstmLayer l = lstmLayerArray[n2];
            l.resetState();
            ++n2;
        }
    }

    @Override
    public List<Matrix> getParameters() {
        ArrayList<Matrix> toReturn = new ArrayList<Matrix>();
        LstmLayer[] lstmLayerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            LstmLayer l = lstmLayerArray[n2];
            toReturn.addAll(l.getParameters());
            ++n2;
        }
        return toReturn;
    }

    @Override
    public void saveState(FileOutputStream fos) throws Exception {
        fos.write(ByteConverters.intToBytes(this.layers.length));
        LstmLayer[] lstmLayerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            LstmLayer l = lstmLayerArray[n2];
            l.saveState(fos);
            ++n2;
        }
    }

    @Override
    public void loadState(FileInputStream fis) throws Exception {
    }

    private class ForwarderThread
    implements Runnable {
        private Matrix m;
        private Graph g;
        public Matrix output;
        private int indx;
        public Exception e = null;

        public ForwarderThread(Matrix m, Graph g, int indx) throws Exception {
            this.m = m;
            this.g = new Graph(g.applyBackprop());
            this.indx = indx;
            this.e = null;
        }

        @Override
        public void run() {
            try {
                this.output = MultipathLayer.this.layers[this.indx].forward(this.m, this.g);
            }
            catch (Exception e) {
                this.e = e;
            }
        }
    }
}

