/*
 * Decompiled with CFR 0.152.
 */
package model;

import autodiff.Graph;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matrix.Matrix;
import model.Model;
import nonlinearities.Nonlinearity;
import nonlinearities.SigmoidUnit;
import nonlinearities.TanhUnit;

public class GruLayer
implements Model {
    int inputDimension;
    int outputDimension;
    Matrix IHmix;
    Matrix HHmix;
    Matrix Bmix;
    Matrix IHnew;
    Matrix HHnew;
    Matrix Bnew;
    Matrix IHreset;
    Matrix HHreset;
    Matrix Breset;
    Matrix context;
    Nonlinearity fMix = new SigmoidUnit();
    Nonlinearity fReset = new SigmoidUnit();
    Nonlinearity fNew = new TanhUnit();

    public GruLayer(int inputDimension, int outputDimension, double initParamsStdDev, Random rng) {
        this.inputDimension = inputDimension;
        this.outputDimension = outputDimension;
        this.IHmix = Matrix.rand(outputDimension, inputDimension, initParamsStdDev, rng);
        this.HHmix = Matrix.rand(outputDimension, outputDimension, initParamsStdDev, rng);
        this.Bmix = new Matrix(outputDimension);
        this.IHnew = Matrix.rand(outputDimension, inputDimension, initParamsStdDev, rng);
        this.HHnew = Matrix.rand(outputDimension, outputDimension, initParamsStdDev, rng);
        this.Bnew = new Matrix(outputDimension);
        this.IHreset = Matrix.rand(outputDimension, inputDimension, initParamsStdDev, rng);
        this.HHreset = Matrix.rand(outputDimension, outputDimension, initParamsStdDev, rng);
        this.Breset = new Matrix(outputDimension);
    }

    @Override
    public Matrix forward(Matrix input, Graph g) throws Exception {
        Matrix output;
        Matrix sum0 = g.mul(this.IHmix, input);
        Matrix sum1 = g.mul(this.HHmix, this.context);
        Matrix actMix = g.nonlin(this.fMix, g.add(g.add(sum0, sum1), this.Bmix));
        Matrix sum2 = g.mul(this.IHreset, input);
        Matrix sum3 = g.mul(this.HHreset, this.context);
        Matrix actReset = g.nonlin(this.fReset, g.add(g.add(sum2, sum3), this.Breset));
        Matrix sum4 = g.mul(this.IHnew, input);
        Matrix gatedContext = g.elmul(actReset, this.context);
        Matrix sum5 = g.mul(this.HHnew, gatedContext);
        Matrix actNewPlusGatedContext = g.nonlin(this.fNew, g.add(g.add(sum4, sum5), this.Bnew));
        Matrix memvals = g.elmul(actMix, this.context);
        Matrix newvals = g.elmul(g.oneMinus(actMix), actNewPlusGatedContext);
        this.context = output = g.add(memvals, newvals);
        return output;
    }

    @Override
    public void resetState() {
        this.context = new Matrix(this.outputDimension);
    }

    @Override
    public List<Matrix> getParameters() {
        ArrayList<Matrix> result = new ArrayList<Matrix>();
        result.add(this.IHmix);
        result.add(this.HHmix);
        result.add(this.Bmix);
        result.add(this.IHnew);
        result.add(this.HHnew);
        result.add(this.Bnew);
        result.add(this.IHreset);
        result.add(this.HHreset);
        result.add(this.Breset);
        return result;
    }

    @Override
    public void saveState(FileOutputStream fos) throws Exception {
        for (Matrix W : this.getParameters()) {
            W.save(fos);
        }
        this.context.save(fos);
    }

    @Override
    public void loadState(FileInputStream fis) throws Exception {
        for (Matrix W : this.getParameters()) {
            W.load(fis);
        }
        this.context.load(fis);
    }
}

