/*
 * Decompiled with CFR 0.152.
 */
package model;

import autodiff.Graph;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matrix.Matrix;
import model.Model;
import nonlinearities.Nonlinearity;

public class FeedForwardLayer
implements Model {
    Matrix W;
    Matrix b;
    Nonlinearity f;

    public FeedForwardLayer(int inputDimension, int outputDimension, Nonlinearity f, double initParamsStdDev, Random rng) {
        this.W = Matrix.rand(outputDimension, inputDimension, initParamsStdDev, rng);
        this.b = new Matrix(outputDimension);
        this.f = f;
    }

    @Override
    public Matrix forward(Matrix input, Graph g) throws Exception {
        Matrix sum = g.add(g.mul(this.W, input), this.b);
        Matrix out = g.nonlin(this.f, sum);
        return out;
    }

    @Override
    public void resetState() {
    }

    @Override
    public List<Matrix> getParameters() {
        ArrayList<Matrix> result = new ArrayList<Matrix>();
        result.add(this.W);
        result.add(this.b);
        return result;
    }

    @Override
    public void saveState(FileOutputStream fos) throws Exception {
        this.W.save(fos);
        this.b.save(fos);
    }

    @Override
    public void loadState(FileInputStream fis) throws Exception {
        this.W.load(fis);
        this.b.load(fis);
    }
}

