/*
 * Decompiled with CFR 0.152.
 */
package model;

import autodiff.Graph;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import matrix.Matrix;
import matrix.Tensor;
import model.TensorLayer;

public class ConvDebug
implements TensorLayer {
    private boolean crash = false;
    private boolean forward;

    public ConvDebug(boolean crash, boolean forward) {
        this.crash = crash;
        this.forward = forward;
    }

    @Override
    public Tensor forward(final Tensor input, Graph g) throws Exception {
        if (this.forward) {
            int i = 0;
            while (i < input.getDepth()) {
                System.out.println(String.valueOf(input.getMatrixAt(i).toString()) + "\n");
                ++i;
            }
            if (this.crash) {
                System.exit(0);
            }
        }
        if (g.applyBackprop()) {
            g.addBackprop(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < input.getDepth()) {
                        System.out.println(String.valueOf(input.getMatrixAt(i).dwToString()) + "\n");
                        ++i;
                    }
                    if (ConvDebug.this.crash) {
                        System.exit(0);
                    }
                }
            });
        }
        return input;
    }

    @Override
    public void resetState() {
    }

    @Override
    public List<Matrix> getParameters() {
        return null;
    }

    @Override
    public void saveState(FileOutputStream fos) throws Exception {
    }

    @Override
    public void loadState(FileInputStream fis) throws Exception {
    }
}

