/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import matrix.Matrix;
import theGhastModding.utils.math.ByteConverters;

public class Tensor
implements Serializable {
    private Matrix[] matrices;
    private int width;
    private int height;
    private int depth;

    public Tensor(int width, int height, int depth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.matrices = new Matrix[depth];
        int i = 0;
        while (i < depth) {
            this.matrices[i] = new Matrix(height, width);
            ++i;
        }
    }

    public Matrix[] getMatrices() {
        return this.matrices;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public Matrix getMatrixAt(int z) {
        if (z < 0 || z >= this.matrices.length) {
            return null;
        }
        return this.matrices[z];
    }

    public void setMatrixAt(int z, Matrix m) {
        if (z < 0 || z >= this.matrices.length) {
            return;
        }
        this.matrices[z] = m;
    }

    public double getValueAt(int x, int y, int z) {
        return this.matrices[z].getW(y, x);
    }

    public void setValueAt(int x, int y, int z, double val) {
        this.matrices[z].setW(y, x, val);
    }

    public void save(FileOutputStream fos) throws Exception {
        fos.write(ByteConverters.intToBytes(this.width));
        fos.write(ByteConverters.intToBytes(this.height));
        fos.write(ByteConverters.intToBytes(this.depth));
        Matrix[] matrixArray = this.matrices;
        int n = this.matrices.length;
        int n2 = 0;
        while (n2 < n) {
            Matrix m = matrixArray[n2];
            m.save(fos);
            ++n2;
        }
    }

    public void load(FileInputStream fis) throws Exception {
        byte[] intBuffer = new byte[4];
        fis.read(intBuffer);
        this.width = ByteConverters.bytesToInt(intBuffer);
        fis.read(intBuffer);
        this.height = ByteConverters.bytesToInt(intBuffer);
        fis.read(intBuffer);
        this.depth = ByteConverters.bytesToInt(intBuffer);
        this.matrices = new Matrix[this.depth];
        int i = 0;
        while (i < this.matrices.length) {
            this.matrices[i] = new Matrix(this.height, this.width);
            this.matrices[i].load(fis);
            ++i;
        }
    }
}

