/*
 * Decompiled with CFR 0.152.
 */
package loss;

import loss.Loss;
import matrix.Matrix;

public class LossMeanSquaredError
implements Loss {
    private static final long serialVersionUID = 1L;

    @Override
    public void backward(Matrix actualOutput, Matrix targetOutput) throws Exception {
        int i = 0;
        while (i < targetOutput.w.length) {
            double errDelta = actualOutput.w[i] - targetOutput.w[i];
            int n = i++;
            actualOutput.dw[n] = actualOutput.dw[n] + errDelta;
        }
    }

    @Override
    public double measure(Matrix actualOutput, Matrix targetOutput) throws Exception {
        double sum_sq = 0.0;
        int i = 0;
        while (i < targetOutput.cols) {
            int j = 0;
            while (j < targetOutput.rows) {
                double a = targetOutput.getW(j, i) - actualOutput.getW(j, i);
                sum_sq += 0.5 * a * a;
                ++j;
            }
            ++i;
        }
        return sum_sq * (1.0 / (double)targetOutput.w.length);
    }
}

