/*
 * Decompiled with CFR 0.152.
 */
package datasets;

import datastructs.DataSequence;
import datastructs.DataSet;
import datastructs.DataStep;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import loss.LossArgMax;
import loss.LossSoftmax;
import model.Model;
import nonlinearities.LinearUnit;
import nonlinearities.Nonlinearity;
import theGhastModding.console.main.Console;

public class bAbI
extends DataSet {
    public static final String[] TASK_NAMES = new String[]{"Single Supporting Fact", "Two Supporting Facts", "Three Supporting Facts", "Two Arg. Relations", "Three Arg. Relations", "Yes/No Questions", "Counting", "Lists/Sets", "Simple Negation", "Indefinite Knowledge", "Basic Coreference", "Conjunction", "Compound Coreference", "Time Reasoning", "Basic Deduction", "Basic Induction", "Positional Reasoning", "Size Reasoning", "Path Finding", "Agent's Motivations"};
    List<String> inputVocab = new ArrayList<String>();
    List<String> outputVocab = new ArrayList<String>();

    public bAbI(int setId, int totalExamples, boolean onlySupportingFacts, Random rng) throws Exception {
        File folder = new File("datasets/bAbI/en/");
        ArrayList<String> fileNamesTrain = new ArrayList<String>();
        ArrayList<String> fileNamesTest = new ArrayList<String>();
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileEntry = fileArray[n2];
            String path = fileEntry.getPath();
            if (path.contains("train")) {
                if (path.contains("qa" + setId + "_")) {
                    fileNamesTrain.add(path);
                }
            } else if (path.contains("test")) {
                if (path.contains("qa" + setId + "_")) {
                    fileNamesTest.add(path);
                }
            } else {
                throw new Exception("Unknown file type");
            }
            ++n2;
        }
        List<Story> storiesTrain = this.getStories(fileNamesTrain, onlySupportingFacts);
        List<Story> storiesTest = this.getStories(fileNamesTest, onlySupportingFacts);
        while (storiesTrain.size() > totalExamples) {
            storiesTrain.remove(rng.nextInt(storiesTrain.size()));
        }
        while (storiesTest.size() > totalExamples) {
            storiesTest.remove(rng.nextInt(storiesTest.size()));
        }
        this.configureVocab(storiesTrain, storiesTest);
        this.training = this.getSequences(storiesTrain);
        this.testing = this.getSequences(storiesTest);
        this.validation = null;
        this.lossTraining = new LossSoftmax();
        this.lossReporting = new LossArgMax();
        this.inputDimension = ((DataSequence)this.training.get((int)0)).steps.get((int)0).input.w.length;
        int loc = 0;
        while (((DataSequence)this.training.get((int)0)).steps.get((int)loc).targetOutput == null) {
            ++loc;
        }
        this.outputDimension = ((DataSequence)this.training.get((int)0)).steps.get((int)loc).targetOutput.w.length;
    }

    List<Story> getStories(List<String> fileNames, boolean onlySupportingFacts) throws Exception {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (String fileName : fileNames) {
            File file = new File(fileName);
            List<String> lines = Files.readAllLines(file.toPath(), Charset.defaultCharset());
            for (String line : lines) {
                statements.add(new Statement(line));
            }
        }
        ArrayList<Story> stories = new ArrayList<Story>();
        int prevNum = 0;
        ArrayList<Statement> storyList = new ArrayList<Statement>();
        boolean containsQuestion = false;
        int errors = 0;
        for (Statement statement : statements) {
            if (statement.lineNum < prevNum) {
                if (!containsQuestion) {
                    ++errors;
                } else {
                    Story story = new Story(storyList, onlySupportingFacts);
                    stories.add(story);
                }
                containsQuestion = false;
                storyList = new ArrayList();
            }
            if (!statement.isFact) {
                containsQuestion = true;
            }
            storyList.add(statement);
            prevNum = statement.lineNum;
        }
        Story story = new Story(storyList, onlySupportingFacts);
        stories.add(story);
        if (errors > 0) {
            System.out.println("WARNING: " + errors + " INCORRECT STORIES REMOVED.");
        }
        return stories;
    }

    private void configureVocab(List<Story> storiesTrain, List<Story> storiesTest) {
        HashSet<String> inputVocabSet = new HashSet<String>();
        HashSet<String> outputVocabSet = new HashSet<String>();
        ArrayList<Story> allStories = new ArrayList<Story>();
        allStories.addAll(storiesTrain);
        allStories.addAll(storiesTest);
        for (Story story : allStories) {
            for (Statement statement : story.statements) {
                if (statement.isFact) {
                    for (String word : statement.fact) {
                        inputVocabSet.add(word);
                    }
                    continue;
                }
                for (String word : statement.question) {
                    inputVocabSet.add(word);
                }
                outputVocabSet.add(statement.answer);
            }
        }
        for (String word : inputVocabSet) {
            this.inputVocab.add(word);
        }
        for (String word : outputVocabSet) {
            this.outputVocab.add(word);
        }
        Collections.sort(this.inputVocab);
        Collections.sort(this.outputVocab);
        System.out.println("Possible answers: ");
        int i = 0;
        while (i < this.outputVocab.size()) {
            System.out.println("\t[" + i + "]: " + this.outputVocab.get(i));
            ++i;
        }
    }

    private List<DataSequence> getSequences(List<Story> stories) {
        int inputDimension = this.inputVocab.size();
        int outputDimension = this.outputVocab.size();
        ArrayList<DataSequence> sequences = new ArrayList<DataSequence>();
        for (Story story : stories) {
            ArrayList<DataStep> steps = new ArrayList<DataStep>();
            for (Statement statement : story.statements) {
                int i;
                double[] input;
                if (statement.isFact) {
                    int w = 0;
                    while (w < statement.fact.size()) {
                        input = new double[inputDimension];
                        i = 0;
                        while (i < inputDimension) {
                            if (statement.fact.get(w).equals(this.inputVocab.get(i))) {
                                input[i] = 1.0;
                                break;
                            }
                            ++i;
                        }
                        steps.add(new DataStep(input, null));
                        ++w;
                    }
                    continue;
                }
                int w = 0;
                while (w < statement.question.size()) {
                    input = new double[inputDimension];
                    double[] targetOutput = null;
                    int i2 = 0;
                    while (i2 < inputDimension) {
                        if (statement.question.get(w).equals(this.inputVocab.get(i2))) {
                            input[i2] = 1.0;
                            break;
                        }
                        ++i2;
                    }
                    steps.add(new DataStep(input, targetOutput));
                    ++w;
                }
                double[] input2 = new double[inputDimension];
                double[] targetOutput = new double[outputDimension];
                i = 0;
                while (i < outputDimension) {
                    if (statement.answer.equals(this.outputVocab.get(i))) {
                        targetOutput[i] = 1.0;
                        break;
                    }
                    ++i;
                }
                steps.add(new DataStep(input2, targetOutput));
            }
            sequences.add(new DataSequence(steps));
        }
        return sequences;
    }

    @Override
    public void DisplayReport(Model model, Random rng, Console c) throws Exception {
    }

    @Override
    public Nonlinearity getModelOutputUnitToUse() {
        return new LinearUnit();
    }

    class Statement {
        boolean isFact = true;
        List<String> fact = new ArrayList<String>();
        List<String> question = new ArrayList<String>();
        String answer;
        List<Integer> supportingFacts = new ArrayList<Integer>();
        int lineNum;

        public Statement(String line) {
            String[] parts = line.split("\t");
            if (parts.length > 1) {
                String[] words = parts[0].replace("?", " ?").split(" ");
                this.lineNum = Integer.parseInt(words[0]);
                int i = 1;
                while (i < words.length) {
                    this.question.add(words[i].toLowerCase());
                    ++i;
                }
                this.answer = parts[1].toLowerCase();
                String[] facts = parts[2].split(" ");
                int i2 = 0;
                while (i2 < facts.length) {
                    this.supportingFacts.add(Integer.parseInt(facts[i2]));
                    ++i2;
                }
                this.isFact = false;
            } else {
                String[] words = line.replace(".", " .").split(" ");
                this.lineNum = Integer.parseInt(words[0]);
                int i = 1;
                while (i < words.length) {
                    this.fact.add(words[i].toLowerCase());
                    ++i;
                }
                this.isFact = true;
            }
        }

        public String toString() {
            String result = String.valueOf(this.lineNum);
            if (this.isFact) {
                for (String word : this.fact) {
                    result = String.valueOf(result) + " " + word;
                }
            } else {
                for (String word : this.question) {
                    result = String.valueOf(result) + " " + word;
                }
                result = String.valueOf(result) + " -> " + this.answer;
                for (Integer i : this.supportingFacts) {
                    result = String.valueOf(result) + " " + i;
                }
            }
            return result;
        }
    }

    class Story {
        List<Statement> statements;

        public Story(List<Statement> statements, boolean onlySupportingFacts) {
            if (onlySupportingFacts) {
                HashSet<Integer> supportingFactsAndQuestions = new HashSet<Integer>();
                for (Statement statement : statements) {
                    if (statement.isFact) continue;
                    supportingFactsAndQuestions.add(statement.lineNum);
                    supportingFactsAndQuestions.addAll(statement.supportingFacts);
                }
                ArrayList<Statement> trimmed = new ArrayList<Statement>();
                for (Statement statement : statements) {
                    if (!supportingFactsAndQuestions.contains(statement.lineNum)) continue;
                    trimmed.add(statement);
                }
                this.statements = trimmed;
            } else {
                this.statements = statements;
            }
        }

        public String toString() {
            String result = "";
            for (Statement statement : this.statements) {
                result = String.valueOf(result) + statement.toString() + "\n";
            }
            return result;
        }
    }
}

