/*
 * Decompiled with CFR 0.152.
 */
package datasets;

import autodiff.Graph;
import datastructs.DataSequence;
import datastructs.DataSet;
import datastructs.DataStep;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import loss.LossSoftmax;
import matrix.Matrix;
import model.Model;
import nonlinearities.LinearUnit;
import nonlinearities.Nonlinearity;
import theGhastModding.console.main.Console;
import util.Util;

public class TextGenerationUnbroken
extends DataSet {
    private static final long serialVersionUID = 1L;
    public static int reportSequenceLength = 100;
    public static boolean reportPerplexity = true;
    private Map<String, Integer> charToIndex = new HashMap<String, Integer>();
    private Map<Integer, String> indexToChar = new HashMap<Integer, String>();
    private int dimension;

    public String generateText(Model model, int steps, boolean argmax, double temperature, Random rng) throws Exception {
        Matrix start = new Matrix(this.dimension);
        start.w = new double[this.dimension];
        start.w[this.charToIndex.get((Object)"a").intValue()] = 1.0;
        model.resetState();
        Graph g = new Graph(false);
        Matrix input = start.clone();
        String result = "";
        int s = 0;
        while (s < steps) {
            Matrix logprobs = model.forward(input, g);
            Matrix probs = LossSoftmax.getSoftmaxProbs(logprobs, temperature);
            int indxChosen = -1;
            if (argmax) {
                double high = Double.NEGATIVE_INFINITY;
                int i = 0;
                while (i < probs.w.length) {
                    if (probs.w[i] > high) {
                        high = probs.w[i];
                        indxChosen = i;
                        if (indxChosen == 0) {
                            return result;
                        }
                    }
                    ++i;
                }
            } else {
                indxChosen = Util.pickIndexFromRandomVector(probs, rng);
                if (indxChosen == 0) {
                    return result;
                }
            }
            String ch = this.indexToChar.get(indxChosen);
            result = String.valueOf(result) + ch;
            int i = 0;
            while (i < input.w.length) {
                input.w[i] = 0.0;
                ++i;
            }
            input.w[indxChosen] = 1.0;
            ++s;
        }
        return result;
    }

    public TextGenerationUnbroken(String path, int totalSequences, int sequenceMinLength, int sequenceMaxLength, Random rng) throws Exception {
        System.out.println("Text generation task");
        System.out.println("loading " + path + "...");
        File file = new File(path);
        List<String> lines_ = Files.readAllLines(file.toPath(), Charset.defaultCharset());
        String text = "";
        int i = 0;
        while (i < lines_.size()) {
            if (i % 1000 == 0) {
                System.out.println(i / 1000);
                System.gc();
            }
            text = String.valueOf(text) + lines_.get(i) + "\n";
            ++i;
        }
        lines_.clear();
        lines_ = null;
        System.gc();
        HashSet<String> chars = new HashSet<String>();
        int id = 0;
        this.charToIndex.put("[START/END]", id);
        this.indexToChar.put(id, "[START/END]");
        ++id;
        System.out.println("Characters:");
        System.out.print("\t");
        int i2 = 0;
        while (i2 < text.length()) {
            String ch = String.valueOf(text.charAt(i2));
            if (!chars.contains(ch)) {
                if (ch.equals("\n")) {
                    System.out.print("\\n");
                } else {
                    System.out.print(ch);
                }
                chars.add(ch);
                this.charToIndex.put(ch, id);
                this.indexToChar.put(id, ch);
                ++id;
            }
            ++i2;
        }
        System.out.println("");
        this.dimension = chars.size() + 1;
        double[] vecStartEnd = new double[this.dimension];
        vecStartEnd[0] = 1.0;
        ArrayList<DataSequence> sequences = new ArrayList<DataSequence>();
        int s = 0;
        while (s < totalSequences) {
            ArrayList<double[]> vecs = new ArrayList<double[]>();
            vecs.add(vecStartEnd);
            int len = rng.nextInt(sequenceMaxLength - sequenceMinLength + 1) + sequenceMinLength;
            int start = rng.nextInt(text.length() - len);
            int i3 = 0;
            while (i3 < len) {
                String ch = String.valueOf(text.charAt(i3 + start));
                int index = this.charToIndex.get(ch);
                double[] vec = new double[this.dimension];
                vec[index] = 1.0;
                vecs.add(vec);
                ++i3;
            }
            vecs.add(vecStartEnd);
            DataSequence sequence = new DataSequence();
            int i4 = 0;
            while (i4 < vecs.size() - 1) {
                sequence.steps.add(new DataStep((double[])vecs.get(i4), (double[])vecs.get(i4 + 1)));
                ++i4;
            }
            sequences.add(sequence);
            ++s;
        }
        System.out.println("Total unique chars = " + chars.size());
        this.training = sequences;
        this.lossTraining = new LossSoftmax();
        this.lossReporting = new LossSoftmax();
        this.inputDimension = ((DataSequence)sequences.get((int)0)).steps.get((int)0).input.w.length;
        int loc = 0;
        while (((DataSequence)sequences.get((int)0)).steps.get((int)loc).targetOutput == null) {
            ++loc;
        }
        this.outputDimension = ((DataSequence)sequences.get((int)0)).steps.get((int)loc).targetOutput.w.length;
    }

    @Override
    public void DisplayReport(Model model, Random rng, Console c) throws Exception {
        double[] temperatures;
        System.out.println("========================================");
        System.out.println("REPORT:");
        if (reportPerplexity) {
            System.out.println("\ncalculating perplexity over entire data set...");
            double perplexity = LossSoftmax.calculateMedianPerplexity(model, this.training);
            System.out.println("\nMedian Perplexity = " + String.format("%.4f", perplexity));
        }
        double[] dArray = temperatures = new double[]{1.0, 0.75, 0.5, 0.25, 0.1};
        int n = temperatures.length;
        int n2 = 0;
        while (n2 < n) {
            double temperature = dArray[n2];
            System.out.println("\nTemperature " + temperature + " prediction:");
            String guess = this.generateText(model, reportSequenceLength, false, temperature, rng);
            System.out.println("\t\"..." + guess + "...\"");
            ++n2;
        }
        System.out.println("\nArgmax prediction:");
        String guess = this.generateText(model, reportSequenceLength, true, 1.0, rng);
        System.out.println("\t\"..." + guess + "...\"");
        System.out.println("========================================");
    }

    @Override
    public Nonlinearity getModelOutputUnitToUse() {
        return new LinearUnit();
    }
}

