/*
 * Decompiled with CFR 0.152.
 */
package datasets;

import autodiff.Graph;
import datastructs.DataSequence;
import datastructs.DataSet;
import datastructs.DataStep;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import loss.LossSoftmax;
import matrix.Matrix;
import model.Model;
import nonlinearities.LinearUnit;
import nonlinearities.Nonlinearity;
import theGhastModding.console.main.Console;
import util.Util;

public class TextGenerationMultifile
extends DataSet {
    public static int reportSequenceLength = 100;
    public static boolean reportPerplexity = true;
    private static Map<String, Integer> charToIndex = new HashMap<String, Integer>();
    private static Map<Integer, String> indexToChar = new HashMap<Integer, String>();
    private static int dimension;
    private static double[] vecStartEnd;
    private static final int START_END_TOKEN_INDEX = 0;

    public void disposeOff() {
        this.training.clear();
        this.training = null;
    }

    public static String generateText(Model model, int steps, boolean argmax, double temperature, Random rng) throws Exception {
        Matrix start = new Matrix(dimension);
        model.resetState();
        Graph g = new Graph(false);
        Matrix input = start.clone();
        String result = "";
        int s = 0;
        while (s < steps) {
            Matrix logprobs = model.forward(input, g);
            Matrix probs = LossSoftmax.getSoftmaxProbs(logprobs, temperature);
            int indxChosen = -1;
            if (argmax) {
                double high = Double.NEGATIVE_INFINITY;
                int i = 0;
                while (i < probs.w.length) {
                    if (probs.w[i] > high) {
                        high = probs.w[i];
                        indxChosen = i;
                    }
                    ++i;
                }
            } else {
                indxChosen = Util.pickIndexFromRandomVector(probs, rng);
            }
            if (indxChosen == 0) {
                return result;
            }
            String ch = indexToChar.get(indxChosen);
            result = String.valueOf(result) + ch;
            int i = 0;
            while (i < input.w.length) {
                input.w[i] = 0.0;
                ++i;
            }
            input.w[indxChosen] = 1.0;
            ++s;
        }
        return result;
    }

    public static String sequenceToSentence(DataSequence sequence) {
        String result = "\"";
        int s = 0;
        while (s < sequence.steps.size() - 1) {
            DataStep step = sequence.steps.get(s);
            int index = -1;
            int i = 0;
            while (i < step.targetOutput.w.length) {
                if (step.targetOutput.w[i] == 1.0) {
                    index = i;
                    break;
                }
                ++i;
            }
            String ch = indexToChar.get(index);
            result = String.valueOf(result) + ch;
            ++s;
        }
        result = String.valueOf(result) + "\"\n";
        return result;
    }

    public TextGenerationMultifile(List<String> paths) throws Exception {
        System.out.println("Text generation task");
        System.out.println("loading " + Integer.toString(paths.size()) + " files...");
        ArrayList<String> lines = new ArrayList<String>();
        String text = "";
        for (String path : paths) {
            File file = new File(path);
            List<String> lines_ = Files.readAllLines(file.toPath(), Charset.defaultCharset());
            text = "";
            Iterator<String> iterator = lines_.iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                text = String.valueOf(text) + s + "\n";
            }
            lines.add(text);
        }
        HashSet<String> chars = new HashSet<String>();
        int id = 0;
        charToIndex.put("[START/END]", id);
        indexToChar.put(id, "[START/END]");
        ++id;
        System.out.println("Characters:");
        System.out.print("\t");
        for (String line : lines) {
            int i = 0;
            while (i < line.length()) {
                String ch = String.valueOf(line.charAt(i));
                if (!chars.contains(ch)) {
                    System.out.print(ch);
                    chars.add(ch);
                    charToIndex.put(ch, id);
                    indexToChar.put(id, ch);
                    ++id;
                }
                ++i;
            }
        }
        dimension = chars.size() + 1;
        vecStartEnd = new double[dimension];
        TextGenerationMultifile.vecStartEnd[0] = 1.0;
        ArrayList<DataSequence> sequences = new ArrayList<DataSequence>();
        int size = 0;
        for (String line : lines) {
            ArrayList<double[]> vecs = new ArrayList<double[]>();
            vecs.add(vecStartEnd);
            int i = 0;
            while (i < line.length()) {
                String ch = String.valueOf(line.charAt(i));
                int index = charToIndex.get(ch);
                double[] vec = new double[dimension];
                vec[index] = 1.0;
                vecs.add(vec);
                ++i;
            }
            vecs.add(vecStartEnd);
            DataSequence sequence = new DataSequence();
            int i2 = 0;
            while (i2 < vecs.size() - 1) {
                sequence.steps.add(new DataStep((double[])vecs.get(i2), (double[])vecs.get(i2 + 1)));
                ++size;
                ++i2;
            }
            sequences.add(sequence);
        }
        System.out.println("Total unique chars = " + chars.size());
        System.out.println(String.valueOf(size) + " steps in training set.");
        this.training = sequences;
        this.lossTraining = new LossSoftmax();
        this.lossReporting = new LossSoftmax();
        this.inputDimension = ((DataSequence)sequences.get((int)0)).steps.get((int)0).input.w.length;
        int loc = 0;
        while (((DataSequence)sequences.get((int)0)).steps.get((int)loc).targetOutput == null) {
            ++loc;
        }
        this.outputDimension = ((DataSequence)sequences.get((int)0)).steps.get((int)loc).targetOutput.w.length;
    }

    @Override
    public void DisplayReport(Model model, Random rng, Console c) throws Exception {
        double[] temperatures;
        System.out.println("========================================");
        System.out.println("REPORT:");
        if (reportPerplexity) {
            System.out.println("\ncalculating perplexity over entire data set...");
            double perplexity = LossSoftmax.calculateMedianPerplexity(model, this.training);
            System.out.println("\nMedian Perplexity = " + String.format("%.4f", perplexity));
        }
        double[] dArray = temperatures = new double[]{1.0, 0.75, 0.5, 0.25, 0.1};
        int n = temperatures.length;
        int n2 = 0;
        while (n2 < n) {
            double temperature = dArray[n2];
            System.out.println("\nTemperature " + temperature + " prediction:");
            String guess = TextGenerationMultifile.generateText(model, reportSequenceLength, false, temperature, rng);
            System.out.println(guess);
            ++n2;
        }
        System.out.println("\nArgmax prediction:");
        String guess = TextGenerationMultifile.generateText(model, reportSequenceLength, true, 1.0, rng);
        System.out.println(guess);
        System.out.println("========================================");
    }

    @Override
    public Nonlinearity getModelOutputUnitToUse() {
        return new LinearUnit();
    }
}

