/*
 * Decompiled with CFR 0.152.
 */
package datasets;

import autodiff.Graph;
import datastructs.DataSequence;
import datastructs.DataSet;
import datastructs.DataStep;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import loss.LossSoftmax;
import matrix.Matrix;
import model.Model;
import nonlinearities.LinearUnit;
import nonlinearities.Nonlinearity;
import theGhastModding.console.main.Console;
import util.Util;

public class TextGeneration
extends DataSet {
    public static int reportSequenceLength = 100;
    private boolean singleWordAutocorrect = false;
    public static boolean reportPerplexity = true;
    private static Map<String, Integer> charToIndex = new HashMap<String, Integer>();
    private static Map<Integer, String> indexToChar = new HashMap<Integer, String>();
    private static int dimension;
    private static double[] vecStartEnd;
    private static final int START_END_TOKEN_INDEX = 0;
    private static Set<String> words;

    static {
        words = new HashSet<String>();
    }

    public List<String> generateText(Model model, int steps, boolean argmax, double temperature, Random rng) throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        Matrix start = new Matrix(dimension);
        start.w[0] = 1.0;
        model.resetState();
        Graph g = new Graph(false);
        Matrix input = start.clone();
        String line = "";
        int s = 0;
        while (s < steps) {
            int i;
            Matrix logprobs = model.forward(input, g);
            Matrix probs = LossSoftmax.getSoftmaxProbs(logprobs, temperature);
            if (this.singleWordAutocorrect) {
                Matrix possible = Matrix.ones(dimension, 1);
                try {
                    possible = TextGeneration.singleWordAutocorrect(line);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                double tot = 0.0;
                i = 0;
                while (i < probs.w.length) {
                    int n = i;
                    probs.w[n] = probs.w[n] * possible.w[i];
                    tot += probs.w[i];
                    ++i;
                }
                i = 0;
                while (i < probs.w.length) {
                    int n = i++;
                    probs.w[n] = probs.w[n] / tot;
                }
                i = 0;
                while (i < probs.w.length) {
                    if (probs.w[i] > 0.0 && possible.w[i] == 0.0) {
                        throw new Exception("Illegal transition");
                    }
                    ++i;
                }
            }
            int indxChosen = -1;
            if (argmax) {
                double high = Double.NEGATIVE_INFINITY;
                i = 0;
                while (i < probs.w.length) {
                    if (probs.w[i] > high) {
                        high = probs.w[i];
                        indxChosen = i;
                    }
                    ++i;
                }
            } else {
                indxChosen = Util.pickIndexFromRandomVector(probs, rng);
            }
            if (indxChosen == 0) {
                lines.add(line);
                line = "";
                input = start.clone();
                g = new Graph(false);
                model.resetState();
                input = start.clone();
            } else {
                String ch = indexToChar.get(indxChosen);
                line = String.valueOf(line) + ch;
                int i2 = 0;
                while (i2 < input.w.length) {
                    input.w[i2] = 0.0;
                    ++i2;
                }
                input.w[indxChosen] = 1.0;
            }
            ++s;
        }
        if (!line.equals("")) {
            lines.add(line);
        }
        return lines;
    }

    private static Matrix singleWordAutocorrect(String sequence) throws Exception {
        if ((sequence = sequence.replace("\"\n\"", " ")).equals("") || sequence.endsWith(" ")) {
            return Matrix.ones(dimension, 1);
        }
        String[] parts = sequence.split(" ");
        String lastPartialWord = parts[parts.length - 1].trim();
        if (lastPartialWord.equals(" ") || lastPartialWord.contains(" ")) {
            throw new Exception("unexpected");
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (String word : words) {
            if (!word.startsWith(lastPartialWord)) continue;
            matches.add(word);
        }
        if (matches.size() == 0) {
            throw new Exception("unexpected, no matches for '" + lastPartialWord + "'");
        }
        Matrix result = new Matrix(dimension);
        boolean hit = false;
        for (String match : matches) {
            if (match.length() < lastPartialWord.length()) {
                throw new Exception("How is match shorter than partial word?");
            }
            if (lastPartialWord.equals(match)) {
                result.w[TextGeneration.charToIndex.get((Object)" ").intValue()] = 1.0;
                result.w[0] = 1.0;
                continue;
            }
            String nextChar = String.valueOf(match.charAt(lastPartialWord.length()));
            result.w[TextGeneration.charToIndex.get((Object)nextChar).intValue()] = 1.0;
            hit = true;
        }
        if (!hit) {
            result.w[TextGeneration.charToIndex.get((Object)" ").intValue()] = 1.0;
            result.w[0] = 1.0;
        }
        return result;
    }

    public static String sequenceToSentence(DataSequence sequence) {
        String result = "\"";
        int s = 0;
        while (s < sequence.steps.size() - 1) {
            DataStep step = sequence.steps.get(s);
            int index = -1;
            int i = 0;
            while (i < step.targetOutput.w.length) {
                if (step.targetOutput.w[i] == 1.0) {
                    index = i;
                    break;
                }
                ++i;
            }
            String ch = indexToChar.get(index);
            result = String.valueOf(result) + ch;
            ++s;
        }
        result = String.valueOf(result) + "\"\n";
        return result;
    }

    public TextGeneration(String path, boolean autocorrect, String charset) throws Exception {
        this.singleWordAutocorrect = autocorrect;
        System.out.println("Text generation task");
        System.out.println("loading " + path + "...");
        File file = new File(path);
        List<String> lines = Files.readAllLines(file.toPath(), Charset.defaultCharset());
        HashSet<String> chars = new HashSet<String>();
        int id = 0;
        charToIndex.put("[START/END]", id);
        indexToChar.put(id, "[START/END]");
        ++id;
        System.out.println("Characters:");
        System.out.print("\t");
        for (String line : lines) {
            String[] parts;
            if (!autocorrect) continue;
            String[] stringArray = parts = line.split(" ");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                words.add(part.trim());
                ++n2;
            }
        }
        int i = 0;
        while (i < charset.length()) {
            String ch = String.valueOf(charset.charAt(i));
            if (!chars.contains(ch)) {
                System.out.print(ch);
                chars.add(ch);
                charToIndex.put(ch, id);
                indexToChar.put(id, ch);
                ++id;
            }
            ++i;
        }
        dimension = chars.size() + 1;
        vecStartEnd = new double[dimension];
        TextGeneration.vecStartEnd[0] = 1.0;
        ArrayList<DataSequence> sequences = new ArrayList<DataSequence>();
        int size = 0;
        for (String line : lines) {
            ArrayList<double[]> vecs = new ArrayList<double[]>();
            vecs.add(vecStartEnd);
            int i2 = 0;
            while (i2 < line.length()) {
                String ch = String.valueOf(line.charAt(i2));
                int index = charToIndex.get(ch);
                double[] vec = new double[dimension];
                vec[index] = 1.0;
                vecs.add(vec);
                ++i2;
            }
            vecs.add(vecStartEnd);
            DataSequence sequence = new DataSequence();
            int i3 = 0;
            while (i3 < vecs.size() - 1) {
                sequence.steps.add(new DataStep((double[])vecs.get(i3), (double[])vecs.get(i3 + 1)));
                ++size;
                ++i3;
            }
            sequences.add(sequence);
        }
        System.out.println("Total unique chars = " + chars.size());
        System.out.println(String.valueOf(size) + " steps in training set.");
        this.training = sequences;
        this.lossTraining = new LossSoftmax();
        this.lossReporting = new LossSoftmax();
        this.inputDimension = ((DataSequence)sequences.get((int)0)).steps.get((int)0).input.w.length;
        int loc = 0;
        while (((DataSequence)sequences.get((int)0)).steps.get((int)loc).targetOutput == null) {
            ++loc;
        }
        this.outputDimension = ((DataSequence)sequences.get((int)0)).steps.get((int)loc).targetOutput.w.length;
    }

    public TextGeneration(String path, boolean autocorrect) throws Exception {
        this.singleWordAutocorrect = autocorrect;
        System.out.println("Text generation task");
        System.out.println("loading " + path + "...");
        File file = new File(path);
        List<String> lines = Files.readAllLines(file.toPath(), Charset.defaultCharset());
        HashSet<String> chars = new HashSet<String>();
        int id = 0;
        charToIndex.put("[START/END]", id);
        indexToChar.put(id, "[START/END]");
        ++id;
        System.out.println("Characters:");
        System.out.print("\t");
        for (String line : lines) {
            if (autocorrect) {
                String[] parts;
                String[] stringArray = parts = line.split(" ");
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    words.add(part.trim());
                    ++n2;
                }
            }
            int i = 0;
            while (i < line.length()) {
                String ch = String.valueOf(line.charAt(i));
                if (!chars.contains(ch)) {
                    System.out.print(ch);
                    chars.add(ch);
                    charToIndex.put(ch, id);
                    indexToChar.put(id, ch);
                    ++id;
                }
                ++i;
            }
        }
        dimension = chars.size() + 1;
        vecStartEnd = new double[dimension];
        TextGeneration.vecStartEnd[0] = 1.0;
        ArrayList<DataSequence> sequences = new ArrayList<DataSequence>();
        int size = 0;
        for (String line : lines) {
            ArrayList<double[]> vecs = new ArrayList<double[]>();
            vecs.add(vecStartEnd);
            int i = 0;
            while (i < line.length()) {
                String ch = String.valueOf(line.charAt(i));
                int index = charToIndex.get(ch);
                double[] vec = new double[dimension];
                vec[index] = 1.0;
                vecs.add(vec);
                ++i;
            }
            vecs.add(vecStartEnd);
            DataSequence sequence = new DataSequence();
            int i2 = 0;
            while (i2 < vecs.size() - 1) {
                sequence.steps.add(new DataStep((double[])vecs.get(i2), (double[])vecs.get(i2 + 1)));
                ++size;
                ++i2;
            }
            sequences.add(sequence);
        }
        System.out.println("Total unique chars = " + chars.size());
        System.out.println(String.valueOf(size) + " steps in training set.");
        this.training = sequences;
        this.lossTraining = new LossSoftmax();
        this.lossReporting = new LossSoftmax();
        this.inputDimension = ((DataSequence)sequences.get((int)0)).steps.get((int)0).input.w.length;
        int loc = 0;
        while (((DataSequence)sequences.get((int)0)).steps.get((int)loc).targetOutput == null) {
            ++loc;
        }
        this.outputDimension = ((DataSequence)sequences.get((int)0)).steps.get((int)loc).targetOutput.w.length;
    }

    @Override
    public void DisplayReport(Model model, Random rng, Console c) throws Exception {
        double[] temperatures;
        System.out.println("========================================");
        System.out.println("REPORT:");
        if (reportPerplexity) {
            System.out.println("\ncalculating perplexity over entire data set...");
            double perplexity = LossSoftmax.calculateMedianPerplexity(model, this.training);
            System.out.println("\nMedian Perplexity = " + String.format("%.4f", perplexity));
        }
        double[] dArray = temperatures = new double[]{1.0, 0.75, 0.5, 0.25, 0.1};
        int n = temperatures.length;
        int n2 = 0;
        while (n2 < n) {
            double temperature = dArray[n2];
            if (this.singleWordAutocorrect) {
                System.out.println("\nTemperature " + temperature + " prediction (with single word autocorrect):");
            } else {
                System.out.println("\nTemperature " + temperature + " prediction:");
            }
            List<String> guess = this.generateText(model, reportSequenceLength, false, temperature, rng);
            int i = 0;
            while (i < guess.size()) {
                if (!guess.get(i).isEmpty()) {
                    if (i == guess.size() - 1) {
                        System.out.println("\t\"" + guess.get(i) + "...\"");
                    } else {
                        System.out.println("\t\"" + guess.get(i) + "\"");
                    }
                }
                ++i;
            }
            ++n2;
        }
        if (this.singleWordAutocorrect) {
            System.out.println("\nArgmax prediction (with single word autocorrect):");
        } else {
            System.out.println("\nArgmax prediction:");
        }
        List<String> guess = this.generateText(model, reportSequenceLength, true, 1.0, rng);
        int i = 0;
        while (i < guess.size()) {
            if (!guess.get(i).isEmpty()) {
                if (i == guess.size() - 1) {
                    System.out.println("\t\"" + guess.get(i) + "...\"");
                } else {
                    System.out.println("\t\"" + guess.get(i) + "\"");
                }
            }
            ++i;
        }
        System.out.println("========================================");
    }

    @Override
    public Nonlinearity getModelOutputUnitToUse() {
        return new LinearUnit();
    }
}

