/*
 * Decompiled with CFR 0.152.
 */
package datasets;

import datasets.NerdPone;
import datastructs.DataSequence;
import datastructs.DataSet;
import datastructs.DataStep;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import loss.LossSoftmax;
import model.Model;
import nonlinearities.LinearUnit;
import nonlinearities.Nonlinearity;
import theGhastModding.console.main.Console;
import util.ImageUtil;

public class NerdPonies
extends DataSet {
    private Map<String, Integer> charToIndex = new HashMap<String, Integer>();
    private Map<Integer, String> indexToChar = new HashMap<Integer, String>();

    public NerdPonies(File baseFile, NerdPone ... pones) throws Exception {
        System.out.println("Nerd Pone dataset initializing...");
        this.training = new ArrayList();
        File tempFolder = new File("pones_temp/");
        if (!tempFolder.exists()) {
            tempFolder.mkdir();
        }
        File[] fileArray = tempFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            f.delete();
            ++n2;
        }
        File tempBasesFolder = new File("bases_temp/");
        if (!tempBasesFolder.exists()) {
            tempBasesFolder.mkdir();
        }
        Object[] objectArray = tempBasesFolder.listFiles();
        int n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            File f = objectArray[n];
            f.delete();
            ++n;
        }
        System.out.println("Preparing pones...");
        objectArray = pones;
        n3 = pones.length;
        n = 0;
        while (n < n3) {
            Object p = objectArray[n];
            BufferedImage image = ImageIO.read(baseFile);
            image.setRGB(0, 0, Color.WHITE.getRGB());
            image.setRGB(0, 1, Color.WHITE.getRGB());
            if (((NerdPone)p).getRace() == 2) {
                image.setRGB(0, 0, Color.BLACK.getRGB());
            }
            if (((NerdPone)p).getRace() == 1) {
                image.setRGB(0, 1, Color.BLACK.getRGB());
            }
            int counter = 0;
            Color[] colorArray = ((NerdPone)p).getColorPallete();
            int n4 = colorArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Color c = colorArray[n5];
                image.setRGB(0, 2 + counter, c.getRGB());
                ++counter;
                ++n5;
            }
            String name = Long.toString(System.currentTimeMillis());
            ImageUtil.toText(image, new File("bases_temp/base_" + name + ".txt"), "Nerd Pony database by TheGhastModding");
            ImageUtil.toText(((NerdPone)p).getImage(), new File("pones_temp/" + name + ".txt"), "Nerd Pony database by TheGhastModding");
            ++n;
        }
        System.out.println("Loading dataset...");
        int size = 0;
        int id = 0;
        String possibleCharacters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.@#_:/-, \n";
        int i = 0;
        while (i < possibleCharacters.length()) {
            String ch = String.valueOf(possibleCharacters.charAt(i));
            System.out.print(ch);
            this.charToIndex.put(ch, id);
            this.indexToChar.put(id, ch);
            ++id;
            ++i;
        }
        File[] fileArray2 = tempFolder.listFiles();
        int n6 = fileArray2.length;
        int n7 = 0;
        while (n7 < n6) {
            File f = fileArray2[n7];
            List<String> lines_ = Files.readAllLines(f.toPath(), Charset.defaultCharset());
            File baseFilee = null;
            File[] fileArray3 = tempBasesFolder.listFiles();
            int n8 = fileArray3.length;
            int n9 = 0;
            while (n9 < n8) {
                File f2 = fileArray3[n9];
                if (f2.getName().contains(f.getName())) {
                    baseFilee = f2;
                }
                ++n9;
            }
            List<String> baseLines_ = Files.readAllLines(baseFilee.toPath(), Charset.defaultCharset());
            String text = "";
            for (String s : lines_) {
                text = String.valueOf(text) + s + "\n";
            }
            String baseText = "";
            for (String s : baseLines_) {
                baseText = String.valueOf(baseText) + s + "\n";
            }
            if (text.length() != baseText.length()) {
                throw new Exception("Base and pony don't have the same image resolution");
            }
            DataSequence sequence = new DataSequence();
            int i2 = 0;
            while (i2 < text.length()) {
                String ch = String.valueOf(text.charAt(i2));
                int index = this.charToIndex.get(ch);
                double[] vec = new double[possibleCharacters.length()];
                vec[index] = 1.0;
                ch = String.valueOf(baseText.charAt(i2));
                index = this.charToIndex.get(ch);
                double[] vec2 = new double[possibleCharacters.length()];
                vec2[index] = 1.0;
                sequence.steps.add(new DataStep(vec2, vec));
                ++size;
                ++i2;
            }
            this.training.add(sequence);
            ++n7;
        }
        this.lossTraining = new LossSoftmax();
        this.lossReporting = new LossSoftmax();
        this.inputDimension = ((DataSequence)this.training.get((int)0)).steps.get((int)0).input.w.length;
        int loc = 0;
        while (((DataSequence)this.training.get((int)0)).steps.get((int)loc).targetOutput == null) {
            ++loc;
        }
        this.outputDimension = ((DataSequence)this.training.get((int)0)).steps.get((int)loc).targetOutput.w.length;
        System.out.println(String.valueOf(Integer.toString(size)) + " steps in training set.");
        System.out.println("done.");
    }

    @Override
    public void DisplayReport(Model model, Random rng, Console c) throws Exception {
        if (c != null) {
            System.out.println("Report currently unimplemented. Sorry about that. But we can atleast give you the median perplexity: " + Double.toString(LossSoftmax.calculateMedianPerplexity(model, this.training)));
        } else {
            System.out.println("Report currently unimplemented. Sorry about that. But we can atleast give you the median perplexity: " + Double.toString(LossSoftmax.calculateMedianPerplexity(model, this.training)));
        }
    }

    @Override
    public Nonlinearity getModelOutputUnitToUse() {
        return new LinearUnit();
    }
}

