/*
 * Decompiled with CFR 0.152.
 */
package datasets;

import datastructs.DataSequence;
import datastructs.DataSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import model.Model;
import nonlinearities.Nonlinearity;
import theGhastModding.console.main.Console;

public class BatchedSet
extends DataSet {
    private DataSet original;
    private List<List<DataSequence>> batches;

    public BatchedSet(DataSet original, int batchSize) {
        this.original = original;
        this.inputDimension = original.inputDimension;
        this.outputDimension = original.outputDimension;
        this.lossReporting = original.lossReporting;
        this.lossTraining = original.lossTraining;
        this.validation = original.validation;
        this.testing = original.testing;
        this.batches = new ArrayList<List<DataSequence>>();
        int batchCount = original.training.size() / batchSize;
        int pos = 0;
        int i = 0;
        while (i < batchCount) {
            this.batches.add(new ArrayList());
            int j = 0;
            while (j < batchSize) {
                this.batches.get(i).add(original.training.get(pos));
                if (++pos >= original.training.size()) {
                    i = batchCount + 10;
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.training = this.batches.get(0);
    }

    public void setAvtiveBatch(int i) {
        this.training = this.batches.get(i);
    }

    public int getBatchCount() {
        return this.batches.size();
    }

    @Override
    public void DisplayReport(Model model, Random rng, Console c) throws Exception {
        this.original.DisplayReport(model, rng, c);
    }

    @Override
    public Nonlinearity getModelOutputUnitToUse() {
        return this.original.getModelOutputUnitToUse();
    }
}

