/*
 * Decompiled with CFR 0.152.
 */
package com.leff.midi.event.meta;

import com.leff.midi.event.MidiEvent;
import com.leff.midi.event.meta.GenericMetaEvent;
import com.leff.midi.event.meta.MetaEvent;
import com.leff.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.OutputStream;

public class MidiChannelPrefix
extends MetaEvent {
    private int mChannel;

    public MidiChannelPrefix(long tick, long delta, int channel) {
        super(tick, delta, 32, new VariableLengthInt(4));
        this.mChannel = channel;
    }

    @Override
    public MidiEvent clone() {
        return new MidiChannelPrefix(this.mTick, this.mDelta.getValue(), this.mChannel);
    }

    public void setChannel(int c) {
        this.mChannel = c;
    }

    public int getChannel() {
        return this.mChannel;
    }

    @Override
    protected int getEventSize() {
        return 4;
    }

    @Override
    public void writeToFile(OutputStream out) throws IOException {
        super.writeToFile(out);
        out.write(1);
        out.write(this.mChannel);
    }

    public static MetaEvent parseMidiChannelPrefix(long tick, long delta, MetaEvent.MetaEventData info) {
        if (info.length.getValue() != 1) {
            return new GenericMetaEvent(tick, delta, info);
        }
        byte channel = info.data[0];
        return new MidiChannelPrefix(tick, delta, channel);
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick != other.getTick()) {
            return this.mTick < other.getTick() ? -1 : 1;
        }
        if ((long)this.mDelta.getValue() != other.getDelta()) {
            return (long)this.mDelta.getValue() < other.getDelta() ? 1 : -1;
        }
        if (!(other instanceof MidiChannelPrefix)) {
            return 1;
        }
        MidiChannelPrefix o = (MidiChannelPrefix)other;
        if (this.mChannel != o.mChannel) {
            return this.mChannel < o.mChannel ? -1 : 1;
        }
        return 0;
    }
}

