/*
 * Decompiled with CFR 0.152.
 */
package com.leff.midi.event.meta;

import com.leff.midi.event.MidiEvent;
import com.leff.midi.event.meta.CopyrightNotice;
import com.leff.midi.event.meta.CuePoint;
import com.leff.midi.event.meta.EndOfTrack;
import com.leff.midi.event.meta.GenericMetaEvent;
import com.leff.midi.event.meta.InstrumentName;
import com.leff.midi.event.meta.KeySignature;
import com.leff.midi.event.meta.Lyrics;
import com.leff.midi.event.meta.Marker;
import com.leff.midi.event.meta.MidiChannelPrefix;
import com.leff.midi.event.meta.SequenceNumber;
import com.leff.midi.event.meta.SequencerSpecificEvent;
import com.leff.midi.event.meta.SmpteOffset;
import com.leff.midi.event.meta.Tempo;
import com.leff.midi.event.meta.Text;
import com.leff.midi.event.meta.TimeSignature;
import com.leff.midi.event.meta.TrackName;
import com.leff.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class MetaEvent
extends MidiEvent {
    protected int mType;
    protected VariableLengthInt mLength;
    public static final int SEQUENCE_NUMBER = 0;
    public static final int TEXT_EVENT = 1;
    public static final int COPYRIGHT_NOTICE = 2;
    public static final int TRACK_NAME = 3;
    public static final int INSTRUMENT_NAME = 4;
    public static final int LYRICS = 5;
    public static final int MARKER = 6;
    public static final int CUE_POINT = 7;
    public static final int MIDI_CHANNEL_PREFIX = 32;
    public static final int END_OF_TRACK = 47;
    public static final int TEMPO = 81;
    public static final int SMPTE_OFFSET = 84;
    public static final int TIME_SIGNATURE = 88;
    public static final int KEY_SIGNATURE = 89;
    public static final int SEQUENCER_SPECIFIC = 127;

    protected MetaEvent(long tick, long delta, int type, VariableLengthInt length) {
        super(tick, delta);
        this.mType = type & 0xFF;
        this.mLength = length;
    }

    @Override
    protected abstract int getEventSize();

    @Override
    public void writeToFile(OutputStream out, boolean writeType) throws IOException {
        this.writeToFile(out);
    }

    protected void writeToFile(OutputStream out) throws IOException {
        super.writeToFile(out, true);
        out.write(255);
        out.write(this.mType);
    }

    public static MetaEvent parseMetaEvent(long tick, long delta, InputStream in) throws IOException {
        MetaEventData eventData = new MetaEventData(in);
        boolean isText = false;
        switch (eventData.type) {
            case 0: 
            case 32: 
            case 47: 
            case 81: 
            case 84: 
            case 88: 
            case 89: {
                break;
            }
            default: {
                isText = true;
            }
        }
        if (isText) {
            String text = new String(eventData.data);
            switch (eventData.type) {
                case 1: {
                    return new Text(tick, delta, text);
                }
                case 2: {
                    return new CopyrightNotice(tick, delta, text);
                }
                case 3: {
                    return new TrackName(tick, delta, text);
                }
                case 4: {
                    return new InstrumentName(tick, delta, text);
                }
                case 5: {
                    return new Lyrics(tick, delta, text);
                }
                case 6: {
                    return new Marker(tick, delta, text);
                }
                case 7: {
                    return new CuePoint(tick, delta, text);
                }
                case 127: {
                    return new SequencerSpecificEvent(tick, delta, eventData.data);
                }
            }
            return new GenericMetaEvent(tick, delta, eventData);
        }
        switch (eventData.type) {
            case 0: {
                return SequenceNumber.parseSequenceNumber(tick, delta, eventData);
            }
            case 32: {
                return MidiChannelPrefix.parseMidiChannelPrefix(tick, delta, eventData);
            }
            case 47: {
                return new EndOfTrack(tick, delta);
            }
            case 81: {
                return Tempo.parseTempo(tick, delta, eventData);
            }
            case 84: {
                return SmpteOffset.parseSmpteOffset(tick, delta, eventData);
            }
            case 88: {
                return TimeSignature.parseTimeSignature(tick, delta, eventData);
            }
            case 89: {
                return KeySignature.parseKeySignature(tick, delta, eventData);
            }
        }
        System.out.println("Completely broken in MetaEvent.parseMetaEvent()");
        return null;
    }

    protected static class MetaEventData {
        public final int type;
        public final VariableLengthInt length;
        public final byte[] data;

        public MetaEventData(InputStream in) throws IOException {
            this.type = in.read();
            this.length = new VariableLengthInt(in);
            this.data = new byte[this.length.getValue()];
            if (this.length.getValue() > 0) {
                in.read(this.data);
            }
        }
    }
}

